/* ---------------------------------------------------------- 
%   (C)1993,1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#include <stdio.h>  /* NULL */
#include <klic/basic.h>  /* fatal, klic_fprintf, klic_putc */
#include <klic/struct.h>
#include <klic/primitives.h>  /* enqueue_goal */
#include "schedule.h"
#include <klic/gb.h>
#include "gobj.h"
#include <klic/susp.h>
#include <klic/unify.h>  /* do_unify* */
#include "trace.h"  /* trace_flag, trace_resumption */
#include "step.h"  /* stepping_flag, step_wokenup */

extern struct predicate predicate_unify__term__dcode_xunify_2;
extern struct predicate predicate_unify__term__dcode_xunify__goal_2;

/************
 * rest_of_stream
 *
 * indicates the next hooked term.
 *
 * 0: normal;
 * other: the next hooked term
 ************/
static q rest_of_stream;
static q method_result;
extern void set_rest_of_stream(q term){ rest_of_stream = term; }
extern void set_method_result(q term){ method_result = term; }

static void enqueue_unify_terms(q x, q y)
{
  struct goalrec* gp = (struct goalrec*) klic_alloc(4);
  gp->next = (struct goalrec*) makeint(current_prio());
  gp->pred = &predicate_unify__term__dcode_xunify_2;
  gp->args[0] = x;
  gp->args[1] = y;
  resume_same_prio(gp);
}

static void enqueue_unify_goal(q x, q y)
{
  struct goalrec* gp = (struct goalrec*) klic_alloc(4);
  gp->next = (struct goalrec*) makeint(current_prio());
  gp->pred = &predicate_unify__term__dcode_xunify__goal_2;
  gp->args[0] = (x);
  gp->args[1] = (y);
  resume_same_prio(gp);
}

/* Resume a goal with the same priority as current */

extern void
resume_same_prio(gp)
     struct goalrec *gp;
{
  declare_globals;
  add_resumed_goal(gp);
  heaplimit = 0;
}

/*
  resume the goals which has been hooked to variable `x'.
  by the unification with `y'
*/

static void
resume_goals(x, y)
     q x;
     q y;
{
  declare_globals;
  q* allocp = heapp();

  /* Variable x with suspended goals is instantiated here */
  /* x points suspension record directly. */

  struct susprec *susprecord = suspp(x);

  if(is_generator_susp(susprecord->u)) {
    /* generator_object */
    struct generator_susp *gsusp = generator_suspp(susprecord);
    struct generator_object *gobj = untag_generator_susp(gsusp->u.o);
    int unified;
    q backpt = gsusp->backpt;

    set_heapp(allocp);
    unified = method_table_of(gobj)->active_unify(gsusp->backpt, y);
    if(unified) {
      /* Unify method was succeeded */
      allocp = heapp();
      /* derefone(backpt) = y; */
    } else {
      /* failed */
      q tmp;
      set_heapp(allocp);
      tmp = generic_generate(gobj);

      switch((long)tmp) {
      case (long)makeref(0):
	/* x is a reference to suspension record. thus
	   derefone is needed for enqueue */
	set_heapp(allocp);
	enqueue_unify_goal(derefone(x), y);
	allocp = heapp();
	break;
      case (long)makecons(0):
	fatal("invalid situation in generator unification");
      default:
	allocp = heapp();
	derefone(gsusp->backpt) =  tmp;
	if(isref(tmp) && tmp == derefone(tmp)) {
	  derefone(tmp) = y;
	} else {
	  set_heapp(allocp);
	  do_unify(tmp, y);
	  allocp = heapp();
	}
      }
    }
  } else {
    struct hook *top = susprecord->u.first_hook.next;
    struct hook *loopp = top;

    derefone(susprecord->backpt) = y;

    do {
      union goal_or_consumer u;
      u = loopp->u;
      if (u.l != 0) {
	if (is_consumer_hook(u)) {
	  struct consumer_object *obj = untag_consumer_hook(u.o);
	  q tmpval;
	  long keepp = loopp->u.l;
	  loopp->u.l = 0;
	  set_heapp(allocp);
	  generic_active_unify(obj, y);
	  allocp = heapp();
	  switch ((long)method_result) {
	  case (long)GENERIC_FAILED:
	    fatal("Unification failure on a consumer object");
	  case (long)GENERIC_SUCCEEDED:
	    if(rest_of_stream == NULL) goto consumer_terminate;
/*	    y = rest_of_stream;*/
	    tmpval = rest_of_stream;
	    break;
	  case (long)GENERIC_GCREQUEST:
	    /* This case, make the hook chain which contains
	       rest of consumer objects and goals. */
	    {
	      q newvar = makeref(allocp);
	      allocp++;
	      susprecord->u.first_hook.next = loopp;
	      loopp->u.l = keepp;
	      susprecord->backpt = newvar;
	      derefone(newvar) = (q)susprecord;
	      set_heapp(allocp);
	      enqueue_unify_goal(y, newvar);
	    }
	    /* exit the loop */
	    return;
	  default:
	    tmpval = method_result;
	  }
	  {
	    struct susprec *susp;
	    q newvar;
	    set_heapp(allocp);
	    makenewsusp(newvar, susp);
	    allocp = heapp();
	    susp->u.first_hook.u.o = tag_consumer_hook(obj);
	    if (derefone(tmpval) == tmpval) {
	      derefone(tmpval) = newvar;
	    } else {
	      set_heapp(allocp);
	      enqueue_unify_goal(tmpval, newvar);
	      allocp = heapp();
	    }
	  }
	consumer_terminate:;
	} else if (isint(u.g->next)) {
	  long gp = intval(u.g->next);
	  if (stepping_flag) {
	    u.g->next = 0;	/* to nullify deadlock check */
	    step_wokenup(u.g, gp);
	  } else
	    {
	      if (gp != current_prio()) {
		(void) enqueue_goal(NULL, gp, u.g, glbl);
	      } else {
		resume_same_prio(u.g);
	      }
	      if(trace_flag) trace_resumption(u.g);
	    }
	  inc_resumes();
	}
      }
      loopp = loopp->next;
    } while (loopp != top);
  }
  set_heapp(allocp);
}

static Inline void
generator_unify(gsx, sy)
     struct generator_susp *gsx;
     struct susprec *sy;
/*
   sx is a suspension structure
   and y is hook or generator
*/
{
  declare_globals;
  int unified;
  q* allocp = heapp();

  /* At first, try unify method */
  set_heapp(allocp);
  unified = method_table_of(untag_generator_susp(gsx->u.o))->
    active_unify(gsx->backpt, sy->backpt);
  if(unified) {
    /* succeeded */
    allocp = heapp();
    /* derefone(gsx->backpt) = sy->backpt; */
  } else {
    /* unify of x is failed */
    if(is_generator_susp(sy->u)) {
      struct generator_susp *gsy = generator_suspp(sy);
      int unified;

      set_heapp(allocp);
      unified = method_table_of(untag_generator_susp(gsy->u.o))->
	active_unify(gsy->backpt, gsx->backpt);
      if(unified) {
	allocp = heapp();
	/* derefone(gsy->backpt) = gsx->backpt; */
      } else {
	/* x and y are both generator,
	   but both failed. */
	struct generator_object *gobjx = untag_generator_susp(gsx->u.o);
	q tmpx;
	set_heapp(allocp);
	tmpx = generic_generate(gobjx);
	switch((long)tmpx) {
	case (long)makeref(0): {
	  /* failed */
	  struct generator_object *gobjy = untag_generator_susp(gsy->u.o);
	  q tmpy;
	  set_heapp(allocp);
	  tmpy = generic_generate(gobjy);
	  switch((long)tmpy) {
	  case (long)makeref(0):
	    set_heapp(allocp);
	    enqueue_unify_goal(gsx->backpt, sy->backpt);
	    allocp = heapp();
	    break;
	  case (long)makecons(0):
	    fatal("invalid situation at the generator unification");
	  default:
	    allocp = heapp();
	    derefone(gsy->backpt) = tmpy;
	    if(isref(tmpy) && tmpy == derefone(tmpy)) {
	      derefone(tmpy) = gsx->backpt;
	    } else {
	      set_heapp(allocp);
	      do_unify(tmpy, gsx->backpt);
	      allocp = heapp();
	    }
	  }
	  break;
	}
	case (long)makecons(0):
	  fatal("invalid situation at the generator unification");
	default:
	  allocp = heapp();
	  gsx->backpt = tmpx;
	  if(isref(tmpx) && tmpx == derefone(tmpx)) {
	    derefone(sy->backpt) = tmpx;
	  } else {
	    set_heapp(allocp);
	    do_unify(tmpx, sy->backpt);
	    return;
	  }
	}
      }
    } else {
      /* The unify method for x is failed and
	 y is hook */
      struct generator_object *gobjx = untag_generator_susp(gsx->u.o);
      q tmpx;
      set_heapp(allocp);
      tmpx = generic_generate(gobjx);
      switch((long)tmpx) {
      case (long)makeref(0): /* GC request */
	set_heapp(allocp);
	enqueue_unify_goal(gsx->backpt, sy->backpt);
	allocp = heapp();
	break;
      case (long)makecons(0): /* invalid */
	fatal("invalid situation at the generator unification");
      default:
        allocp = heapp();
	derefone(gsx->backpt) = tmpx;
	if(isref(tmpx) && tmpx == derefone(tmpx)) {
	  derefone(tmpx) = sy->backpt;
	} else {
	  set_heapp(allocp);
	  do_unify(tmpx, sy->backpt);
	  return;
	}
      }
    }
  }
  set_heapp(allocp);
}

extern void
do_unify(x, y)
     q x, y;
{
#ifdef UNIFYDEBUG
  klic_fprintf(stdout, "Unify with ");
  print(x);
  klic_fprintf(stdout, ",");
  print(y);
  klic_fprintf(stdout, "\n");
#endif
  if (isref(x)) {
    q temp = derefone(x);
  deref_x:
    if (x != temp){
      if (isref(temp)) {
	q temp1 = derefone(temp);
	if (temp1 == x) {
	  while (isref(y)) {
	    q ytemp = derefone(y);
	    if (y == ytemp) {
	      /* Suspension records must be referenced through REF. */
	      /* Thus, doing "derefone(y) = temp;" here is buggy. */
	      derefone(y) = x;
	      return;
	    } else {
	      if (isref(ytemp) && derefone(ytemp) == y) {
		y = ytemp;
		x =  temp;
		if (x != y) {
		  /* merge two hook chains */
		  struct susprec *sx = (struct susprec *)x;
		  struct susprec *sy = (struct susprec *)y;
		  if(is_generator_susp(sx->u)) {
		    generator_unify(generator_suspp(sx), sy);
		    return;
		  } else if(is_generator_susp(sy->u)) {
		    generator_unify(generator_suspp(sy), sx);
		    return;
		  } else {
		    /* Both x and y are not generator */
		    /* None of two is generator, then merge ... */
		    struct hook *second_of_x = sx->u.first_hook.next;
		    /* connect sx and topy */
		    sx->u.first_hook.next = sy->u.first_hook.next;
		    sy->u.first_hook.next = second_of_x;
		    derefone(sy->backpt) = sx->backpt;
		  }
		}
		return;
	      }
	    }
	    y = ytemp;
	  }
	  /* x is hook variable and y points a real object */
	  resume_goals(temp, y);
	  return;
	} else {
	  x = temp;
	  temp = temp1;
	  goto deref_x;
	}
      } else {
	x = temp;
      }
    } else {
      /* dereference y */
      while (isref(y)) {
	temp = derefone(y);
	if (temp == y || (isref(temp) && derefone(temp) == y)) break;
	y = temp;
      }
      derefone(x) = y;		/* this also handles x==y cases */
      return;
    }
  }

  /* x is bound */
  while (isref(y)) {
    q temp = derefone(y);
    if (temp == y) { /* y is undef cell */
      derefone(y) = x;
      return;
    } else {
      if(isref(temp) && derefone(temp) == y) {
	resume_goals(temp, x);
	return;
      }
    }
    y = temp;
  }

  /* Both x and y are bound */
  if (x != y) {
    declare_globals;
    enqueue_unify_terms(x, y);
  } 
}

extern void
do_shallow_unify(x, y)
     q x, y;
{
  /*
    Unifier that does never call unification recursively.
    To realize this, we make goals not only for recursive unifications
    but also for unification with hooked variables, to avoid the
    unifier to be called recursively from generic objects.
  */
  declare_globals;
  q* allocp = heapp();
  if (isref(x)) {
    q temp = derefone(x);
  deref_x:
    if (x != temp){
      if (isref(temp)) {
	q temp1 = derefone(temp);
	if (temp1 == x) {
	  while (isref(y)) {
	    q ytemp = derefone(y);
	    if (y == ytemp) {
	      /* Suspension records must be referenced through REF. */
	      /* Thus, doing "derefone(y) = temp;" here is buggy. */
	      derefone(y) = x;
	      set_heapp(allocp);
	      return;
	    } else {
	      if (isref(ytemp) && derefone(ytemp) == y) {
		set_heapp(allocp);
		enqueue_unify_goal(x, y);
		return;
	      }
	    }
	    y = ytemp;
	  }
	  /* x is hook variable and y points a real object */
	  set_heapp(allocp);
	  enqueue_unify_goal(x, y);
	  return;
	} else {
	  x = temp;
	  temp = temp1;
	  goto deref_x;
	}
      } else {
	x = temp;
      }
    } else {
      /* dereference y */
      while (isref(y)) {
	temp = derefone(y);
	if (temp == y || (isref(temp) && derefone(temp) == y)) break;
	y = temp;
      }
      derefone(x) = y;		/* this also handles x==y cases */
      set_heapp(allocp);
      return;
    }
  }

  /* x is bound */
  while (isref(y)) {
    q temp = derefone(y);
    if (temp == y) { /* y is undef cell */
      derefone(y) = x;
      set_heapp(allocp);
      return;
    } else {
      if(isref(temp) && derefone(temp) == y) {
	set_heapp(allocp);
	enqueue_unify_goal(x, y);
	return;
      }
    }
    y = temp;
  }

  /* Both x and y are bound */
  if (x != y) {
    set_heapp(allocp);
    enqueue_unify_goal(x, y);
    allocp = heapp();
  } 
  set_heapp(allocp);
}

extern void
do_unify2(x, y, z, w)
     q x, y, z, w;
{
  do_unify(x, y);
  do_unify(z, w);
}

extern void
do_unify3(x, y, z, w, s, t)
     q x, y, z, w, s, t;
{
  do_unify(x, y);
  do_unify(z, w);
  do_unify(s, t);
}

extern void
do_unify4(x, y, z, w, s, t, u, v)
     q x, y, z, w, s, t, u, v;
{
  do_unify(x, y);
  do_unify(z, w);
  do_unify(s, t);
  do_unify(u, v);
}

/*
  do_unify_value(allocp, x, y)
	"do_unify" for when "y" is known to be instantiated.
*/
extern void
do_unify_value(x, y)
     q x, y;
{
  q* allocp = heapp();

  if (isref(x)) {
    q temp = derefone(x);
    if (x == temp) {
      derefone(x) = y;
      set_heapp(allocp);
      return;
    } else if (isref(temp)) {
      q temp1;
    again:
      temp1 = derefone(temp);
      if (isref(temp1)) {
	if (temp1 == temp) {
	  derefone(temp) = y;
	  set_heapp(allocp);
	  return;
	} else if (temp1 == x) {
	  set_heapp(allocp);
	  resume_goals(temp, y);
	  return;
	} else {
	  x = temp;
	  temp = temp1;
	  goto again;
	}
      } else {
	do_unify(temp1, y);
	return;
      }
    } else {
      do_unify(temp, y);
      return;
    }
  }
  do_unify(x, y);
}

extern void
do_shallow_unify_value(x, y)
     q x, y;
{
  q* allocp = heapp();
  if (isref(x)) {
    q temp = derefone(x);
    if (x == temp) {
      derefone(x) = y;
      set_heapp(allocp);
      return;
    } else if (isref(temp)) {
      q temp1;
    again:
      temp1 = derefone(temp);
      if (isref(temp1)) {
	if (temp1 == temp) {
	  derefone(temp) = y;
	  set_heapp(allocp);
	  return;
	} else if (temp1 == x) {
	  set_heapp(allocp);
	  resume_goals(temp, y);
	  return;
	} else {
	  x = temp;
	  temp = temp1;
	  goto again;
	}
      } else {
	set_heapp(allocp);
	do_shallow_unify(temp1, y);
	return;
      }
    } else {
      set_heapp(allocp);
      do_shallow_unify(temp, y);
      return;
    }
  }
  set_heapp(allocp);
  do_shallow_unify(x, y);
}

extern void
do_unify_value2(x, y, z, w)
     q x, y, z, w;
{
  do_unify_value(x, y);
  do_unify_value(z, w);
}

extern void
do_unify_value3(x, y, z, w, s, t)
     q x, y, z, w, s, t;
{
  do_unify_value(x, y);
  do_unify_value(z, w);
  do_unify_value(s, t);
}

extern void
do_unify_value4(x, y, z, w, s, t, u, v)
     q x, y, z, w, s, t, u, v;
{
  do_unify_value(x, y);
  do_unify_value(z, w);
  do_unify_value(s, t);
  do_unify_value(u, v);
}
