/* ----------------------------------------------------------
%   (C)1993,1994 Institute for New Generation Computer Technology
%       (Read COPYRIGHT for detailed information.)
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */
/*
  Object table
*/

#include <klic/alloc.h>  /* register_after_gc_hook */
#include <klic/basic.h>  /* fatal */
#include <klic/struct.h>
#include <klic/g_basic.h>
#include <klic/g_methtab.h>

extern char* calloc();

#define OTBLBLKSIZE 100

#define generic_deallocate(obj)  (obj)->method_table->deallocate(obj)

struct object_table {
  unsigned int type;
  void* obj;
  struct object_table* next;
};

static struct object_table* tbl_root = NULL;
static struct object_table* free_oent = NULL;

static Inline struct object_table*
allocOtblBulk()
{
  int i;
  struct object_table* ptr =
    (struct object_table*) calloc(sizeof(struct object_table), OTBLBLKSIZE);
  struct object_table* top = ptr;

  if( ptr == NULL )
    fatal("Memory exhausted allocating object table");

  for( i=0; i<OTBLBLKSIZE; i++, ptr++ ){
    ptr->next = ptr+1;
  }

  (ptr-1)->next = NULL;

  return top;
}

static Inline struct object_table*
allocOtblEnt()
{
  struct object_table* ent;
  ent = (free_oent != NULL ? free_oent : allocOtblBulk());

  free_oent = ent->next;
  return ent;
}

static void
deallocate_garbage(void)
{
  struct object_table* tbl = tbl_root;
  struct object_table* newtbl = NULL;
  struct object_table** ptr = &newtbl;
  struct object_table* free = free_oent;

  while( tbl != NULL ){
    struct object_table* next = tbl->next;
    struct data_object* obj = tbl->obj;
    q newplace = (q) obj->method_table;

    if( !isstruct(newplace) ){  /* the object is garbage */
      switch( tbl->type ){
      case G_DATA:
	generic_deallocate(obj);
	break;
      case G_CONSUMER:
	generic_deallocate((struct consumer_object*) obj);
	break;
      case G_GENERATOR:
	generic_deallocate((struct generator_object*) obj);
	break;
      default:
	fatal("Called deallocate method for unknown type generic object\n");
      }
      tbl->next = free;
      free = tbl;
    }else{
      tbl->obj = functorp(newplace);
      *ptr = tbl;
      ptr = &(tbl->next);
    }
    tbl = next;
  }
  *ptr = NULL;
  tbl_root = newtbl;
  free_oent = free;
}

extern void
register_for_deallocation(obj, type)
  void* obj;
  int type;
{
  static int gc_hook_initialized = 0;

  struct object_table* newent = allocOtblEnt();
  struct object_table* tbl = tbl_root;

  if( !gc_hook_initialized ){
    register_after_gc_hook(deallocate_garbage);
    gc_hook_initialized = 1;
  }

  newent->obj = obj;
  newent->type = type;
  newent->next = tbl;
  tbl_root = newent;
}
