/* ---------------------------------------------------------- 
%   (C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_OPTIONS_H_
#define _KLIC_OPTIONS_H_

/* not copied when spawned */
#define ARG_SHOULD_NOT_COPY(X)	((int)(X) >= (int)ARG_NOT_USED)

#define ARG_ORIGINAL_TYPE(X) \
  ((enum argtype) \
    (ARG_SHOULD_NOT_COPY(X) ? (int)(X)-(int)ARG_NOT_USED : (int)(X)))

union all_type {
    int i;
    long l;
    double d;
    char* s;
};

enum argtype {
    ARG_DOUBLE,
    ARG_SIZE,
    ARG_RESET,
    ARG_SET,
    ARG_STRING,
    ARG_NOT_USED
};

struct opttable {
    char* opt_str;
    union all_type* opt_dest;
    enum argtype opt_type;
    char* opt_usage;
};

extern const struct opttable opttable[];

/* runtime/options.c */
extern char* parse_opts(const struct opttable* opttbl, int* acp, char*** avp);

#endif /* _KLIC_OPTIONS_H_ */
