/* ---------------------------------------------------------- 
%   (C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#include <klic/basic.h>  /* fatal */
#include <klic/struct.h>
#include <klic/primitives.h>  /* malloc_check */
#include <klic/unify.h>
#include <klic/index.h>
#include <klic/atomstuffs.h>  /* atomname */
#include <klic/functorstuffs.h>  /* functors, arities */
#include <klic/newatom.h>

#ifdef SHM
#include "shm.h"
#endif

#define Hashsize 1024
#define Namesize  1024

#define YET  (-1)
#define DONE 0

extern unsigned long generic_string_size();
extern unsigned char* convert_klic_string_to_c_string();

static unsigned char** atomnames = (unsigned char**) init_atomname;
static unsigned long* functorids = (unsigned long*) init_functors;
static unsigned long* aritiesof = (unsigned long*) init_arities;

struct atomhashtable{
  long atomid;
  unsigned long nametablesize;
  unsigned long hashtablesize;
  long *table;
};
static struct atomhashtable atomhtable;
static struct atomhashtable* atomhp = &atomhtable;

struct functorhashtable{
  long functorid;
  unsigned long functortablesize;
  unsigned long hashtablesize;
  long *table;
};
static struct functorhashtable functhtable;
static struct functorhashtable* functhp = &functhtable;

static int init_atom = YET;
static int init_functor = YET;

static long* nextatom;
static long* nextfunctor;


#ifndef SHM
static unsigned char* namearea;
static unsigned char* nameareap;

#else  /* SHM */
struct atomnamebuff {
  unsigned char* namea0;
  unsigned char* namep0;
};

struct atomnamebuff* shm_namep;

#define namearea  (shm_namep->namea0)
#define nameareap (shm_namep->namep0)

#define malloc_check(sz) \
( (Buff_S += (sz)) > Buff_E ? \
  (char*) abend("Atom Table overflow!") : (char*) (Buff_S - (sz)) )

extern void
init_shm_atom()
{
  struct atomhashtable* tmpahp;
  struct functorhashtable* tmpfhp;
  static char* Buff_S = shm_start_addr;
  static char* Buff_E = Buff_S + ATOM_TABLE_SIZE;
  shm_namep = (struct atomnamebuff*) malloc_check(sizeof(struct atomnamebuff));
  tmpahp = (struct atomhashtable*) malloc_check(sizeof(struct atomhashtable));
  *tmpahp = *atomhp;
  atomhp = tmpahp;
  tmpfhp = (struct functorhashtable*) malloc_check(sizeof(struct functorhashtable));
  *tmpfhp = *functhp;
  functhp = tmpfhp;
}
#endif  /* SHM */


static long
hash_name(name)
  unsigned char* name;
{
  long value = 0L;
  while( *name != '\0' ){
    value = 3L*value + *name;
    name++;
  }
  return value;
}

static void
enter_old_atom(i, name)
  unsigned int i;
  unsigned char* name;
{
  long index;
  long hashvalue;

  hashvalue = hash_name(name) % (atomhp->hashtablesize);

  index = atomhp->table[hashvalue] - 1;
  if( index >= 0 ){
    while( strcmp((char*) atomnames[index], (char*) name) != 0 ){
      long index0 = nextatom[index];
      if( index0 == -1 ){
	nextatom[index] = i;
	nextatom[i] = -1;
	goto finish;
      }else{
	index = index0;
      }
    }
  }else{
    atomhp->table[hashvalue] = i + 1;
    nextatom[i] = -1;
  }
 finish: ;
}

static void
enter_old_functor(i, a_no, arity)
  unsigned int i;
  unsigned long a_no, arity;
{
  long index, hashvalue;

  hashvalue =
    ((long) (a_no + arity)) % functhp->hashtablesize;

  index = functhp->table[hashvalue]-1;
  if( index >= 0 ){
    while( (functorids[index] != a_no) || (aritiesof[index] != arity) ){
      long index0 = nextfunctor[index];
      if( index0 == -1 ){
	nextfunctor[index] = i;
	nextfunctor[i] = -1;
	goto finish;
      }else{
	index = index0;
      }
    }
  }else{
    functhp->table[hashvalue] = i + 1;
    nextfunctor[i] = -1;
  }
 finish: ;
}

static void
make_atom_table()
{
  const unsigned long numberOfAtoms = initial_atoms;
  unsigned int i;

  init_atom = DONE;

  atomhp->atomid = numberOfAtoms-1;
  atomhp->hashtablesize = Hashsize;
  atomhp->table =
    (long*) malloc_check((unsigned) (sizeof(long) * Hashsize));
  namearea = (unsigned char*) malloc_check((unsigned) Namesize);
  nameareap = namearea;
  if( numberOfAtoms > 0 ){
    atomhp->nametablesize = numberOfAtoms;
    nextatom =
      (long*) malloc_check((unsigned) (sizeof(long) * numberOfAtoms));
  }else{
    atomhp->nametablesize = 1;
    atomnames = (unsigned char**) malloc_check(sizeof(char*));
    nextatom = (long*) malloc_check(sizeof(long));
  }

  for( i = 0; i < Hashsize; i++ ){ atomhp->table[i] = 0; }
  for( i = 0; i < atomhp->nametablesize; i++ ){ nextatom[i] = -1; }
  for( i = 0; i < numberOfAtoms; i++ ){ enter_old_atom(i, atomnames[i]); }
}

static void
make_functor_table()
{
  const unsigned long numberOfFunctors = initial_functors;
  unsigned int i;

  init_functor = DONE;

  functhp->functorid = numberOfFunctors-1;
  functhp->hashtablesize = Hashsize;
  functhp->table =
    (long*) malloc_check((unsigned) (sizeof(long) * Hashsize));
  if( numberOfFunctors > 0 ){
    functhp->functortablesize = numberOfFunctors;
    nextfunctor =
      (long*) malloc_check((unsigned) (sizeof(long) * numberOfFunctors));
  }else{
    functhp->functortablesize = 1;
    functorids = (unsigned long*) malloc_check(sizeof(q));
    aritiesof  = (unsigned long*) malloc_check(sizeof(q));
    nextfunctor = (long*) malloc_check(sizeof(q));
  }
  for( i = 0; i < Hashsize; i++ ){ functhp->table[i] = 0; }
  for( i = 0; i < functhp->functortablesize; i++ ){ nextfunctor[i] = -1; }
  for( i = 0; i < numberOfFunctors; i++ )
    { enter_old_functor(i, functorids[i], aritiesof[i]); }
}

extern unsigned long
enter_atom_body(name, namelen)
  char* name;
  unsigned long namelen;
{
  declare_globals;
  long index, index0, hashvalue;

  if( init_atom ) make_atom_table();

  if( strcmp((char*) name, "[]")==0 ) return 0L;
  if( strcmp((char*) name, ".")==0 ) return 1L;
  hashvalue = ((unsigned long) hash_name(name)) % atomhp->hashtablesize;

#ifdef SHM
  s_lock(a_key());
#endif

 again:
  index = atomhp->table[hashvalue] - 1;
  if( index >= 0 ){
    while( (strcmp((char*) atomnames[index], (char*) name)) ){
      index0 = nextatom[index];
      if( index0 == -1 ){
	if( atomhp->atomid +1 == atomhp->nametablesize ) goto expand;
	atomhp->atomid ++;
	nextatom[index] = (long) atomhp->atomid;
	if( (long)(nameareap-namearea) + namelen + 1 >= Namesize ){
	  namearea = (unsigned char*) malloc_check((unsigned) Namesize);
	  nameareap = namearea;
	}
        strcpy((char*) nameareap, (char*) name);
	atomnames[atomhp->atomid] = nameareap;
        nameareap += namelen;
	*nameareap++ = '\0';
	nextatom[atomhp->atomid] = -1;
#ifdef SHM
	s_unlock(a_key());
#endif
	return atomhp->atomid;
      }else{
	index = index0;
      }
    }
#ifdef SHM
    s_unlock(a_key());
#endif
    return index;
  }else{
    if( atomhp->atomid +1 == atomhp->nametablesize ){
      goto expand;
    }else{
      if( (long)(nameareap-namearea) + namelen >= Namesize ){
	namearea = (unsigned char*) malloc_check((unsigned) Namesize);
	nameareap = namearea;
      }
      atomhp->table[hashvalue] = ++(atomhp->atomid) + 1;
      strcpy((char*) nameareap, (char*) name);
      atomnames[atomhp->atomid] = nameareap;
      nameareap += strlen((char*) name) + 1;
      nextatom[atomhp->atomid] = -1;
    }
#ifdef SHM
    s_unlock(a_key());
#endif
    return atomhp->atomid;
  }

 expand:
  {
    declare_globals;
    unsigned char** newatomnames;
    long* newnextatom;
    int i;
#ifdef SHM
    if( is_shma(atomnames) ) abend("Can't expand on this version.");
#endif
    newatomnames = (unsigned char**)
      malloc_check((atomhp->nametablesize) * sizeof(char*)*2);
    newnextatom = (long*)
      malloc_check((atomhp->nametablesize) * sizeof(long)*2);
    for( i = 0; i < atomhp->nametablesize; i++ ){
      newatomnames[i] = atomnames[i];
      newnextatom[i] = nextatom[i];
    }
    for( i = atomhp->nametablesize; i < 2*atomhp->nametablesize; i++ ){
      newnextatom[i] = -1;
    }
    atomhp->nametablesize = 2 * atomhp->nametablesize;
    atomnames = newatomnames;
    nextatom = newnextatom;
  }
  goto again;
}

extern unsigned long
enter_atom_string(name0)
  q name0;
{
  unsigned char* name = convert_klic_string_to_c_string(name0);
  unsigned long retval =
    enter_atom_body(name, generic_string_size(functorp(name0)));
  free(name);
  return retval;
}

extern unsigned long
enter_functor(a_no, arity)
  unsigned long a_no, arity;
{
  declare_globals;
  long index, index0, hashvalue;

  if( init_functor ) make_functor_table();

  hashvalue =
    ((long)(a_no + arity)) % functhp->hashtablesize;

#ifdef SHM
  s_lock(f_key());
#endif

 again:
  index = functhp->table[hashvalue] - 1;
  if( index >= 0 ){
    while( (functorids[index] != a_no) || (aritiesof[index] != arity) ){
      index0 = nextfunctor[index];
      if( index0 == -1 ){
	if( functhp->functorid +1 == functhp->functortablesize ) goto expand;
	++ functhp->functorid;
	nextfunctor[index] = (long) functhp->functorid;
	functorids[functhp->functorid] = a_no;
        aritiesof[functhp->functorid] = arity;
	nextfunctor[functhp->functorid] = -1;
#ifdef SHM
	s_unlock(f_key());
#endif
	return functhp->functorid;
      }else{
	index = index0;
      }
    }

#ifdef SHM
    s_unlock(f_key());
#endif
    return index;
  }else{
    if( functhp->functorid +1 == functhp->functortablesize ){
      goto expand;
    }else{
      ++ functhp->functorid;
      functhp->table[hashvalue] = functhp->functorid + 1;
      functorids[functhp->functorid] = a_no;
      aritiesof[functhp->functorid] = arity;
      nextfunctor[functhp->functorid] = -1;
    }

#ifdef SHM
    s_unlock(f_key());
#endif
    return functhp->functorid;
  }

 expand:
  { unsigned long* newfunctorids;
    unsigned long* newaritiesof;
    unsigned long* newnextfunctor;
    int i;
#ifdef SHM
    if( is_shma(functorids) ) abend("Can't expand on this version.");
#endif
    newfunctorids = (unsigned long*)
      malloc_check((functhp->functortablesize) * sizeof(unsigned long)*2);
    newaritiesof = (unsigned long*)
      malloc_check((functhp->functortablesize) * sizeof(unsigned long)*2);
    newnextfunctor = (unsigned long*)
      malloc_check((functhp->functortablesize) * sizeof(unsigned long)*2);
    for( i = 0; i < functhp->functortablesize; i++ ){
      newfunctorids[i] = functorids[i];
      newaritiesof[i] = aritiesof[i];
      newnextfunctor[i] = nextfunctor[i];
    }
    for( i = functhp->functortablesize;
	 i < 2*functhp->functortablesize; i++ ){
      newnextfunctor[i] = -1;
    }
    functhp->functortablesize = 2 * functhp->functortablesize;
    functorids = newfunctorids;
    aritiesof  = newaritiesof;
    nextfunctor = (long*) newnextfunctor;
  }
  goto again;
}


extern unsigned char*
atomname(unsigned long id)
{
  unsigned long size =
    (atomhp->nametablesize > 0 ? atomhp->nametablesize : initial_atoms);

  if (id >= size)
    fatalf("atomname: id %d > %d", id, size);

  return atomnames[id];
}


extern unsigned long
functors(unsigned long id)
{
  unsigned long size = (functhp->functortablesize > 0 ?
    functhp->functortablesize : initial_functors);

  if (id > size)
    fatalf("functors: id %d > %d", id, size);

  return functorids[id];
}

extern unsigned long
arities(unsigned long id)
{
  unsigned long size = (functhp->functortablesize > 0 ?
    functhp->functortablesize : initial_functors);

  if(id > size)
    fatalf("arities: id %d > %d", id, size);

  return aritiesof[id];
}
