/* ----------------------------------------------------------
%   (C)1993,1994,1995 Institute for New Generation Computer Technology
%       (Read COPYRIGHT for detailed information.)
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#include <klic/basic.h>  /* fatal */
#include <klic/struct.h>
#include <klic/sighndl.h>
#include <klic/primitives.h>
#include "schedule.h"
#include "trace.h"  /* trace_flag, trace_after */

#ifdef DIST
#include "rmon.h"

#define GC_ON()    (perfmon_state.gc_on = 1)
#define GC_OFF()   (perfmon_state.gc_on = 0)

#else /* not DIST */
#define GC_ON()
#define GC_OFF()
#endif /* not DIST */

#ifdef SHM
#include "shm.h"
#endif

extern struct goalrec* klic_gc();

extern int stepping_flag;
extern struct goalrec* step_after();

int sigint_interrupt = 0;

static int higher_priority_goal0;
static struct goalrec* resumed_goals0; /* spontaneous goals during reduction */

extern void set_higher_priority_goal(void){ higher_priority_goal0 = !0; }
extern void reset_resumed_goals(void){ resumed_goals0 = NULL; }
extern void
add_resumed_goal(struct goalrec* goal){
  if( resumed_goals0 == NULL ){
    goal->next = goal;
    resumed_goals0 = goal;
  }else{
    goal->next = resumed_goals0->next;
    resumed_goals0->next = goal;
  }
}

static struct goalrec*
enqueue_resumed_goals(qp)
  struct goalrec* qp;
{
  declare_globals;
  struct goalrec* rsmg = resumed_goals0;
  if( rsmg != NULL ){
    struct goalrec* newqp = rsmg->next;
    rsmg->next = qp;
    qp = newqp;
    resumed_goals0 = NULL;
    if( interrupt_off ) heaplimit = real_heaplimit();
  }
  return qp;
}

extern void
klic_interrupt(qp)
  struct goalrec* qp;
{
  declare_globals;
  long retry;
  q* allocp = heapp();

  qp = enqueue_resumed_goals(qp);

  if( stepping_flag ){
    qp = step_after(qp, allocp);
    allocp = heapp();
  }else if( trace_flag ){
    qp = trace_after(qp, allocp);
    allocp = heapp();
  }

  do{
    retry = 0;

    /* signal handling */
#ifdef USESIG
    if( !signal_done ){
      set_heapp(allocp);
      klic_signal_handler();
      allocp = heapp();
      retry = (allocp + this_more_space() >= real_heaplimit());
      /* some goals may have been resumed by the signal handler */
      qp = enqueue_resumed_goals(qp);
    }
#endif
#if defined(DIST) && defined(USE_REDUCTION_COUNT)
    {
      int again = receive_message(allocp, 0);
      if( again == 0 )
	heaplimit = real_heaplimit();
      allocp = heapp();
      retry = (allocp + this_more_space() >= real_heaplimit());
      /* some goals may have been resumed by the message reception */
      qp = enqueue_resumed_goals(qp);
    }
#endif
    if( sigint_interrupt ){
      fatal("Execution aborted by SIGINT");
    }

#ifdef SHM
    while( (volatile int) ext_queued ){
      *cur_status = 1;
      ext_queued = 0;
      klic_barrier();
      qp = get_invoked_goals(qp);
      interrupt_off = -1;
      heaplimit = real_heaplimit();
      retry |= (allocp + this_more_space() >= heaplimit);
    }
#endif

    /* priority support */
    if( higher_priority_goal0 ){
      higher_priority_goal0 = 0;
      put_priority_queue(qp, current_prio());
      qp = get_top_priority_queue();
      if( interrupt_off ) heaplimit = real_heaplimit();
    }

#ifdef SHM
    if( ck_shm_gc() || allocp + this_more_space() >= real_heaplimit() ){
      *cur_status = 3;
    /* ck_shm_gc will call another GC */
#else
    if( allocp + this_more_space() >= real_heaplimit() ){
#endif
      GC_ON();
      qp = klic_gc(qp);
#ifdef SHM
      *cur_status = 1;
#endif
      GC_OFF();

      allocp = heapp();
    }
  }while( retry );

  current_queue = qp;
  set_heapp(allocp);
}
