/* ---------------------------------------------------------- 
%   (C) 1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_INTERPE_H_
#define _KLIC_INTERPE_H_

#include <malloc.h>
#ifdef __alpha
/* dec malloc.h does not supply function return value decralations */
extern void* malloc();
extern void* calloc();
extern void* realloc();
#endif

#include <klic/stdc.h>
#include <klic/distpkt.h>

/********** for debugging output control */
/* #define INT_CL_DEBUG */
#ifdef	INT_CL_DEBUG
#  define INT_CL_DEBUG_X(X)  (X)
#else
#  define INT_CL_DEBUG_X(X)
#endif

#define INT_CL_PROBE
#ifdef	INT_CL_PROBE
#  define INT_CL_PROBE_X(X)  (X)
#else
#  define INT_CL_PROBE_X(X)
#endif

/*********** Some convenient macros **************/
#define MASTER_NODE		0L
#define SHOEN_NODE		total_node
#define IS_MASTER_NODE(node)	((node) == MASTER_NODE)
#define IS_SHOEN_NODE(node)	((node) == SHOEN_NODE)

/* Constants */
#define EXPORT_UNIT_WEC		0x10000
#define MIN_WEC			0x2

#define IMPREC_NOT_COPIED	12345
#define IMPREC_COPIED		54321
#define IMPREC_RELEASED		98765

/* Temporary. for PVM-TCP bug */
#ifndef TRANSFER_CNT
#define TRANSFER_CNT            0x1000L
#endif

/************* WTC related definition ***************/
Extern long shoen_wtc;
Extern long node_wtc;

#define SUPPLY_WTC_UNIT		0x1000000L

/* #define CONTROL_WTC_UNIT	0x1L	/*This value implicitly assumed. */

enum get_wtc_type {
  get_wtc_normal_request,
  get_wtc_full_request,
  get_wtc_force_request };

/************* Export Table *********************/
Extern long active_exp_entry;

/************** Import Table ********************/
Extern long receive_answer_flag;
Extern long answer_return_exp_index;
Extern q decode_data;		/* Un natural way of value passing. */

/* Options set by program arguments */
Extern long eager_transfer_level	Init(0);
Extern int network_statistics_flag	Init(0);
Extern int msg_busywait_flag		Init(0);

/************* message suspend record **************/

struct susp_msg_rec {
  struct susp_msg_rec* next;
  long node;
  long wtc_needed;
  combuf* outbuf;
};

Extern struct susp_msg_rec* susp_msg_list;

/************* Network Statistics Measurement *******/

struct netstat {
    long start_sec;		/* only SHOEN uses this field */
    long start_usec;		/* only SHOEN uses this field */

    long send_throw_cnt;
    long send_read_cnt;
    long send_unify_cnt;
    long send_answer_cnt;
    long send_release_cnt;
    long send_request_wtc_cnt;
    long send_supply_wtc_cnt;
    long send_return_wtc_cnt;
    
    long recv_throw_cnt;
    long recv_read_cnt;
    long recv_unify_cnt;
    long recv_release_cnt;
    long recv_answer_cnt;
    long recv_request_wtc_cnt;
    long recv_supply_wtc_cnt;
    long recv_return_wtc_cnt;

    long msg_suspend_cnt;
    long msg_resume_cnt;
    
    long send_data_siz;
    long recv_data_siz;
};

Extern struct netstat netstat;

#define ERROR_STOP for(;;)

#endif /* _KLIC_INTERPE_H_ */
