/* ---------------------------------------------------------- 
%   (C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */
#include <stdio.h>

#include <klic/basic.h>  /* fatal */
#include <klic/struct.h>
#include <klic/g_methtab.h>
#include <klic/g_basic.h>
#include <klic/gg_macro.h>
#include <klic/susp.h>
#include <klic/unify.h>  /* do_unify */
#include "gobj.h"
#include "shm.h"

#define GENHOOK  1
#define GENHOPT  1

#define GG_CLASS_NAME() shvar
#define GG_OBJ_TYPE struct Shvar

#define One_more()  (do_unify(GG_SELF, GG_TERM))

struct Shvar {
  struct generator_object_method_table *method_table;
  Sinfo chain;
};

extern Sinfo* shm_copy_chain();
extern Sinfo* shm_merge_chain();

static Inline int
cmp_forward_ptr(q x, q y)
{
  declare_globals;
  int xv = get_space(x);
  int yv = get_space(y);
  return (xv==yv) ? (x < y) : (xv < yv);
}

static Inline int
is_forward_space_ptr(Sinfo* gp)
{
  int ok = 0;
  int cid;
  while( (cid = PLNE_ptr[cid]->direct) != -1 ){
    if( (unsigned long)((long)gp-(long)(PLNE_ptr[cid]->top_addr)) < SHM_SIZE ){
      ok = 1;
      break;
    }
  }
  return ok;
}

GGDEF_UNIFY()
{
  G_STD_DECL;

  struct generator_object *addi;
  Shvar *gobjp;
  q pair = derefone(GG_SELF);
  if( !isref(pair) || GG_SELF != derefone(pair) ){ One_more(); GG_TERMINATE; }
  addi = n_lock(GG_SELF, pair);
  if( pair != derefone(GG_SELF) ){ One_more(); GG_TERMINATE; }

  gobjp = (Shvar*) untag_generator_susp(addi);
  GG_SWITCH_ON_TERM(cons, atomic, func, dobj, susp);

 atomic:
  {
    derefone(GG_SELF) = GG_TERM;
    if( gobjp->chain ){
      if( is_genhook(gobjp->chain) ){
	set_heapp(shm_ck_request(heapp(), gobjp->chain));
      }else{
	set_heapp(shm_resume_goals(heapp(), gobjp->chain));
      }
    }
    GG_TERMINATE;
  }

 cons:
 func:
 dobj:
  {
    q y;
    if( GENHOOK && !gobjp->chain && !is_shma(GG_TERM)
	&& (!GENHOPT || last_shm_var == GG_SELF) ){
      gobjp = create_genhook(GG_TERM, GG_SELF);
      n_unlock(pair, tag_generator_susp(gobjp));
    }else{
      ck_new_galloc(GG_SELF);
      y = shm_copy(GG_TERM);
      klic_barrier();
      derefone(GG_SELF) = y;
      if( gobjp->chain ){
	if( is_genhook(gobjp->chain) ){
	  set_heapp(shm_ck_request(heapp(), gobjp->chain));
	}else{
	  set_heapp(shm_resume_goals(heapp(), gobjp->chain));
	}
      }
    }
    GG_TERMINATE;
  }

 susp:
  {
    q x = GG_SELF;
    q temp = pair;
    struct generator_object* xaddi = addi;
    Shvar* xobjp = gobjp;
    q y = GG_TERM;
    q ytemp;
    struct generator_object* yaddi;
    Shvar* yobjp;

  Re_try:
    ytemp = derefone(y);
    if( !isref(ytemp) || y != derefone(ytemp) ){
      n_unlock(temp, xaddi);
      One_more();
      GG_TERMINATE;
    }
    yaddi = generator_suspp(ytemp)->u.o;
    /* if yaddi is generator_susp */
    if( (long)yaddi & 1L ){
      struct generator_object_method_table* m;
      yobjp = (Shvar*) untag_generator_susp(yaddi);
      m = yobjp->method;
      if( m == SHM_VAR || m == SHM_BUSY ){
	if( x == y ){
	  n_unlock(temp, xaddi);
	  GG_TERMINATE;
	}
	if( cmp_forward_ptr(x,y) ){ /* reverse order */
	  q w;
	  n_unlock(temp, xaddi);
	  w = x; x = y; y = w;
	  w = temp; temp = ytemp; ytemp = w;
	  xaddi = n_lock(x, temp);
	  if( temp != derefone(x) ){
	    One_more();
	    GG_TERMINATE;
	  }
	  xobjp = (Shvar*) untag_generator_susp(xaddi);
	}

	if( xobjp->chain ){
	  if( is_genhook(xobjp->chain) ){ /* one is a generator hook. */
	    derefone(x) = y;
	    set_heapp(shm_ck_request(heapp(), xobjp->chain));
	  }else{              /* one is a normal hook */
	    yaddi = n_lock(y, ytemp);
	    if( derefone(y) != ytemp ){
	      n_unlock(temp,xaddi);
	      One_more();
	      GG_TERMINATE;
	    }
	    yobjp = (Shvar*) untag_generator_susp(yaddi);
	    if( yobjp->chain ){
	      if( is_genhook(yobjp->chain) ){ /* another is a generator hook. */
		Sinfo* ychain = yobjp->chain;
		ck_new_galloc(yobjp);
		/* Don't forget keeping direction */
		yobjp->chain = shm_copy_chain(xobjp->chain);
		n_unlock(ytemp, yaddi);
		derefone(x) = y;
		set_heapp(shm_ck_request(heapp(), ychain));
	      }else{ /* both are ordinary hooks */
		ck_new_galloc(yobjp);
		yobjp->chain = shm_merge_chain(xobjp->chain, yobjp->chain);
		n_unlock(ytemp, yaddi);
		derefone(x) = y;
	      }
	    }else{
	      ck_new_galloc(y);
	      if( is_cur_or_forward_ptr(xobjp) ){
		n_unlock(ytemp, tag_generator_susp(xobjp));
		derefone(x) = y;
	      }else{
		yobjp = (Shvar*) galloc(sizeof(Shvar)/sizeof(q));
		yobjp->method = SHM_VAR;
		yobjp->chain = shm_copy_chain(xobjp->chain);
		n_unlock(ytemp, tag_generator_susp(yobjp));
		derefone(x) = y;
	      }
	    }
	  }
	}else{ /* x has no additional info. */
	  derefone(x) = y;
	}
      }else{ /* y is an other local generator object */
	/* assumes user defined object. Not Exref */
	if( xobjp->chain ){ /* x has any info */
	  struct generator_object* gobjy = untag_generator_susp(yaddi);
	  q tmpy;
	  tmpy = generic_generate(gobjy);
	  switch( (long)tmpy ){
	  case (long) makeref(0):
	    GG_KL1_UNIFY(x, y);
	    GG_TERMINATE;
	  case (long) makecons(0):
	    fatal("system bug!!!");
	  default:
	    derefone(y) = tmpy;
	    One_more();
	    GG_TERMINATE;
	  }
	}else{ /* x is a simple variable */
	  xobjp = create_genhook(tag_local(y), x);
	  n_unlock(temp, tag_generator_susp(xobjp));
	}
      }
    }else{ /* y is a consumer */
      if( xobjp && is_genhook(xobjp->chain) ){ /* global generator hook */
	Shvar* tobj = shm_add_consumer(x, 0, y, glbl);
	set_heapp(shm_ck_request(heapp(), xobjp->chain));
	n_unlock(temp, tag_generator_susp(tobj));
      }else{
	Shvar* tobj = (Shvar*) shm_add_consumer(x, xobjp, y, glbl);
	n_unlock(temp, tag_generator_susp(tobj));
      }
    }
    GG_TERMINATE;
  }
}

GGDEF_GENERATE()
{
  return makecons(0);
}

GGDEF_SUSPEND()
{
  G_STD_DECL;
  struct generator_object* addi;
  Sinfo* sptr;
  Sinfo* gp;
  Shvar* gvar;
  q temp = derefone(GG_SELF);
  if( !isref(temp) )  return makecons(0);
  if( GG_SELF != derefone(temp) )  return makecons(0);
  addi = n_lock(GG_SELF, temp);
  if( derefone(GG_SELF) != temp )  return makecons(0);
  ck_new_galloc(GG_SELF);

  /* creates shared memory hook chain */

  gvar = (Shvar*) untag_generator_susp(addi);
  gp = gvar->chain;
  if( gp == NULL ){ /* First hook */
    Shvar* gptr = (Shvar*) galloc( (sizeof(Shvar)+sizeof(Sinfo))/sizeof(q) );
    sptr = (Sinfo*) (gptr+1);
    gptr->method = SHM_VAR;
    gptr->chain = sptr;
    sptr->next = NULL;
    sptr->PE_num = my_node;
    sptr->prio = current_prio();
    sptr->indp = create_local_tbl(GG_GOAL, GG_SELF);
    n_unlock(temp, tag_generator_susp(gptr));
    return makeref(0);
  }
  /* already any hooks */
  else if( is_genhook(gp) ){ /* shared generator hook */
    int pe_num;
    long prio;
    TADDRtbl* ind;
    sptr = (Sinfo*) untag_generator_susp(gp);
    pe_num = sptr->PE_num;
    prio = sptr->prio;
    ind = sptr->indp;
    if( pe_num == my_node ){
      q temp;
      q* tp = ind->globalA;
      if( !isatomic(ind->localA) ){
	free_local_tbl(ind);
	shm_arg_copy(&ind->localA, &temp);
	klic_barrier();
	*tp = temp;
	return makecons(0);
      }
    }
    /* reuses Sinfo */
    gvar->method = SHM_VAR;
    gvar->chain = sptr;
    sptr->PE_num = my_node;
    sptr->prio = current_prio();
    sptr->indp = create_local_tbl(GG_GOAL, GG_SELF);
    shm_request_queueing(pe_num, prio, ind);
    n_unlock(temp, addi);
    return makeref(0);
  }else{ /* ordinary hook */
    Sinfo* bgp = (Sinfo*) &(gvar->chain);
    ck_new_galloc(gvar);
    while( gp != NULL && !is_forward_space_ptr(gp) ){
      if( gp->PE_num == my_node ){
	if( (struct goalrec*)(gp->indp->localA) == GG_GOAL ){
	  n_unlock(temp, addi);
	  return makeref(0);
	}else{
	  break;
	}
      }
      bgp = gp;
      gp = gp->next;
    }
    sptr = (Sinfo*) galloc(sizeof(Sinfo)/sizeof(q));
    bgp->next = sptr;
    sptr->next = gp;
    sptr->PE_num = my_node;
    sptr->prio = current_prio();
    sptr->indp = create_local_tbl(GG_GOAL, GG_SELF);
    n_unlock(temp, addi);
    return makeref(0);
  }
}

GGDEF_PRINT()
{
  fprintf(g_fp, "<INTEGER GENERATOR %x>", GG_SELF);
  return 0;
}

GGDEF_GC()
{
  fatal("bug!!!");
}

#define GGUSE_MY_UNIFY
#define GGUSE_MY_SUSPEND
#define GGUSE_MY_GENERATE
#define GGUSE_MY_GC
#define GGUSE_MY_PRINT

#include <klic/gg_methtab.h>

GGDEF_NEW()
{
}
