/* ----------------------------------------------------------
%   (C)1993,1994,1995 Institute for New Generation Computer Technology
%       (Read COPYRIGHT for detailed information.)
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#include <math.h>
#include <stdio.h>
#include <klic/gdobject.h>  /* debug_printf, klic_fprintf */
#include <klic/gd_macro.h>

#include "atom.h"
#include "funct.h"

#ifdef DIST
#include "interpe.h"
#endif

#ifdef SHM
#include "shm.h"
#endif

#define GD_CLASS_NAME() float
#define GD_OBJ_TYPE struct float_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE))

#define ALIGN() \
do{ \
  if( sizeof(double) != sizeof(long) ){ \
    set_heapp((q*) (((unsigned long) heapp() + sizeof(double) - 1) \
		     & -sizeof(double) )); \
  } \
}while(0)

#ifdef SHM
#define ALIGN_SHM() \
do{
  if( sizeof(double) != sizeof(long) ){ \
    gallocp = (q*) (((unsigned long)gallocp + sizeof(double) - 1) \
		     & -sizeof(double) ); \
  }
}while(0)
#endif /* SHM */

extern double atof();
extern q convert_c_string_to_klic_string();
extern unsigned char* generic_string_body();

#ifdef DIST
extern void push_decode_stack();
static q* decode_float(combuf* inbuf, q* g_allocp);
#endif /* DIST */

GD_USE_CLASS(byte__string);

GD_OBJ_TYPE {
  struct data_object_method_table *method_table;
  double value;
};

#ifdef DIST
union dl {
  double d;
  long l[2];
};
#endif /* DIST */

#ifdef SHM
GDDEF_SHMCOPY()
{
  G_STD_DECL;
  GD_OBJ_TYPE* newself;

  for(;;){
    ALIGN_SHM();
    newself = (GD_OBJ_TYPE*) gallocp;
    gallocp = (q*) ((unsigned long)gallocp + sizeof(struct float_object));
    if( gallocp <= glimit ) break;
    gallocp = shm_galloc(0);
  }
  newself->method_table = GD_SELF->method_table;
  newself->value = GD_SELF->value;
  return makefunctor(newself);
}
#endif /* SHM */

/* basic method definitions */

GDDEF_GUNIFY()
{
  G_STD_DECL;
  if( GD_SELF->method_table != GD_OTHER->method_table ||
      GD_SELF->value != GD_OTHER->value )
    GD_GUNIFY_FAIL;
  GD_GSUCCEED;
}

GDDEF_UNIFY()
{
  G_STD_DECL;

  if( GD_SELF->method_table != GD_OTHER->method_table ||
      GD_SELF->value != GD_OTHER->value )
    GD_UNIFY_FAIL;
}

GDDEF_GC()
{
  G_STD_DECL;
  GD_OBJ_TYPE* newself;

  ALIGN();
  GDSET_NEWOBJ_IN_NEWGEN(newself);
  newself->value = GD_SELF->value;
  GD_RETURN_FROM_GC(newself);
}

/* Generic method */

GDDEF_METHOD(print_1)
{
  G_STD_DECL;
  double value = GD_SELF->value;
  q str;
  char buf[100];
  sprintf(buf, "%1.16g", value);
  if( STRCHR(buf, '.') == NULL &&
      strcmp(buf, "Infinity") != 0 && strcmp(buf, "-Infinity") != 0 &&
      strcmp(buf, "NaN") != 0 ){
    char* exponent = STRCHR(buf, 'e');
    if( exponent != NULL ){
      char save[100];
      strcpy(save, exponent);
      strcpy(exponent, ".0");
      strcpy(exponent+2, save);
    }else{
      strcat(buf, ".0");
    }
  }
  str = convert_c_string_to_klic_string(buf);
  GD_UNIFY_VALUE(GD_ARGV[0], str);
  GD_RETURN;
}

GDDEF_METHOD(int_1)
{
  G_STD_DECL;
  double value = GD_SELF->value;
  q result = makeint((long) value);
  GD_UNIFY_VALUE(GD_ARGV[0], result);
  GD_RETURN;
}

static double
unary_plus(x)
  double x;
{
  return x;
}

static double
unary_minus(x)
  double x;
{
  return -x;
}

/*  Generic Method Table */
GDDEF_GENERIC()
{
  G_STD_DECL;
  double self, result;
  unsigned long result_index;
  GD_OBJ_TYPE* newobj;
  double (*func)();

  self = GD_SELF->value;
  GD_SWITCH_ON_METHOD {

  GD_METHOD_CASE(print_1);
  GD_METHOD_CASE(int_1);
    break;

  default:
    ALIGN();
    GDSET_NEWOBJ(newobj);
    GD_SWITCH_ON_ARITY {
    case 1: {
      result_index = 0;
      GD_SWITCH_ON_METHOD {
	GD_METHOD_CASE_DIRECT(sin_1): func = sin; goto apply_1;
	GD_METHOD_CASE_DIRECT(cos_1): func = cos; goto apply_1;
	GD_METHOD_CASE_DIRECT(tan_1): func = tan; goto apply_1;
	GD_METHOD_CASE_DIRECT(asin_1): func = asin; goto apply_1;
	GD_METHOD_CASE_DIRECT(acos_1): func = acos; goto apply_1;
	GD_METHOD_CASE_DIRECT(atan_1): func = atan; goto apply_1;
	GD_METHOD_CASE_DIRECT(sinh_1): func = sinh; goto apply_1;
	GD_METHOD_CASE_DIRECT(cosh_1): func = cosh; goto apply_1;
	GD_METHOD_CASE_DIRECT(tanh_1): func = tanh; goto apply_1;
	GD_METHOD_CASE_DIRECT(exp_1): func = exp; goto apply_1;
	GD_METHOD_CASE_DIRECT(log_1): func = log; goto apply_1;
	GD_METHOD_CASE_DIRECT(sqrt_1): func = sqrt; goto apply_1;
	GD_METHOD_CASE_DIRECT(ceil_1): func = ceil; goto apply_1;
	GD_METHOD_CASE_DIRECT(floor_1): func = floor; goto apply_1;
	GD_METHOD_CASE_DIRECT(plus_1): func = unary_plus; goto apply_1;
	GD_METHOD_CASE_DIRECT(minus_1): func = unary_minus; goto apply_1;
	GD_METHOD_CASE_DEFAULT;
      }
    }
    case 2: {
      q another = GD_ARGV[0];
      double another_value;
      GD_DEREF(another);
      result_index = 1;
      if( !isfunctor(another) ||
	  ((GD_OBJ_TYPE*) functorp(another))->method_table !=
	  GD_SELF->method_table ){
	debug_printf("### \"%k\" given to floating point method %F ###\n",
		     another, g_method_functor);
	GD_FAIL("Invalid argument in floating point object method.");
      }
      another_value = ((GD_OBJ_TYPE*) functorp(another))->value;
      GD_SWITCH_ON_METHOD {
      GD_METHOD_CASE_DIRECT(add_2):
	result = self + another_value;
	goto apply_2;
      GD_METHOD_CASE_DIRECT(subtract_2):
	result = self - another_value;
	goto apply_2;
      GD_METHOD_CASE_DIRECT(multiply_2):
	result = self * another_value;
	goto apply_2;
      GD_METHOD_CASE_DIRECT(divide_2):
	result = self / another_value;
	goto apply_2;
      GD_METHOD_CASE_DIRECT(pow_2):
	result = pow(self, another_value);
	goto apply_2;
      GD_METHOD_CASE_DEFAULT;
      }
      break;
    }
    GD_METHOD_CASE_DEFAULT;
    }
  }
  return;

 apply_1:
  result = func(self);
 apply_2:
  newobj->value = result;
  GD_UNIFY(GD_ARGV[result_index], makefunctor(newobj));
}

/* guard generic methods */

#define COMPARE_METHOD(comparison)				\
{								\
  G_STD_DECL;							\
  q otherq = GD_ARGV[0];					\
  GD_OBJ_TYPE* other;						\
  double self, theother;					\
								\
  if( !G_ISGOBJ(otherq) ) GD_GFAIL;				\
  other = (GD_OBJ_TYPE*) G_FUNCTORP(otherq);			\
  if( other->method_table != GD_SELF->method_table ) GD_GFAIL;	\
  self = GD_SELF->value;					\
  theother = other->value;					\
  if( comparison ) GD_GSUCCEED;					\
  GD_GFAIL;							\
}

GDDEF_GMETHOD(less__than_1)
{ COMPARE_METHOD(self < theother); }

GDDEF_GMETHOD(not__greater__than_1)
{ COMPARE_METHOD(self <= theother); }

GDDEF_GMETHOD(not__less__than_1)
{ COMPARE_METHOD(self >= theother); }

GDDEF_GMETHOD(greater__than_1)
{ COMPARE_METHOD(self > theother); }

GDDEF_GMETHOD(equal_1)
{ COMPARE_METHOD(self == theother); }

GDDEF_GMETHOD(not__equal_1)
{ COMPARE_METHOD(self != theother); }

GDDEF_GMETHOD(float_0)
{
  G_STD_DECL;
  GD_GSUCCEED;
}

GDDEF_GGENERIC()
{
  G_STD_DECL;
  GD_SWITCH_ON_GMETHOD {
    GD_GMETHOD_CASE(less__than_1);
    GD_GMETHOD_CASE(not__greater__than_1);
    GD_GMETHOD_CASE(not__less__than_1);
    GD_GMETHOD_CASE(greater__than_1);
    GD_GMETHOD_CASE(equal_1);
    GD_GMETHOD_CASE(not__equal_1);
    GD_GMETHOD_CASE(float_0);
    GD_GMETHOD_CASE_DEFAULT;
  }
}

GDDEF_PRINT()
{
  G_STD_DECL;
  char b[100];
  sprintf(b, "%f", GD_SELF->value);
  klic_fprintf(g_fp, "%s", b);
  GD_RETURN_FROM_PRINT;
}

GDDEF_COMPARE()
{
  G_STD_DECL;
  if( GD_SELF->value > GD_OTHER->value ){
    return G_MAKEINT(1);
  }else if( GD_SELF->value < GD_OTHER->value ){
    return G_MAKEINT(-1);
  }else{
    return G_MAKEINT(0);
  }
}

GDDEF_HASH()
{
  G_STD_DECL;
  return G_MAKEINT((long) GD_SELF->value);
}

#ifdef DIST
GDDEF_ENCODE()
{
  G_STD_DECL;

  PUT_BUFFER(buffer, decode_float);
  if( sizeof(double) == sizeof(long) ){
    PUT_BUFFER(buffer, (long) GD_SELF->value);
  }else{
    union dl dl;
    dl.d = GD_SELF->value;
    PUT_BUFFER(buffer, dl.l[0]);
    PUT_BUFFER(buffer, dl.l[1]);
  }
  return GENERIC_SUCCEEDED;
}
#endif /* DIST */

#define GDUSE_MY_GUNIFY
#define GDUSE_MY_UNIFY
#define GDUSE_MY_PRINT
#define GDUSE_MY_GC
#ifdef DIST
#define GDUSE_MY_ENCODE
#endif
#ifdef SHM
#define GDUSE_MY_SHMCOPY
#endif
#define GDUSE_MY_GENERIC
#define GDUSE_MY_GGENERIC
#define GDUSE_MY_COMPARE
#define GDUSE_MY_HASH

/* define the method table structure of the vector */

#include <klic/gd_methtab.h>

/*  new_float function */
GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  q init = GD_ARGV[0];
  GD_OBJ_TYPE* newobj;

  GD_DEREF_FOR_NEW(init);
  ALIGN();
  GDSET_NEWOBJ_FOR_NEW(newobj, G_SIZE_IN_Q(GD_OBJ_TYPE));
  if( G_ISINT(init) ){
    newobj->value = (double) G_INTVAL(init);
  }else if( G_ISGOBJ(init) &&
	    (struct data_object_method_table*) G_FUNCTOR_OF(init)
	    == &byte__string_g_data_method_table ){
    newobj->value = atof((char*) generic_string_body(G_FUNCTORP(init)));
  }else{
    debug_printf("### %k ###\n", init);
    GD_FAIL("Invalid initial value for floating point objects");
  }
  GD_RETURN_FROM_NEW(newobj);
}

#ifdef DIST
static q*
decode_float(inbuf, g_allocp)
  combuf* inbuf;
  q* g_allocp;
{
  G_STD_DECL;
  GD_OBJ_TYPE* newobj;

  set_heapp(g_allocp);
  ALIGN();
  G_HEAPALLOC(newobj, G_SIZE_IN_Q(GD_OBJ_TYPE), (GD_OBJ_TYPE*));

  newobj->method_table = &GD_method_table;
  if( sizeof(long) == sizeof(double) ){
    newobj->value = (double) GET_BUFFER(inbuf);
  }else{
    union dl dl;
    dl.l[0] = (long) GET_BUFFER(inbuf);
    dl.l[1] = (long) GET_BUFFER(inbuf);
    newobj->value = dl.d;
  }
  push_decode_stack((q) makefunctor(newobj));
  return heapp();
}
#endif /* DIST */
