/* ---------------------------------------------------------- 
%   (C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */
#include <klic/basic.h>  /* fatal */
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include "timing.h"
#include <klic/index.h>

#include <stdio.h>

#include "interpe.h"
#include <klic/distio.h>
#include <klic/g_extern.h>  /* general_gc */

#define EXP_TABLE_INC_SIZE	0x1000
#define UNUSED_EXPREC  0xf0f0f0ff  /* This value is curious!! */

struct exp_entry{
  long index;
  long wec;
  q data;
  struct exp_entry* next;
};

static struct exp_entry* exp_table;
static struct exp_entry* top_of_exp_freelist;
static long current_exp_size;

static void
initiate_allocated_exp_table()
{
  int i;

  top_of_exp_freelist = &exp_table[current_exp_size];

  for(i = current_exp_size ; i < current_exp_size+EXP_TABLE_INC_SIZE; i++){
    exp_table[i].index = i;            /* for getting index from address */
    exp_table[i].wec   = 0;            /* for getting index from address */
    exp_table[i].next = &exp_table[i+1];
    exp_table[i].data = (q) UNUSED_EXPREC;
  }
  exp_table[current_exp_size+EXP_TABLE_INC_SIZE-1].next = 0;

  current_exp_size += EXP_TABLE_INC_SIZE;
}

static struct exp_entry*
pop_exp_table_entry()
{
  struct exp_entry* poped_exp_entry;

  if (top_of_exp_freelist == NULL){
    int i;
    for( i=0; i < current_exp_size - 1; i++ ){
      if( exp_table[i].wec == 0 ){
        ioeprintf("Export table reclaim error in entry %d\n", i);
      }
    }

    {
      char* exp_alloc;

      exp_alloc = (char*) realloc((char*) exp_table,
	(current_exp_size+EXP_TABLE_INC_SIZE)*sizeof(struct exp_entry));
      if(exp_alloc == NULL){
	fatal("realloc failed in pop_exp_table_entry");
      }

      exp_table = (struct exp_entry*) exp_alloc;

      initiate_allocated_exp_table();
    }
  }

  poped_exp_entry = top_of_exp_freelist;
  top_of_exp_freelist = top_of_exp_freelist->next;

  if(poped_exp_entry->data != (q) UNUSED_EXPREC){
    ioeprintf("export_entry doubly used\n");
    ERROR_STOP;
    fatal("export_entry doubly used");
  }
  return poped_exp_entry;
}

static void
push_exp_table_entry(push_exp_entry)
  struct exp_entry* push_exp_entry;
{
  push_exp_entry->data = (q) UNUSED_EXPREC;
  push_exp_entry->next = top_of_exp_freelist;
  top_of_exp_freelist = push_exp_entry;
}

extern long
regist_exptbl(data)
  q data;
{
  struct exp_entry* exp_table_entry;

  exp_table_entry = pop_exp_table_entry();
  active_exp_entry++;

  exp_table_entry->wec = (long) EXPORT_UNIT_WEC;

  exp_table_entry->data = data;
  return exp_table_entry->index;
}

extern q
search_exptbl(index, wec)
  long index;
  long wec;
{
  q data;

  data = exp_table[index].data;
  if((long) data == UNUSED_EXPREC){
    ioeprintf("invalid exp record %d\n", index);
    ERROR_STOP;
  }

  exp_table[index].wec -= wec;
  if (exp_table[index].wec ==0){
    push_exp_table_entry(&exp_table[index]);
    active_exp_entry--;
  }
  return data;
}


extern void
initiate_exp_table()
{
  char* exp_alloc;

  current_exp_size = 0L;

  exp_alloc = (char*) malloc(EXP_TABLE_INC_SIZE*sizeof(struct exp_entry));
  if(exp_alloc == NULL){
    fatal("malloc failed in initiate_exp_table");
  }
  exp_table = (struct exp_entry*) exp_alloc;

  initiate_allocated_exp_table();
}


extern void
gc_exp_table(void)
{
  declare_globals;

  int i, j;
  q newdata;

  j = 0;
  for(i=0; i<current_exp_size; i++){
    if(exp_table[i].data != (q) UNUSED_EXPREC){
      newdata = general_gc(&(exp_table[i].data));
      exp_table[i].data = newdata;
      j++;
    }
    if(j == active_exp_entry){
      break;
    }
  }
}
