/* ---------------------------------------------------------- 
%   (C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */
#ifndef _KLIC_DISTIO_H_
#define _KLIC_DISTIO_H_

#include <klic/stdc.h>  /* VA_ARGS */
#include <klic/distpkt.h>
#include <klic/distproc.h>

#define IO_Lock                 (s_lock  (&io_lockwds->lockwd))
#define IO_Unlock               (s_unlock(&io_lockwds->lockwd))
#define CloseIO()
#define AttachIO()		{ if (!my_io_lock_flag) {IO_Lock; my_io_lock_flag=1;} }
#define DetachIO()		{ IO_Unlock; my_io_lock_flag =0; }

#define SystemPrint(Str)        (int)klic_fwrite(Str,strlen(Str),1,stderr)
extern int SystemRead();
#define SystemPutc(Char)	(int)klic_putc(Char,stderr)
extern int SystemGetc();
#define SystemFflush()		(int)klic_fflush(stderr)
#define Print(Str)		(int)klic_fwrite(Str,strlen(Str),1,stdout)
#define EPrint(Str)		(int)klic_fwrite(Str,strlen(Str),1,stderr)
#define Read(Str)		(SystemRead(Str))
#define UserPutc(Char)		(int)klic_putc(Char,stdout)
#define UserEPutc(Char)		(int)klic_putc(Char,stderr)
#define UserGetc()		(int)klic_getc(stdin)
#define UserUngetc(Char)        (int)ungetc(Char, stdin)
#define UserWrite(Str,Len)      (int)klic_fwrite(Str,Len,1,stdout)
#define UserEWrite(Str,Len)     (int)klic_fwrite(Str,Len,1,stderr)
#define UserFflush()		(int)klic_fflush(stdout)
#define UserEFflush()		(int)klic_fflush(stderr)
#define EmergencyStop()
#define SystemIsEOF()

extern void ioprintf VA_ARGS((char *format, ...));
extern void ioeprintf VA_ARGS((char *format, ...));
extern void iosprintf VA_ARGS((char *format, ...));

#define io_server(argv,argc)

#endif /* _KLIC_DISTIO_H_ */
