/* ---------------------------------------------------------- 
%   (C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#include <stdio.h>
#include <errno.h>
#include <klic/basic.h>  /* klic_getc */
#include <klic/sighndl.h>
#include <klic/struct.h>
#include <klic/distio.h>

#define SystemReadSize  1024

static FILE*
io_tty(void)
{
  static FILE* io_tty0 = NULL;

  if (io_tty0 == NULL) {
    io_tty0 = fopen("/dev/tty", "r");
    if (io_tty0 == NULL) {
      io_tty0 = stdin;
    }
  }
  return io_tty0;
}

extern int
SystemRead(Str)
  char* Str;
{
  while(fgets(Str, SystemReadSize, io_tty()) != Str && errno == EINTR)
    ;
  return 0;
}

extern int
SystemGetc()
{
  klic_getc(io_tty());
  return 0;
}
