# ---------------------------------------------------------- 
#   (C) 1995 Institute for New Generation Computer Technology 
#	(Read COPYRIGHT for detailed information.) 
#   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
#       (Read COPYRIGHT-JIPDEC for detailed information.)
# ----------------------------------------------------------

if ( test "$PVM_ARCH" = "VPP300" || test "$PVM_ARCH" = "VPP700" ); then
  PVMLIBDIR=$PVM_ROOT/lib/$PVM_ARCH
  DISTCOMPILERFLAG="-Wl,-P -dy -J"
  DISTLINKAGEFLAG="-Wl,-P,-dy -J -Wv,-sc,-ad -Oe,-P -L%s -l%s /usr/lang/pvm/lib/VPP300/libmp.a -lgen -lelf -lsocket -lpx -lm -lc"

elif test "$PVM_ARCH" = "AP3000"; then
  PVMLIBDIR=$PVM_ROOT/lib
  DISTCOMPILERFLAG=""
  DISTLINKAGEFLAG="-L%s -l%s -lmpl -lemi -lthread"

else
   PVMLIBDIR=$PVM_ROOT/lib/$PVM_ARCH
   DISTCOMPILERFLAG=""
   DISTLINKAGEFLAG="-L%s -l%s"
fi

cat <<GAZONK >>config.h

#define PVM_ARCH  $PVM_ARCH
#define VPPAP  (PVM_ARCH==VPP || PVM_ARCH==AP3000)
enum pvm_arch { VPP300, VPP700, AP3000 };

#define PVMINC  "$PVM_ROOT/include"
#define PVMLIBDIR  "$PVMLIBDIR"
#define PVMLIB  "$PVMLIB"

#define DIST_COMPILER_FLAG  " -DDIST -I%s -I. -I" PVMINC " %s%s $DISTCOMPILERFLAG"
#define DIST_LINKAGE_FLAG  " $DISTLINKAGEFLAG", PVMLIBDIR, PVMLIB
GAZONK
echo " "

if test $USE_REDUCTION_COUNT = yes;
then
echo "Disabling using interval timer ..."
cat <<GAZONK >>config.h

#undef USETIMER /* disabling use interval timer */

#define USE_REDUCTION_COUNT
#define REDUCTION_COUNTS $REDUCTION_COUNTS
GAZONK
echo " "
fi
