/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#include <stdio.h>  /* NULL */
#include <klic/basic.h>  /* fatalf */
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>
#include <klic/generic.h>
#include <klic/gb.h>
#include <klic/bb.h>
#include <klic/g_float.h>

#define builtin_body_3(macro_body, pred, name)		\
     q x, y;						\
{							\
  extern struct predicate pred;				\
  q z;							\
  if (isint(x)) {					\
  x_ok:							\
    if (isint(y)) {					\
    ok:							\
      macro_body(x, y, z);				\
      return z;						\
    } else if (isref(y)) {				\
      q yy;						\
      yy = derefone(y);					\
    deref_y: \
      if (isint(yy)) {					\
	y = yy;						\
	goto ok;					\
      } else if (isref(yy)) {				\
	if (yy == y) {					\
	  goto suspend_y;				\
	} else {					\
	  q yyy = derefone(yy);				\
	  if (yyy == y) {				\
	    goto suspend_y;				\
	  } else {					\
	    y = yy;					\
            yy = yyy; \
	    goto deref_y;				\
	  }						\
	}						\
      }							\
    }							\
  } else if (isref(x)) {				\
    q xx;						\
    xx = derefone(x);					\
  deref_x: \
    if (isint(xx)) {					\
      x = xx;						\
      goto x_ok;					\
    } else if (isref(xx)) {				\
      if (xx == x) {					\
	goto suspend_x;					\
      } else {						\
	q xxx = derefone(xx);				\
	if (xxx == x) {					\
	  goto suspend_x;				\
	} else {					\
	  x = xx;					\
          xx = xxx; \
	  goto deref_x;					\
	}						\
      }							\
    }							\
  }							\
  builtin_type_error(name); \
 suspend_x:						\
 suspend_y:						\
  return suspend_builtin(&pred, 3, x, y); \
}

#define builtin_body_2(macro_body, pred, name)		\
     q x;						\
{							\
  extern struct predicate pred;				\
  q z;							\
  if (isint(x)) {					\
  ok:							\
    macro_body(x, z);					\
    return z;						\
  } else if (isref(x)) {				\
    q xx;						\
    xx = derefone(x);					\
  deref_x: \
    if (isint(xx)) {					\
      x = xx;						\
      goto ok;						\
    } else if (isref(xx)) {				\
      if (xx == x) {					\
	goto suspend_x;					\
      } else {						\
	q xxx = derefone(xx);				\
	if (xxx == x) {					\
	  goto suspend_x;				\
	} else {					\
	  x = xx;					\
          xx = xxx; \
	  goto deref_x;					\
	}						\
      }							\
    }							\
  }							\
  builtin_type_error(name); \
 suspend_x:						\
  return suspend_builtin(&pred, 2, x, NULL); \
}

static void
enqueue_as_resumed(goal)
     struct goalrec *goal;
{
  declare_globals;
  add_resumed_goal(goal);
  heaplimit = NULL;
}

static q
suspend_builtin(const struct predicate* pred, int i, q x, q y)
{
  declare_globals;
  struct goalrec* goal;
  q z;
  heapalloc(goal, sizeof(struct goalrec)/sizeof(q)+i, (struct goalrec*));
  i--;
  goal->pred = pred;
  goal->args[0] = x;
  if( i == 2 ) goal->args[1] = y;
  goal->args[i] = z = makeref(&goal->args[i]);
  enqueue_as_resumed(goal);
  return z;
}

static void
builtin_type_error(char* name)
{
  fatalf("Argument type error in builtin predicate: %s\n", name);
}

extern q
bblt_add_3(x, y)
  builtin_body_3(bblt_add_no_check,
		 predicate_integer__arithmetics_xadd_3,
		 "add/3")

extern q
bblt_sub_3(x, y)
  builtin_body_3(bblt_sub_no_check,
		 predicate_integer__arithmetics_xsubtract_3,
		 "subtract/3")

extern q
bblt_mult_3(x, y)
  builtin_body_3(bblt_mult_no_check,
		 predicate_integer__arithmetics_xmultiply_3,
		 "multiply/3")

extern q
bblt_div_3(x, y)
  builtin_body_3(bblt_div_no_check,
		 predicate_integer__arithmetics_xdivide_3,
		 "divide/3")

extern q
bblt_mod_3(x, y)
  builtin_body_3(bblt_mod_no_check,
		 predicate_integer__arithmetics_xmodulo_3,
		 "modulo/3")

extern q
bblt_and_3(x, y)
  builtin_body_3(bblt_and_no_check,
		 predicate_integer__arithmetics_xand_3,
		 "and/3")

extern q
bblt_or_3(x, y)
  builtin_body_3(bblt_or_no_check,
		 predicate_integer__arithmetics_xor_3,
		 "or/3")

extern q
bblt_exclusive_or_3(x, y)
  builtin_body_3(bblt_exclusive_or_no_check,
		 predicate_integer__arithmetics_xexclusive__or_3,
		 "exlclusive_or/3")

extern q
bblt_rshift_3(x, y)
  builtin_body_3(bblt_rshift_no_check,
		 predicate_integer__arithmetics_xshift__right_3,
		 "shift_right/3")

extern q
bblt_lshift_3(x, y)
  builtin_body_3(bblt_lshift_no_check,
		 predicate_integer__arithmetics_xshift__left_3,
		 "shift_left/3")

extern q
bblt_plus_2(x)
  builtin_body_2(bblt_plus_no_check,
		 predicate_integer__arithmetics_xplus_2,
		 "plus/2")

extern q
bblt_minus_2(x)
  builtin_body_2(bblt_minus_no_check,
		 predicate_integer__arithmetics_xminus_2,
		 "minus/2")

extern q
bblt_complement_2(x)
  builtin_body_2(bblt_complement_no_check,
		 predicate_integer__arithmetics_xcomplement_2,
		 "complement/2")

extern q
bblt_fix_2(x)
     q x;
{
  extern struct predicate
    predicate_floating__arithmetics_xfloating__point__to__integer_2;
  q z;
  if (isref(x)) {
    q xx;
    xx = derefone(x);
  deref_x:
    if (isref(xx)) {
      q xxx = derefone(xx);
      if (xxx == x) {
	goto suspend_x;
      } else {
	x = xx;
	xx = xxx;
	goto deref_x;
      }
    } else {
      x = xx;
    }
  }
  jump_if_not_in_class(x, float, type_error);
  z = makeint((long)float_value(x));
  return z;

 type_error:
  builtin_type_error("fix/2");
 suspend_x:
  return suspend_builtin
    (&predicate_floating__arithmetics_xfloating__point__to__integer_2,
      2, x, NULL );
}
