/* ---------------------------------------------------------- 
%   (C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#include <assert.h>
#include <klic/basic.h>  /* fatal, klic_fprintf */
#include <klic/struct.h>
#include <klic/unify.h>
#include <klic/alloc.h>  /* register_gc_hook, malloc_check */
#include <klic/sighndl.h>  /* add_signal_handler */
#include "asyncio.h"  /* externs */

#ifdef USESIG
#include <stdio.h>  /* NULL */
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/signal.h>

#ifdef USESELECT
#include <sys/select.h>
#endif

#ifndef SIGIO
#define SIGIO SIGPOLL
#endif
#endif /* USESIG */

extern void copy_one_term();

static q* asyncio_streams = NULL;
static long fd_setsize;
static fd_set sigio_infds;
static fd_set sigio_outfds;
static enum sigiotype* sigio_types;
static sigio_t* sigio_handlers;
static struct timeval zerotime = { 0, 0 };

/* This function may be called from itimer interrupt handler */

static int debugger_flag;
extern void switch_debugger_flag(void){ debugger_flag = ~debugger_flag; }

static int
sigio_handler(allocp, sig)
  q* allocp;
  int sig;
{
    declare_globals;
    fd_set fdsr, fdsw;
    int r;
    static int retry_fd;
    static enum sigiotype retry_sigio_type = KLIC_SIGIO_NONE;

    set_heapp(allocp);
    if (retry_sigio_type != KLIC_SIGIO_NONE) {
      assert(allocp == heapp());
      if( sigio_handlers[retry_fd](retry_fd, retry_sigio_type, &fdsr, &fdsw) != 0 )
	return 1;  /* again */
      /* allocp = heapp(); */
      retry_sigio_type = KLIC_SIGIO_NONE;
    }
    fdsr = sigio_infds;
    fdsw = sigio_outfds;
    r = select(fd_setsize, &fdsr, &fdsw, 0, &zerotime);
    if (debugger_flag) {
      int fd;
      char buffer[100];
      fd = open("/dev/pts/2", 1);
      sprintf(buffer, "%d: r=%d %08x\n", my_node, r, *(int*) &fdsr);
      write(fd, buffer, strlen(buffer));
      close(fd);
    }

    if (r > 0) {
        int fd;
	for (fd = 0; fd < fd_setsize; ++fd) {
	    enum sigiotype call_type;
	    
	    switch (sigio_types[fd]) {
	    case KLIC_SIGIO_IN:
	      if (FD_ISSET(fd, &fdsr))
		call_type = KLIC_SIGIO_IN;
	      else
		continue;
	      break;
	    case KLIC_SIGIO_OUT:
	      if (FD_ISSET(fd, &fdsw))
		call_type = KLIC_SIGIO_OUT;
	      else
		continue;
	      break;
	    case KLIC_SIGIO_INOUT:
	      if (FD_ISSET(fd, &fdsr))
		if (FD_ISSET(fd, &fdsw))
		  call_type = KLIC_SIGIO_INOUT;
		else
		  call_type = KLIC_SIGIO_IN;
	      else if (FD_ISSET(fd, &fdsw))
		call_type = KLIC_SIGIO_OUT;
	      else
		continue;
	      break;
	    default:
	      continue;
	    }
	    /* assert(allocp == heapp()); */
	    if( sigio_handlers[fd](fd, call_type, &fdsr, &fdsw) != 0 ){
	      retry_fd = fd;
	      retry_sigio_type = call_type;
	      return 1;  /* again */
	    }
	    /* allocp = heapp(); */
	}
    }
    /* assert(allocp == heapp()); */
    return 0;
}

extern void
add_sigio_handler(fd, func, sigio_type)
  long fd;
  sigio_t func;
  enum sigiotype sigio_type;
{
    sigio_handlers[fd] = func;
    sigio_types[fd] = sigio_type;
    switch (sigio_type) {
     case KLIC_SIGIO_NONE:
	FD_CLR(fd, &sigio_infds);
	FD_CLR(fd, &sigio_outfds);
	break;
     case KLIC_SIGIO_IN:
	FD_SET(fd, &sigio_infds);
	FD_CLR(fd, &sigio_outfds);
	break;
     case KLIC_SIGIO_OUT:
	FD_CLR(fd, &sigio_infds);
	FD_SET(fd, &sigio_outfds);
	break;
     case KLIC_SIGIO_INOUT:
	FD_SET(fd, &sigio_infds);
	FD_SET(fd, &sigio_outfds);
	break;
    }
}

extern void
init_sigio_handler()
{
  static int sigio_initiated = 0;
  int k;
  if (sigio_initiated)
    return;
#ifdef USEGETDTABLESIZE
  fd_setsize = getdtablesize();
#else
#ifdef USEULIMIT
  fd_setsize = ulimit(4, 0);
  if (fd_setsize < 0) {
    fatal("Can't obtain file descriptor table size");
  }
#else
  fatal("Don't know how to obtaine file descriptor table size");
#endif /* USEULIMIT */
#endif /* USEGETDTABLESIZE */
  sigio_types =
    (enum sigiotype*) malloc_check(sizeof(enum sigiotype) * fd_setsize);
  sigio_handlers = (sigio_t*) malloc_check(sizeof(sigio_t) * fd_setsize);
  for (k = 0; k < fd_setsize; ++k) {
      sigio_handlers[k] = NULL;
      sigio_types[k] = KLIC_SIGIO_NONE;
  }
  FD_ZERO(&sigio_infds);
  FD_ZERO(&sigio_outfds);
#ifdef USESIG
  add_signal_handler(SIGIO, sigio_handler);
#endif /* USESIG */
  sigio_initiated = 1;
}

#ifdef ASYNCIO
static int
send_ready_message(fd, sigio_type, rfd, wfd)
     long fd;
     enum sigiotype sigio_type;
     fd_set *rfd, *wfd;
{
  declare_globals;
  if (asyncio_streams[fd] == NULL) {
    klic_fprintf(stderr, "Unexpected IO interrupt for fd %d ignored\n", fd);
  } else {
    q* allocp = klic_alloc(2);
    q newcons = makecons(allocp);
    q newvar = allocp[0] = makeref(&allocp[0]);
    allocp[1] = makeint(fd);
    do_unify_value(asyncio_streams[fd], newcons);
    asyncio_streams[fd] = newvar;
  }
  return 0;
}

static void
gc_asyncio_streams(void)
{
  long fd;
  for (fd=0; fd<fd_setsize; fd++) {
    /* copy if needed */
    if( asyncio_streams[fd] != NULL )
      copy_one_term(& asyncio_streams[fd]);
  }
}

extern void
init_asynchronous_io()
{
#ifdef USESIG
  static int asyncio_initiated = 0;
  if (!asyncio_initiated) {
    int k;

    init_sigio_handler();
    asyncio_streams = (q*)malloc_check(sizeof(q)*fd_setsize);
    for (k=0; k<fd_setsize; k++)
      asyncio_streams[k] = NULL;
    register_gc_hook(gc_asyncio_streams);
    asyncio_initiated = 1;
  }
#endif
}

extern void
close_asynchronous_io_stream(fd)
     long fd;
{
#ifdef USESIG
  add_sigio_handler(fd, NULL, KLIC_SIGIO_NONE);
  asyncio_streams[fd] = NULL;
#endif
}

extern void
register_asynchronous_io_stream(fd, stream)
     long fd;
     q stream;
{
#ifdef USESIG
  add_sigio_handler(fd, send_ready_message, KLIC_SIGIO_INOUT);
  asyncio_streams[fd] = stream;
#endif
}
#endif /* ASYNCIO*/

extern int
poll_read_available(fd)
     int fd;
{
  fd_set fds;
  FD_ZERO(&fds);
  FD_SET(fd, &fds);
  return select(fd_setsize, &fds, 0, 0, &zerotime);
}
