/* -------------------------------------------------------------
% Copyright 2001, TAKAGI Yusuke
%   (Read COPYRIGHT for detailed information.)
------------------------------------------------------------- */

#ifndef _KLIC_STDC_H_
#define _KLIC_STDC_H_

#include <klic/config.h>

/* for compatibility with non-standard C */

#ifdef __STDC__
#define CONCATENATE(x,y)     x ## y
#define CONCATENATE_3(x,y,z) x ## y ## z
#define STRINGIFY(s)         # s

#define USE_STDARG
#include <stdarg.h>
#define VA_START(A, L)	va_start(A, L)
#define VA_ARGS(A)	A

#else  /* !__STDC__ */
#define const
#define volatile

#define CONCATENATE(x,y)     x/**/y
#define CONCATENATE_3(x,y,z) x/**/y/**/z
#define STRINGIFY(s)         "s"

#include <varargs.h>
#define VA_START(A, L)	va_start(A)
#define VA_ARGS(A)	()
#endif  /* !__STDC__ */


#ifdef STRINGH
#include <string.h>
#else
#include <strings.h>
#endif

#ifdef STDDEFH
#include <stddef.h>
#else
#ifndef size_t
#define size_t  unsigned int
#endif
#endif

#endif  /* _KLIC_STDC_H_ */
