/* ---------------------------------------------------------- 
%   (C)1993,1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_GG_MACRO_H_
#define _KLIC_GG_MACRO_H_

#include <klic/stdc.h>  /* CONCATENATE */
#include <klic/basic.h>  /* fatal, klic_fprintf */

extern q GC_wakeup_g_new();

/* runtime/unify.c */
extern void do_shallow_unify(q x, q y);


/* runtime/generic.c */

extern void G_MAKE_THE_NEW_GOAL(
  q* var, struct goalrec** goalp1, q(*myself)(),
  unsigned long argc, q argv[] );

extern void G_SUSPEND(q x, struct goalrec* goal);
extern q GG_MAKE_HOOK_VAR(struct generator_object* obj);


#define GG_rappend(pref) G_rappend0(GG_CLASS_NAME(),pref)

#define GG_OBJ_SIZE G_SIZE_IN_Q(GG_OBJ_TYPE)

#define GG_method_table0(class)  CONCATENATE(class, _g_generator_method_table)

#define GG_method_table GG_method_table0(GG_CLASS_NAME())

#define GG_CLASS_NAME_STRING G_stringify(GG_CLASS_NAME())

#define GG_FAIL(errmsg) fatal(errmsg)
#define GG_GCREQUEST GENERIC_GCREQUEST
#define GG_RETURN  do{ return heapp(); }while(0)

#define GG_TERMINATE  do{ return !0; }while(0)

#define GG_SUSPEND(var) \
do{ \
  q newvar, tmp; \
  q argv[2]; \
  G_MAKE_VAR(newvar); \
  argv[0] = GG_TERM; \
  argv[1] = newvar; \
  tmp = GC_wakeup_g_new(2, argv); \
  GG_KL1_UNIFY((var), tmp); \
  return heapp(); \
}while(0)

#define GG_SWITCH_ON_TERM(cons,atomic,funct,dobj,susp) \
do{ \
  while (1) { \
    if (!isstruct(GG_TERM)) { \
      if (atomicnotref(GG_TERM)) { \
	goto atomic; \
      } else { \
	q temp0 = derefone(GG_TERM); \
	if(isref(temp0) && (GG_TERM) == derefone(temp0)) { \
	  goto susp; \
	} else { \
	  (GG_TERM) = temp0; \
	} \
      } \
    } else if(functnotcons(GG_TERM)) {\
	if(isref(functor_of(GG_TERM))) { \
	  goto dobj; \
	} else {\
           goto funct; \
        } \
    } else goto cons; \
  } \
}while(0)

/***************************************************************************/

#define GG_DEREF(x) \
do{ \
  while (1) { \
    if (!isstruct(x)) { \
      if (atomicnotref(x)) { \
	break; \
      } else { \
	q temp0 = derefone(x); \
	if(isref(temp0) && (x) == derefone(temp0)) { \
	  GG_SUSPEND(x); \
	  return heapp(); \
	} else { \
	  (x) = temp0; \
	} \
      } \
    } else { \
      break; \
    } \
  } \
}while(0)

#define GG_TRY_TO_ALLOC(new,type,size,label) \
do{ \
  G_HEAPALLOC((new), (size), type); \
  if((long) real_heaplimit() <= (long) heapp()) { \
    goto label; \
  } \
}while(0)

/**************************************************************************/

#define GGset_myself_for_new \
  q (*g_myself)() = GG_rappend(new)

#define GG_STD_DECL_FOR_NEW \
  G_STD_DECL; GGset_myself_for_new

#define GGDEF_NEW() \
extern q GG_rappend(new) (long GG_ARGC, q* GG_ARGV)

#define GG_DEREF_FOR_NEW(x) \
do{ \
  while (1) { \
    if (!isstruct(x)) { \
      if (atomicnotref(x)) { \
	break; \
      } else { \
	q temp0 = derefone(x); \
	if(isref(temp0) && (x) == derefone(temp0)) { \
          q var; \
          struct goalrec *goal; \
	  G_MAKE_THE_NEW_GOAL(&var, &goal, g_myself, GG_ARGC, GG_ARGV); \
          G_SUSPEND((x), goal); \
          GG_RETURN_FROM_NEW(var); \
	} else { \
	  (x) = temp0; \
	} \
      } \
    } else { \
      break; \
    } \
  } \
}while(0)

#define GGSET_NEWOBJ_FOR_NEW(newgobj, type) \
do{ \
  q res; \
  G_HEAPALLOC_WITH_CHECK((newgobj), GG_OBJ_SIZE, type, res); \
  if(GG_GCREQUEST == res) { \
    q var; \
    struct goalrec *goal; \
    G_MAKE_THE_NEW_GOAL(&var, &goal, g_myself, GG_ARGC, GG_ARGV); \
    G_PUSH_GOAL_TO_SPECIAL_QUEUE(goal); \
    GG_RETURN_FROM_NEW(var); \
  } \
  (newgobj)->method_table = &GG_method_table; \
}while(0)

#define GG_RETURN_FROM_NEW(var) \
do{ \
  return (var); \
}while(0)

/**********************************************************************/

#define GGDEF_UNIFY() \
static int GG_rappend(active_unify) (q GG_SELF, q GG_TERM)

#define GGDEF_SUSPEND() \
static q \
GG_rappend(suspend) (GG_SELF, GG_GOAL) \
  q GG_SELF; \
  struct goalrec* GG_GOAL;

#define GGDEF_GENERATE() \
static q GG_rappend(generate) (GG_OBJ_TYPE* GG_SELF)

#define GGDEF_PRINT() \
  static \
  long \
  GG_rappend(print) (GG_SELF,g_fp,g_depth,g_length) \
    GG_OBJ_TYPE *GG_SELF; \
    FILE *g_fp; \
    unsigned long g_depth; \
    unsigned long g_length;

/******************************************************************/


#define GGDEF_GC() \
static q* GG_rappend(gc) (GG_OBJ_TYPE* GG_SELF)

#define GGSET_NEWOBJ_IN_NEWGEN(newobj) \
do{ \
  unsigned long size = GG_OBJ_SIZE; \
  *heapp() = (q) GG_SELF->method_table; \
  (newobj) = (GG_OBJ_TYPE *) klic_alloc(size); \
  if(heapp() > real_heaplimit()) fatal("not enough space collected"); \
}while(0)

#define GG_RETURN_FROM_GC(newgobj) \
do{ \
  return(((q *)(newgobj))); \
}while(0)

#define GGDEF_DEALLOCATE() \
  static void \
  GG_rappend(deallocate) (GG_SELF) \
    GG_OBJ_TYPE* GG_SELF;

/*******************************************/

#define GGSET_INTARG_FOR_NEW(var,argv_i) \
do{ \
  GG_DEREF_FOR_NEW(argv_i); \
  if(!G_ISINT(argv_i)) GG_FAIL("not integer"); \
  (var) = G_INTVAL(argv_i); \
}while(0)

extern struct predicate predicate_unify__term__dcode_xunify__goal_2;
#define GG_KL1_UNIFY(x, y) \
do{ \
  struct goalrec *gp; \
  G_HEAPALLOC(gp, 4, (struct goalrec *)); \
  gp->pred = &predicate_unify__term__dcode_xunify__goal_2; \
  gp->args[0] = (x); \
  gp->args[1] = (y); \
  resume_same_prio(gp); \
}while(0)

/*** for Distribute KLIC system ***/

#define GGDEF_ENCODE() \
  static q \
  GG_rappend(encode) (GG_SELF, buffer, depth)\
    GG_OBJ_TYPE *GG_SELF;\
    combuf *buffer;\
    long depth;

#endif /* _KLIC_GG_MACRO_H_ */
