/* ----------------------------------------------------------
%   (C)1993,1994,1995 Institute for New Generation Computer Technology
%       (Read COPYRIGHT for detailed information.)
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_GC_MACRO_H_
#define _KLIC_GC_MACRO_H_

#include <klic/stdc.h>  /* CONCATENATE */
#include <klic/basic.h>  /* fatal, debug_printf, klic_fprintf, klic_putc */

extern q GC_wakeup_g_new();

/* runtime/unify.c */
extern void do_shallow_unify(q x, q y);
extern void do_shallow_unify_value(q x, q y);
extern void set_rest_of_stream(q term);
extern void set_method_result(q term);

/* runtime/generic.c */
extern void G_SUSPEND(q x, struct goalrec* goal);
extern void G_MAKE_THE_NEW_GOAL(
  q* var, struct goalrec** goalp1, q(*myself)(),
  unsigned long argc, q argv[] );

#define GC_rappend(pref) G_rappend0(GC_CLASS_NAME(),pref)

/* runtime/generic.c */
extern q GC_MAKE_HOOK_VAR(struct consumer_object* obj);

#define GC_method_table0(class)  CONCATENATE(class, _g_data_method_table)

#define GC_method_table GC_method_table0(GC_CLASS_NAME())

#define GC_CLASS_NAME_STRING G_stringify(GC_CLASS_NAME())

#define    GC_FAIL(errmsg)    fatal(errmsg)
#define	   GC_ERROR_IN_NEW(errmsg) \
  G_error((errmsg), "creation", "consumer", GC_CLASS_NAME_STRING)
#define    GC_SUCCEEDED       GENERIC_SUCCEEDED
#define    GC_GCREQUEST       GENERIC_GCREQUEST

#define    GC_RETURN_WITH_HOOK(x) \
do{ \
  set_method_result(GC_SUCCEEDED); \
  set_rest_of_stream(x); \
  return; \
}while(0)

#define GC_TERMINATE \
do{ \
  set_method_result(GC_SUCCEEDED); \
  set_rest_of_stream(NULL); \
  return; \
}while(0)

#define GC_SUSPEND(var) \
do{ \
  q newvar, tmp; \
  q argv[2]; \
  set_method_result(GC_SUCCEEDED); \
  G_MAKE_VAR(newvar); \
  set_rest_of_stream(newvar); \
  argv[0] = GC_TERM; \
  argv[1] = newvar; \
  tmp = GC_wakeup_g_new(2, argv); \
  GC_KL1_UNIFY((var), tmp); \
  return heapp(); \
}while(0)

/**************************************************/

#define GC_SWITCH_ON_TERM(cons,atomic,funct,dobj,susp) \
do{ \
  while (1) { \
    if (!isstruct(GC_TERM)) { \
      if (atomicnotref(GC_TERM)) { \
	goto atomic; \
      } else { \
	q temp0 = derefone(GC_TERM); \
	if(isref(temp0) && (GC_TERM) == derefone(temp0)) { \
	  goto susp; \
	} else { \
	  (GC_TERM) = temp0; \
	} \
      } \
    } else if(functnotcons(GC_TERM)) {\
	if(isref(functor_of(GC_TERM))) { \
	  goto dobj; \
	} else {\
           goto funct; \
        } \
    } else goto cons; \
  } \
}while(0)

/***************************************************************************/

#define GC_TRY_TO_ALLOC(new, type, size, gc_request) \
do{ \
  q res; \
  G_HEAPALLOC_WITH_CHECK((new), (size), type, res); \
  if (GC_GCREQUEST == res) goto gc_request; \
}while(0)


#define GC_UNIFY(x,y) \
  (do_shallow_unify((x), (y)))

#define GC_UNIFY_VALUE(x, y)					\
do{								\
  if (!isref(x) || derefone(x) != (x)) {			\
    do_shallow_unify_value((x), (y));	\
  } else {							\
    derefone(x) = (y);						\
  }								\
}while(0)

/**************************************************************************/

#define GCset_myself_for_new \
  q (*g_myself)() = GC_rappend(new)

#define GC_STD_DECL_FOR_NEW \
  G_STD_DECL; \
  GCset_myself_for_new


#define GCDEF_NEW() \
extern q GC_rappend(new) (long GC_ARGC, q* GC_ARGV)

#define GC_DEREF_FOR_NEW(x) \
do{ \
  while (1) { \
    if (!isstruct(x)) { \
      if (atomicnotref(x)) { \
	break; \
      } else { \
	q temp0 = derefone(x); \
	if(isref(temp0) && (x) == derefone(temp0)) { \
          q var; \
          struct goalrec *goal; \
	  G_MAKE_THE_NEW_GOAL(&var, &goal, g_myself, GC_ARGC, GC_ARGV); \
          G_SUSPEND((x), goal); \
          GC_RETURN_FROM_NEW(var); \
	} else { \
	  (x) = temp0; \
	} \
      } \
    } else { \
      break; \
    } \
  } \
}while(0)


#define GCSET_NEWOBJ_FOR_NEW(newgobj,size) \
do{ \
  q res; \
  G_HEAPALLOC_WITH_CHECK((newgobj), (size), (GC_OBJ_TYPE*), res); \
  if(GC_GCREQUEST == res){ \
    q var; \
    struct goalrec *goal; \
    G_MAKE_THE_NEW_GOAL(&var, &goal, g_myself, GC_ARGC, GC_ARGV); \
    G_PUSH_GOAL_TO_SPECIAL_QUEUE(goal); \
    GC_RETURN_FROM_NEW(var); \
  } \
  (newgobj)->method_table = &GC_method_table; \
}while(0)

#define GC_RETURN_FROM_NEW(x) \
do{ \
  return (x); \
}while(0)


/**********************************************************************/

#define GCDEF_UNIFY() \
static void GC_rappend(active_unify) (GC_OBJ_TYPE* GC_SELF, q GC_TERM)

#define GC_PRINT(x) klic_fprintf(g_fp, (x))

#define GC_RETURN_FROM_PRINT  do{ return 1L; }while(0)

#define GCDEF_PRINT() \
  static \
  long \
  GC_rappend(print) (GC_SELF,g_fp,g_depth,g_length) \
    GC_OBJ_TYPE *GC_SELF; \
    FILE *g_fp; \
    unsigned long g_depth; \
    unsigned long g_length;

/******************************************************************/

#define GCDEF_GC() \
static q* GC_rappend(gc) (GC_OBJ_TYPE* GC_SELF)

#define GCSET_NEWOBJ_IN_NEWGEN(newobj) \
do{ \
  unsigned long size = GC_OBJ_SIZE(GC_SELF); \
  *heapp() = (q) GC_SELF->method_table; \
  (newobj) = (GC_OBJ_TYPE*) klic_alloc(size); \
  if(heapp() > real_heaplimit()) fatal("not enough space collected"); \
}while(0)

#define GC_RETURN_FROM_GC(newgobj) \
do{ \
  return (q *) (newgobj); \
}while(0)

#define GCDEF_DEALLOCATE() \
  static void \
  GC_rappend(deallocate) (GC_SELF) \
    GC_OBJ_TYPE* GC_SELF;

/*******************************************/

#define GCSET_MESSAGE(message)					\
do{								\
  (message) = G_CAR_OF(GC_TERM);				\
  while (G_ISREF(message)) {					\
    q temp = G_DEREFONE(message);				\
    if (G_ISREF(temp) &&					\
	(temp == (message) || G_DEREFONE(temp) == (message))) {	\
      reason = (message);					\
      GC_SELF->stream = GC_TERM;				\
      goto suspend;						\
    } else {							\
      (message) = temp;						\
    }								\
  }								\
}while(0)

#define GCSET_MESSAGE_INT_ARG(arg, message, pos)		\
do{								\
  q temp = G_ARG((message), (pos));				\
  while (!G_ISINT(temp)) {					\
    if (G_ISREF(temp)) {					\
      q temp1 = G_DEREFONE(temp);				\
      if (G_ISREF(temp1) && G_DEREFONE(temp1) == temp) {	\
	reason = temp1;						\
	GC_SELF->stream = GC_TERM;				\
	goto suspend;						\
      }								\
      temp = temp1;						\
    } else {							\
      goto message_error;					\
    }								\
  }								\
  (arg) = G_INTVAL(temp);					\
}while(0)

#define GCSET_MESSAGE_STR_ARG(arg, message, pos)		\
do{								\
  q temp = G_ARG((message), (pos));				\
  while (!G_ISGOBJ(temp) ||					\
	 (struct data_object_method_table *)			\
	 G_FUNCTOR_OF(temp) !=					\
	 &byte__string_g_data_method_table) {			\
    if (G_ISREF(temp)) {					\
      q temp1 = G_DEREFONE(temp);				\
      if (G_ISREF(temp1) && G_DEREFONE(temp1) == temp) {	\
	reason = temp1;						\
	GC_SELF->stream = GC_TERM;				\
	goto suspend;						\
      }								\
      temp = temp1;						\
    } else {							\
      goto message_error;					\
    }								\
  }								\
  (arg) = (struct byte_string_object *) G_FUNCTORP(temp);	\
}while(0)

#define GCSET_VAR(self)  ((self) = G_MAKEREF(&(self)))

extern struct predicate predicate_unify__term__dcode_xunify__goal_2;
#define GC_KL1_UNIFY(x, y) \
do{ \
  struct goalrec *gp; \
  G_HEAPALLOC(gp, 4, (struct goalrec *)); \
  gp->pred = &predicate_unify__term__dcode_xunify__goal_2; \
  gp->args[0] = (x); \
  gp->args[1] = (y); \
  resume_same_prio(gp); \
}while(0)

#endif /* _KLIC_GC_MACRO_H_ */
