/* ---------------------------------------------------------- 
%   (C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_G_BASIC_H_
#define _KLIC_G_BASIC_H_

#include <assert.h>
#include <klic/stdc.h>  /* CONCATENATE*, STRINGIFY */

/* external module/class reference */

#define G_USE_PREDICATE(name) \
extern const struct predicate name

/* type judgement. */
#define G_ISCONS(x) iscons(x)
#define G_ISFUNCTOR(x) isfunctor(x)
#define G_ISREF(x) isref(x)
#define G_ISINT(x) isint(x)
#define G_ISSYM(x) issym(x)
#define G_ISGOBJ(x) (isfunctor(x) && isref(functor_of(x)))

/* data manipulation macro. */
#define G_FUNCTOR_OF(s) functor_of(s)
#define G_ARG(s, k) arg(s, k)
#define G_CAR_OF(x) car_of(x)
#define G_CDR_OF(x) cdr_of(x)
#define G_DEREFONE(x) derefone(x)

/* convertion. C->KLIC. */
#define G_MAKEINT(n) makeint(n)
#define G_MAKEREF(x) makeref(x)
#define G_MAKECONS(x) makecons(x)
#define G_MAKEFUNCTOR(x) makefunctor(x)

/* convertion. KLIC->C. */
#define G_INTVAL(x) intval(x)
#define G_SYMVAL(x) symval(x)
#define G_FUNCTORP(x) functorp(x)

#define G_functor(fa)  CONCATENATE(functor_, fa)
#define G_atom(fa)     CONCATENATE(atom_, fa)
#define G_stringify(s) STRINGIFY(s)

#define G_rappend0(class,post) CONCATENATE_3(class, _g_, post)
#define G_guard0(class,fa)     CONCATENATE_3(class, _g_guard_, fa)
#define G_body0(class,fa)      CONCATENATE_3(class, _g_body_, fa)


/** G_HEAPALLOC: procedure
 * from: type&
 * size > 0: offset_t
 * type: type cast or function returning q
 */
#define G_HEAPALLOC(from,size,type) \
do{ \
  (from) = type(klic_alloc(size)); \
}while(0)


/** G_HEAPALLOC_WITH_CHECK: procedure
 * from: type&
 * size > 0: offset_t
 * type: type cast or function returning q
 * res: {GENERIC_GCREQUEST, GENERIC_SUCCEEDED}&
 */
#define G_HEAPALLOC_WITH_CHECK(from,size,type,res) \
do{ \
  if ((long) real_heaplimit() <= (long) (heapp() + (size))) { \
    add_this_more_space(size); \
    heaplimit = 0; \
    (res) = GENERIC_GCREQUEST; \
  } else { \
    G_HEAPALLOC((from), (size), type); \
    (res) = GENERIC_SUCCEEDED; \
  } \
}while(0)


/** G_MAKE_VAR: procedure
 * x: q&
 */
#define G_MAKE_VAR(x) \
do{ \
  G_HEAPALLOC((x), 1, (q)); \
  derefone(x) = (x); \
}while(0)


#define G_STD_DECL struct global_variables* glbl = My_glbl

#define G_SIZE_IN_Q(type) ((sizeof(type)+sizeof(q)-1) / sizeof(q))

/* runtime/gc.c */
extern void push_gc_stack(q* addr);


/** G_COPY_KL1_TERM_TO_NEWGEN: procedure
 * from: q
 * to: q&
 */
#define G_COPY_KL1_TERM_TO_NEWGEN(from,to) \
do{ \
  if(isref(from)) { \
    q* newword = klic_alloc(1); \
    derefone(newword) = (from); \
    (to) = makeref(newword); \
    push_gc_stack(newword); \
  } else { \
    (to) = (from); \
    push_gc_stack(&(to)); \
  } \
}while(0)


/** G_PUSH_GOAL: procedure
 * goal: struct goalrec*
 */

#define G_PUSH_GOAL(goal) \
do{ resume_same_prio(goal); }while(0)

#define G_PUSH_GOAL_TO_SPECIAL_QUEUE(goal) \
  G_PUSH_GOAL(goal)


/*
  deta flag for Object Table
*/

#define G_DATA 0
#define G_CONSUMER 1
#define G_GENERATOR 2

/*
  external functions
*/

/* runtime/generic.c */
extern NeverReturn void
G_error(char* errmsg, char* where, char* object_kind, char* class);

#endif /* _KLIC_G_BASIC_H_ */
