/* ---------------------------------------------------------- 
%   (C)1993,1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_CONTROL_H_
#define _KLIC_CONTROL_H_

#include <assert.h>
#include <klic/alloc.h>  /* klic_interrupt */

/* runtime/faisus.c */
extern void interrupt_goal(const struct predicate* pred, q* reasonp);
extern int check_stack_for_alternatively(q* reasonp);


/* runtime/sched.c */

extern struct goalrec* enqueue_goal(
  struct goalrec* qp, long prio,
  struct goalrec* gp, struct global_variables* glbl );

extern struct goalrec* enqueue_after_waiting(
  struct goalrec* qp, q prio,
  struct goalrec* gp, int is_relative );

extern struct goalrec* enqueue_throw_goal(
  q penum, struct goalrec* gp, struct goalrec* qp );


/** enqueue_at_priority: procedure
 * p: q  priority
 * q0: struct goalrec*
 * q: struct goalrec*
 */

#define _ENQUEUE_AT_PRIORITY(p, q0, q, is_rel) \
  (assert(allocp==heapp()), \
    (qp = enqueue_after_waiting((struct goalrec*) (q0), \
      (p), (struct goalrec*) (q), (is_rel)) ))

#define _ENQUEUE_AT_PRIORITY_NO_CHECK(prio, q0, q) \
  (qp = enqueue_goal((struct goalrec*) (q0), \
    (long) (prio), (struct goalrec*) (q), glbl))

#define enqueue_at_priority(p, q0, q)			\
do{ assert(allocp==heapp()); _ENQUEUE_AT_PRIORITY(p, q0, q, 0); }while(0)

#define enqueue_at_lower_priority(p, q0, q)		\
do{ assert(allocp==heapp()); _ENQUEUE_AT_PRIORITY(p, q0, q, 1); }while(0)

#define enqueue_at_priority_no_check(x, q0, q)		\
do{							\
  _ENQUEUE_AT_PRIORITY_NO_CHECK(intval(x), q0, q); \
}while(0)

#define enqueue_at_lower_priority_no_check(x, q0, q)	\
do{							\
  long prio = current_prio() - intval(x); \
  _ENQUEUE_AT_PRIORITY_NO_CHECK(prio, q0, q); \
}while(0)


#define switch_on_pred()	switch (toppred->pred)

#define case_pred(p, label)	case (p): goto label;

#define last_case_pred(p, label) default: goto label;


#if defined(DIST) && defined(USE_REDUCTION_COUNT)
#define _INC_REDUCTION_COUNT(maxcount) \
do{ \
  if (reduction_count() < (maxcount)) { \
    inc_reduction_count(); \
  } else { \
    reset_reduction_count(); \
    heaplimit = 0; \
  } \
}while(0)
#else /* !defined(DIST) || !defined(USE_REDUCTION_COUNT) */
#define _INC_REDUCTION_COUNT(maxcount)
#endif


/** loop_witin_module: procedure
 * f: module (*)()
 */
#define loop_within_module(f)				\
do{ \
  module (*func)(); \
  _INC_REDUCTION_COUNT(REDUCTION_COUNTS); \
  if (allocp >= heaplimit) { \
    set_heapp(allocp); \
    klic_interrupt(qp); \
    allocp = heapp(); \
    qp = current_queue; \
  } \
  toppred = qp->pred; \
  func = toppred->func; \
  if (func == (f)) \
    goto module_top; \
  set_heapp(allocp); \
  current_queue = qp; \
  return (module) func; \
}while(0)

#define execute(label) \
do{ \
  _INC_REDUCTION_COUNT(500); \
  if (allocp < heaplimit) goto label; \
}while(0)

#define proceed()		\
do{				\
  goto proceed_label;		\
}while(0)


/** throw_goal: procedure
 * node > 0: q  number of the processor element
 * oldqp: struct goalrec*
 * goal: struct goalrec*
 */
#define throw_goal(node, oldqp, goal) \
do{ \
  set_heapp(allocp); \
  qp = enqueue_throw_goal((node), (struct goalrec*) (goal), \
    (struct goalrec*) (oldqp)); \
}while(0)

#endif /* _KLIC_CONTROL_H_ */
