/* ----------------------------------------------------------
%   (C)1993,1994,1995 Institute for New Generation Computer Technology
%       (Read COPYRIGHT for detailed information.)
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_BB_H_
#define _KLIC_BB_H_

/*
  Addition
*/

extern q bblt_add_3(q x, q y);

#define bblt_add(x, y, z)					\
do{								\
  if (!isint(x) || !isint(y)) {					\
    (z) = bblt_add_3((x), (y));					\
  } else {							\
    bblt_add_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_add_no_check_x(x, y, z)				\
do{								\
  if (!isint(y)) {						\
    (z) = bblt_add_3((x), (y));					\
  } else {							\
    bblt_add_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_add_no_check_y(x, y, z)				\
do{								\
  if (!isint(x)) {						\
    (z) = bblt_add_3((x), (y));					\
  } else {							\
    bblt_add_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_add_no_check(x, y, z)				\
do{ (z) = (q) ((unsigned long)(x) + (unsigned long)(y) - INT); }while(0)

/*
  Subtraction
*/

extern q bblt_sub_3(q x, q y);

#define bblt_sub(x, y, z)					\
do{								\
  if (!isint(x) || !isint(y)) {					\
    (z) = bblt_sub_3((x), (y));					\
  } else {							\
    bblt_sub_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_sub_no_check_x(x, y, z)				\
do{								\
  if (!isint(y)) {						\
    (z) = bblt_sub_3((x), (y));					\
  } else {							\
    bblt_sub_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_sub_no_check_y(x, y, z)				\
do{								\
  if (!isint(x)) {						\
    (z) = bblt_sub_3((x), (y));					\
  } else {							\
    bblt_sub_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_sub_no_check(x, y, z)				\
do{ (z) = (q) ((unsigned long)(x) - ((unsigned long)(y) - INT)); }while(0)

/*
  Multiplication
*/

extern q bblt_mult_3(q x, q y);

#define bblt_mult(x, y, z)					\
do{								\
  if (!isint(x) || !isint(y)) {					\
    (z) = bblt_mult_3((x), (y));				\
  } else {							\
    bblt_mult_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_mult_no_check_x(x, y, z)				\
do{								\
  if (!isint(y)) {						\
    (z) = bblt_mult_3((x), (y));				\
  } else {							\
    bblt_mult_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_mult_no_check_y(x, y, z)				\
do{								\
  if (!isint(x)) {						\
    (z) = bblt_mult_3((x), (y));				\
  } else {							\
    bblt_mult_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_mult_no_check(x, y, z)				\
do{ (z) = (q) (((long)(x) - INT) * (intval(y)) + INT); }while(0)

/*
  Division
*/

extern q bblt_div_3(q x, q y);

#define bblt_div(x, y, z)					\
do{								\
  if (!isint(x) || !isint(y)) {					\
    (z) = bblt_div_3((x), (y));					\
  } else {							\
    bblt_div_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_div_no_check_x(x, y, z)				\
do{								\
  if (!isint(y)) {						\
    (z) = bblt_div_3((x), (y));					\
  } else {							\
    bblt_div_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_div_no_check_y(x, y, z)				\
do{								\
  if (!isint(x)) {						\
    (z) = bblt_div_3((x), (y));					\
  } else {							\
    bblt_div_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_div_no_check(x, y, z)				\
do{ (z) = makeint(((long)(x) - INT) / ((long)(y) - INT)); }while(0)

/*
  Modulo
*/

extern q bblt_mod_3(q x, q y);

#define bblt_mod(x, y, z)					\
do{								\
  if (!isint(x) || !isint(y)) {					\
    (z) = bblt_mod_3((x), (y));					\
  } else {							\
    bblt_mod_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_mod_no_check_x(x, y, z)				\
do{								\
  if (!isint(y)) {						\
    (z) = bblt_mod_3((x), (y));					\
  } else {							\
    bblt_mod_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_mod_no_check_y(x, y, z)				\
do{								\
  if (!isint(x)) {						\
    (z) = bblt_mod_3((x), (y));					\
  } else {							\
    bblt_mod_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_mod_no_check(x, y, z)				\
do{ (z) = (q) (((long)(x) - INT) % ((long)(y) - INT) + INT); }while(0)

/*
  Bitwise Logical And
*/

extern q bblt_and_3(q x, q y);

#define bblt_and(x, y, z)					\
do{								\
  if (!isint(x) || !isint(y)) {					\
    (z) = bblt_and_3((x), (y));					\
  } else {							\
    bblt_and_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_and_no_check_x(x, y, z)				\
do{								\
  if (!isint(y)) {						\
    (z) = bblt_and_3((x), (y));					\
  } else {							\
    bblt_and_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_and_no_check_y(x, y, z)				\
do{								\
  if (!isint(x)) {						\
    (z) = bblt_and_3((x), (y));					\
  } else {							\
    bblt_and_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_and_no_check(x, y, z)				\
do{ (z) = (q) ((long)(x) & (long)(y)); }while(0)

/*
  Bitwise Logical Or
*/

extern q bblt_or_3(q x, q y);

#define bblt_or(x, y, z)					\
do{								\
  if (!isint(x) || !isint(y)) {					\
    (z) = bblt_or_3((x), (y));					\
  } else {							\
    bblt_or_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_or_no_check_x(x, y, z)				\
do{								\
  if (!isint(y)) {						\
    (z) = bblt_or_3((x), (y));					\
  } else {							\
    bblt_or_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_or_no_check_y(x, y, z)				\
do{								\
  if (!isint(x)) {						\
    (z) = bblt_or_3((x), (y));					\
  } else {							\
    bblt_or_no_check((x), (y), (z));				\
  }								\
}while(0)

#define bblt_or_no_check(x, y, z)				\
do{ (z) = (q) ((long)(x) | (long)(y)); }while(0)

/*
  Bitwise Logical Exclusive Or
*/

extern q bblt_exclusive_or_3(q x, q y);

#define bblt_exclusive_or(x, y, z)				\
do{								\
  if (!isint(x) || !isint(y)) {					\
    (z) = bblt_exclusive_or_3((x), (y));			\
  } else {							\
    bblt_exclusive_or_no_check((x), (y), (z));			\
  }								\
}while(0)

#define bblt_exclusive_or_no_check_x(x, y, z)			\
do{								\
  if (!isint(y)) {						\
    (z) = bblt_exclusive_or_3((x), (y));			\
  } else {							\
    bblt_exclusive_or_no_check((x), (y), (z));			\
  }								\
}while(0)

#define bblt_exclusive_or_no_check_y(x, y, z)			\
do{								\
  if (!isint(x)) {						\
    (z) = bblt_exclusive_or_3((x), (y));			\
  } else {							\
    bblt_exclusive_or_no_check((x), (y), (z));			\
  }								\
}while(0)

#define bblt_exclusive_or_no_check(x, y, z)			\
do{ (z) = (q) (((long)(x) ^ (long)(y)) + INT); }while(0)

/*
  Right Shift
*/

extern q bblt_rshift_3(q x, q y);

#define bblt_rshift(x, y, z)					\
do{								\
  if (!isint(x) || !isint(y)) {					\
    (z) = bblt_rshift_3((x), (y));				\
  } else {							\
    bblt_rshift_no_check((x), (y), (z));			\
  }								\
}while(0)

#define bblt_rshift_no_check_x(x, y, z)				\
do{								\
  if (!isint(y)) {						\
    (z) = bblt_rshift_3((x), (y));				\
  } else {							\
    bblt_rshift_no_check((x), (y), (z));			\
  }								\
}while(0)

#define bblt_rshift_no_check_y(x, y, z)				\
do{								\
  if (!isint(x)) {						\
    (z) = bblt_rshift_3((x), (y));				\
  } else {							\
    bblt_rshift_no_check((x), (y), (z));			\
  }								\
}while(0)

#define bblt_rshift_no_check(x, y, z)				\
do{ (z) = makeint(intval(x) >> intval(y)); }while(0)

/*
  Left Shift
*/

extern q bblt_lshift_3(q x, q y);

#define bblt_lshift(x, y, z)					\
do{								\
  if (!isint(x) || !isint(y)) {					\
    (z) = bblt_lshift_3((x), (y));				\
  } else {							\
    bblt_lshift_no_check((x), (y), (z));			\
  }								\
}while(0)

#define bblt_lshift_no_check_x(x, y, z)				\
do{								\
  if (!isint(y)) {						\
    (z) = bblt_lshift_3((x), (y));				\
  } else {							\
    bblt_lshift_no_check((x), (y), (z));			\
  }								\
}while(0)

#define bblt_lshift_no_check_y(x, y, z)				\
do{								\
  if (!isint(x)) {						\
    (z) = bblt_lshift_3((x), (y));				\
  } else {							\
    bblt_lshift_no_check((x), (y), (z));			\
  }								\
}while(0)

#define bblt_lshift_no_check(x, y, z)				\
do{ (z) = (q) ((((long)(x) - INT) << intval(y)) + INT); }while(0)

/*
  Bitwise Complement
*/

extern q bblt_complement_2(q x);

#define bblt_complement(x, z)					\
do{								\
  if (!isint(x)) {						\
    (z) = bblt_complement_2(x);					\
  } else {							\
    bblt_complement_no_check((x), (z));				\
  }								\
}while(0)

#define bblt_complement_no_check(x, z)				\
do{ (z) = (q) ((long)(x) ^ ((-1L) << ATAGBITS)); }while(0)

/*
  Unary Plus
*/

extern q bblt_plus_2(q x);

#define bblt_plus(x, z)						\
do{								\
  if (!isint(x)) {						\
    (z) = bblt_plus_2(x);					\
  } else {							\
    bblt_plus_no_check((x), (z));				\
  }								\
}while(0)

#define bblt_plus_no_check(x, z)				\
do{ (z) = (x); }while(0)

/*
  Unary Minus
*/

extern q bblt_minus_2(q x);

#define bblt_minus(x, z)					\
do{								\
  if (!isint(x)) {						\
    (z) = bblt_minus_2(x);					\
  } else {							\
    bblt_minus_no_check((x), (z));				\
  }								\
}while(0)

#define bblt_minus_no_check(x, z)				\
do{ (z) = (q) (2L*INT - (long)(x)); }while(0)

/*
  Floating Point
*/

extern q bblt_fix_2(q x);

#define bblt_fix(x, z)						\
do{								\
  extern struct data_object_method_table TableName(float);	\
  if (!isfunctor(x) || !isgobj(x) ||				\
      functor_of(x) != (q) &TableName(float)) {			\
    (z) = bblt_fix_2(x);					\
  } else {							\
    (z) = makeint((long) (float_value(x)));			\
  }								\
}while(0)


/*
  For Distributed KLIC System
*/

#define bblt_current_node_no_check(x, y) \
do{ \
  (x) = makeint(my_node); \
  (y) = makeint(total_node); \
}while(0)


#endif /* _KLIC_BB_H_ */
