/* ---------------------------------------------------------- 
%   (C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_TRACE_H_
#define _KLIC_TRACE_H_

/* Tracer Status Information */
struct trace_info_rec {
  FILE* in;
  FILE* out;
  q original_arg;
  int enabled, leashed, leaping, spying;
  int verbose;
  unsigned long print_depth, print_length;
};

/* Info on Enqueued Goals */
struct enqueue_trace_rec {
  struct enqueue_trace_rec* next;
  struct goalrec* g;
  long prio;
};


/* trace.c */

extern struct enqueue_trace_rec* trace_enqueued_goals;
extern int trace_flag;
extern int subterm_sp;

extern struct goalrec*
  trace_goal(struct goalrec* g, unsigned seq, struct trace_info_rec* info);

extern unsigned untrace_goal(struct goalrec* g);

extern struct goalrec* trace_after(struct goalrec* qp, q* allocp);
extern struct goalrec* trace_susp(struct goalrec* qp, q* reasonp, int spontaneous);
extern void trace_resumption(struct goalrec* qp);
extern void trace_failure(struct goalrec* qp);
extern void trace_deadlock(struct goalrec* qp);

extern void fprint_pred(FILE* fp, const struct predicate* pred);
extern void fprint_goal
  ( FILE* stream, struct goalrec* g, module mod,
    unsigned long depth, unsigned long length, int verbose );


#endif /* _KLIC_TRACE_H_ */
