/* ---------------------------------------------------------- 
%   (C)1993, 1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_TIMING_H_
#define _KLIC_TIMING_H_

#include <sys/types.h>

#define  field_diff(field)	(after.field - before.field)


#ifdef GETRUSAGE

#include <sys/time.h>
#include <sys/resource.h>

#define  diff_usec(field)\
(field_diff(field.tv_sec) * 1000000 + field_diff(field.tv_usec))

typedef struct rusage timerstruct;
#define	 measure(x)	getrusage(RUSAGE_SELF, &(x))


#else  /* not GETRUSAGE */

#include <sys/times.h>
#include <sys/param.h>

#define	 tick2msec(n)	((n)*1000.0/HZ)

typedef struct tms timerstruct;
#define	 measure(x)	times(&(x))

#endif  /* not GETRUSAGE */


Extern int gctimes Init(0);
Extern int gcums Init(0);
Extern int gcsms Init(0);
Extern int measure_gc Init(0);

#endif /* _KLIC_TIMING_H_ */
