/* ---------------------------------------------------------- 
%   (C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_SHM_H_
#define _KLIC_SHM_H_

/* Machine depending Dec */
#include "shm_machine.h"

#define currid (glbl->par.aux.shm.currid0)
#define oldid  (glbl->par.aux.shm.oldid0)

#define SHM_HEAP_TOP (glbl->par.aux.shm.shm_htop0)
#define SHP_SIZE     (glbl->par.aux.shm.shm_hbyte0)

  /* number of Planes */
extern long N_PLNE;
  /* size of 1 Shared-memory plane */
extern long SHM_SIZE;
extern long Disp_child;

Extern int shm_trace_lock Init(0);

#define MASTER 0

#define MAX_N_PE  32

  /* Shared-memory address or no */
#define is_shma(X) \
    ( (unsigned long)((long)(X)-(long)SHM_HEAP_TOP ) < SHP_SIZE )

/* calculates a hash key for lock */
#define HTBL_base 0
#define g_key()  HTBL_base  /* allocating shared-memory */
#define m_key()  (HTBL_base+1)  /* updating the shared-memory management table */
#define gc_key() (HTBL_base+2)  /* for Sequential GC */
#define a_key()  (HTBL_base+3)  /* updating atom table */
#define f_key()  (HTBL_base+4)  /* updating functor table */
#define tr_key() (HTBL_base+5)
#define p_key(penum) (HTBL_base+6 + (penum))  /* queuing a goal to external process */

  /* global generator hook */
#define is_genhook(X) ((long)(X) & 0x01)
#define tag_genhook(X) ((Sinfo*)((long)(X)+1))
#define untag_genhook(X) ((Sinfo*)((long)(X)-1))
  /* local consumer or generator */
#define tag_local(x)	((q)((char*)(x) + ATOMIC))
#define untag_local(x)	((q)((char*)(x) - ATOMIC))
#define ext_queued (glbl->par.aux.shm.queued0)
#define ex_qp (glbl->par.aux.shm.ex_qp0)

  /* adjusts the memory boundary */
#define reckon(sz) ((long)((((sz)+sizeof(long)-1)/sizeof(long))*sizeof(long)))
#define get_adjust_addr(type,top,inc) \
  (((type)*) (((char*) (top)) + (reckon(sizeof(type)) * (inc))))
#define get_otherPE_glbl(n) \
  get_adjust_addr(struct global_variables, top_shm_glbl, (n))

  /* shared memory alloc */
#define galloc(Siz) ( { q* addr = gallocp; \
  ((gallocp+=(Siz)) <= glimit)?addr:shm_galloc(Siz);})


#define free_local_tbl(ptr) \
do{ \
  TADDRtbl* sl = (TADDRtbl*) (ptr); \
  (sl->prev)->next = sl->next; \
  (sl->next)->prev = sl->prev; \
  sl->next = ADDRtbl_free; \
  ADDRtbl_free = sl; \
}while(0)


#define get_space(X) ( {\
    int cid = currid;\
    int cnt = 1;\
    int no = 0;\
    do { \
      if ( (unsigned long)((long)(X)-(long)(PLNE_ptr[cid]->top_addr)) < SHM_SIZE ) \
        { no = cnt; break; } \
      cnt++; \
    } while( (cid = PLNE_ptr[cid]->direct) != (-1) ); \
    no; } )

#define ck_new_galloc(X) \
do{ \
    int cid = currid;\
    while ( (cid = PLNE_ptr[cid]->direct) != (-1) ) { \
       if ( (unsigned long)((long)(X)-(long)(PLNE_ptr[cid]->top_addr) ) < SHM_SIZE ) { new_galloc(cid); break; }\
    }\
}while(0)


#define is_cur_or_forward_ptr(X) ( {\
    int ok = 0;\
    int cid = currid;\
    do {\
       if ( (unsigned long)((long)(X)-(long)(PLNE_ptr[cid]->top_addr) ) < SHM_SIZE ) {\
	 ok = 1; break;\
       }\
    } while ( (cid = PLNE_ptr[cid]->direct) != (-1) ) ;\
    ok; } )


  /* Structures */
typedef struct addr_tbl {
   struct addr_tbl* next;
   struct addr_tbl* prev;
   q* localA;
   q* globalA;
} TADDRtbl;

struct ex_goalrec {
   struct ex_goalrec* next;
   long prio;
   struct goalrec goal;
} ;

typedef struct PE_shook {
   struct PE_shook*   next;
   long               PE_num;
   long               prio;
   TADDRtbl*          indp;
} Sinfo;

typedef struct shvar {
   struct generator_object_method_table* method;
   Sinfo* chain;
} Shvar;

/* Management table of a shared memory plain */
typedef struct {
   long* top_addr;
   long* caddr;
   long  direct;
   long  demand;
   long  proc[MAX_N_PE];
   long* limit1;
   long* limit2;
   long* limit3;
} PLNE;

/* External declarations */

/* lock table address */
extern int* lockp[];

/* common variables */
extern int F_shm_gc;

extern volatile PLNE* PLNE_ptr[];

extern int* volatile pe_status;
extern int* volatile cur_status;

extern struct global_variables* top_shm_glbl;

extern struct ex_goalrec** volatile top_shm_qp;

/* runtime/shm_rsv.c */
extern char* shm_start_addr;
extern int ATOM_TABLE_SIZE;

/* memorized the last generated variable on shm */
extern q last_shm_var;

extern struct generator_object* qSHM_BUSY;
extern struct generator_object* pSHM_VAR;
extern struct generator_object_method_table* SHM_BUSY;
extern struct generator_object_method_table* SHM_VAR;

/* current shared memory top address, limit of myself */
extern q* gallocp;
extern q* glimit;

extern TADDRtbl ADDRtbl;
extern TADDRtbl* ADDRtbl_free;


/* Declarations of functions */

/* runtime/shm_rsv.c */

/* common routines */
extern struct global_variables* shm_init(struct global_variables* glbl);

/* allocate shared memory routines */
extern q* shm_galloc(int siz);


/* runtime/shm_throw.c */

/* copy argument into shared memory */
extern q shm_copy(q src);

/* stack a goal */
extern int shm_goal_stack(struct ex_goalrec* goal, int num);


/* runtime/shm_obj.c */

extern Shvar* create_genhook(q* la, q* ga);

extern Shvar* shm_add_consumer(
  q shv, Shvar* shobj, q cvar, struct global_variables* glbl );

extern q* shm_ck_request(q* allocp, Sinfo* chain);
extern q* shm_resume_goals(q* allocp, Sinfo* hook);

extern TADDRtbl* create_local_tbl(q* lcl, q* gbl);


/* runtime/newatom.c */
extern void init_shm_atom(void);

/* runtime/sched.c */
extern struct goalrec* get_invoked_goals(struct goalrec* qp);

/* runtime/shm_gc.c  GC routines */
extern int ck_shm_gc(void);
extern struct goalrec* shm_gc(struct goalrec* qp);

/* for GC */
extern q** shm_gcstack;
extern q** shm_gcmax;
extern q** shm_sp;
extern int shm_gcstack_size;

#endif /* _KLIC_SHM_H_ */
