/* ---------------------------------------------------------- 
%   (C) 1995 Institute for New Generation Computer Technology 
%	(Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
---------------------------------------------------------- */

#ifndef _KLIC_RMON_H_
#define _KLIC_RMON_H_

/************* For profiling ************************/

#define PROF_GATHER_INTERVAL_SEC 2
#define PROF_SAMPLE_INTERVAL_uSEC 10111

#define SHOEN_START_TAG       0
#define SHOEN_OUTPUT_PROF_TAG 100
#define SHOEN_TERMINATE_TAG   200

struct perfmon_state {
    int idle_on;
    int gc_on;
    int ms_on;
    int mr_on;
};

Extern volatile struct perfmon_state perfmon_state;

struct perfmon_counter {
    long intr_count;
    long idle_count;
    long gc_count;
    long ms_count;
    long mr_count;
};

Extern volatile struct perfmon_counter perfmon_counter;

Extern char* rmonnode;

struct profile_rec {
    long stimes;  /* sampling times */
    long itimes;  /* idle times */
    long gctimes; /* GC times */
    long mstimes; /* message sending times */
    long mrtimes; /* message receiving times */
};

Extern struct profile_rec* shoen_profile;

Extern long* send_pbuf;

#endif /* _KLIC_RMON_H_ */
