/* ---------------------------------------------------------- 
%   (C)1993,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#include <stdlib.h>  /* NULL, malloc, realloc */
#include <klic/basic.h>  /* fatalf */
#include <klic/struct.h>
#include <klic/primitives.h>  /* extern */

static q* heapp0;  /* top of free area (when decached) */
static q* new_space_top0;
static q* old_space_top0;
static unsigned long new_space_size0, old_space_size0;

static gc_t* gc_hook_table0;
static int gc_hooktab_size0;
static int num_gc_hooks0;
static gc_t* after_gc_hook_table0;
static int after_gc_hooktab_size0;
static int num_after_gc_hooks0;

extern q*
heapp(void)
{
  return heapp0;
}

extern void
set_heapp(q* p)
{
  heapp0 = p;
}

extern q* new_space_top(void){ return new_space_top0; }
extern q* old_space_top(void){ return old_space_top0; }
extern unsigned long new_space_size(void){ return new_space_size0; }
extern unsigned long old_space_size(void){ return old_space_size0; }
extern void set_new_space_top(q* p){ new_space_top0 = p; }
extern void set_old_space_top(q* p){ old_space_top0 = p; }
extern void set_new_space_size(unsigned long size){ new_space_size0 = size; }
extern void set_old_space_size(unsigned long size){ old_space_size0 = size; }

extern gc_t gc_hook_table(int k){ return gc_hook_table0[k]; }
extern gc_t after_gc_hook_table(int k){ return after_gc_hook_table0[k]; }
extern int num_gc_hooks(void){ return num_gc_hooks0; }
extern int num_after_gc_hooks(void){ return num_after_gc_hooks0; }

extern void*
malloc_check(size)
     unsigned long size;
{
  void* res = malloc(size);
  if (res == NULL) {
    fatalf("No more memory available from Unix\nMalloc failed for %d bytes",
	   size);
  }
  return res;
}

extern void*
realloc_check(original, newsize)
     void* original;
     unsigned long newsize;
{
  void* res = realloc(original, newsize);
  if (res == NULL) {
    fatalf("No more memory available from Unix\nRealloc failed for %d bytes",
	   newsize);
  }
  return res;
}

static void
reinit_alloc()
{
  declare_globals;
  heaplimit = real_heaplimit = new_space_top() + heapsize;
  heapbottom = real_heaplimit+incrementsize;
  set_heapp( heaptop = new_space_top() );
  real_heapbytesize = (unsigned long) heapbottom - (unsigned long) heaptop;
  this_more_space = 0;
  gc_hooktab_size0 = 32;
  num_gc_hooks0 = 0;
  gc_hook_table0 = (gc_t*) malloc_check(gc_hooktab_size0*sizeof(gc_t*));
  after_gc_hooktab_size0 = 32;
  num_after_gc_hooks0 = 0;
  after_gc_hook_table0 = (gc_t*) malloc_check(gc_hooktab_size0*sizeof(gc_t*));
}

extern void
initalloc()
{
  declare_globals;
  unsigned long bytesize;

  if(heapsize != 0  && incrementsize != 0) {
    bytesize = (heapsize + incrementsize)*sizeof(q);
  } else {
    fatalf("Invalid memory size specification: heap = %d, incremental = %d",
	    heapsize, incrementsize);
  }
  set_new_space_size(bytesize);
  set_old_space_size(bytesize);
  set_new_space_top((q*) malloc_check(bytesize));
  set_old_space_top((q*) malloc_check(bytesize));
  reinit_alloc();
}

extern void
register_gc_hook(gc_t routine)
{
  declare_globals;
  if (num_gc_hooks0 >= gc_hooktab_size0) {
    gc_hooktab_size0 *= 2;
    gc_hook_table0 = (gc_t*)
      realloc_check((void*) gc_hook_table0, gc_hooktab_size0*sizeof(gc_t*));
  }
  gc_hook_table0[num_gc_hooks0++] = routine;
}

extern void
register_after_gc_hook(gc_t routine)
{
  declare_globals;
  if (num_after_gc_hooks0 >= after_gc_hooktab_size0) {
    after_gc_hooktab_size0 *= 2;
    after_gc_hook_table0 = (gc_t*)
      realloc_check((void*) after_gc_hook_table0,
		    after_gc_hooktab_size0*sizeof(gc_t*));
  }
  after_gc_hook_table0[num_after_gc_hooks0++] = routine;
}
