/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_UNIFY_H_
#define _KLIC_UNIFY_H_

/* runtime/unify.c */
extern q* do_unify(q* allocp, q x, q y);
extern q* do_unify2(q* allocp, q x, q y, q z, q w);
extern q* do_unify3(q* allocp, q x, q y, q z, q w, q s, q t);
extern q* do_unify4(q* allocp, q x, q y, q z, q w, q s, q t, q u, q v);
extern q* do_unify_value(q* allocp, q x, q y);
extern q* do_unify_value2(q* allocp, q x, q y, q z, q w);
extern q* do_unify_value3(q* allocp, q x, q y, q z, q w, q s, q t);
extern q* do_unify_value4(q* allocp, q x, q y, q z, q w, q s, q t, q u, q v);

#define unify(x, y) \
do{ allocp = do_unify(allocp, (x), (y)); }while(0)

#define unify2(x, y, z, w) \
do{ allocp = do_unify2(allocp, (x), (y), (z), (w)); }while(0)

#define unify3(x, y, z, w, s, t) \
do{ allocp = do_unify3(allocp, (x), (y), (z), (w), (s), (t)); }while(0)

#define unify4(x, y, z, w, s, t, u, v) \
do{ allocp = do_unify4(allocp, (x), (y), (z), (w), (s), (t), (u), (v)); }while(0)

#define unify_value(x, y)\
do{								\
  if (!isref(x) || derefone(x) != (x)) {			\
    allocp = do_unify_value(allocp, (x), (y));			\
  } else {							\
    derefone(x) = (y);						\
  }								\
}while(0)
#define unify_value2(x, y, z, w)\
do{								\
  unify_value((x), (y));					\
  unify_value((z), (w));					\
}while(0)
#define unify_value3(x, y, z, w, s, t)\
do{								\
  unify_value((x), (y));					\
  unify_value((z), (w));					\
  unify_value((s), (t));					\
}while(0)
#define unify_value4(x, y, z, w, s, t, u, v)\
do{								\
  unify_value((x), (y));					\
  unify_value((z), (w));					\
  unify_value((s), (t));					\
  unify_value((u), (v));					\
}while(0)

#endif /* _KLIC_UNIFY_H_ */
