/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */
/*
  Signal handling
*/

#ifndef _KLIC_SIGHNDL_H_
#define _KLIC_SIGHNDL_H_

#ifdef USESIG
#include <signal.h>
#include <klic/struct.h>

#ifndef NSIG
#define NSIG 32
#endif

#define signal_flags		(klic_sgnl_flags->flags)
#define signal_handlers		(klic_sgnl_flags->sgnl_handlers)
#define signal_done		(klic_sgnl_flags->done)

struct klic_sgnl_flags {
  volatile long flags[NSIG];
  int ((* volatile sgnl_handlers[NSIG])());
  volatile long done;
} my_klic_sgnl_flags;

#ifdef SIGMAIN
volatile struct klic_sgnl_flags* klic_sgnl_flags = &my_klic_sgnl_flags;
#else
extern volatile struct klic_sgnl_flags* klic_sgnl_flags;
#endif

/* runtime/signal.c */
extern void klic_signal_handler(void);
extern void add_slit_check_handler(int sig, int (*func)());
extern int add_signal_handler(int sig, int (*func)());
extern void register_streamed_signal(int sig, q stream);
extern void init_klic_signal_handling(void);

#endif /* USESIG */

#endif /* _KLIC_SIGHNDL_H_ */
