/* ---------------------------------------------------------- 
%   (C)1993,1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_GENERIC_H_
#define _KLIC_GENERIC_H_

#include <klic/stdc.h>  /* CONCATENATE */
#include <klic/g_methtab.h>

/* runtime/generic.c */
extern q* gd_generic(
  q* g_allocp, q g_object, long g_method_functor, q* g_argv );

#define new_generic(name,argc,out,offset)  \
do{ \
  (out) = (name)((argc), generic_arg, allocp+offset); \
  allocp = heapp(); \
}while(0)

#define call_generic(obj,funct,offset) \
  (allocp = (q *) gd_generic(allocp+(offset),(obj),(funct),generic_arg))

#define guard_generic(object,mf,inargc,label) \
do{ \
  q *obj = (q *)functorp(object); \
  q retval = ((struct data_object_method_table *) \
                  (*obj))->g_generic( obj, (mf), generic_arg); \
\
  if( retval != GENERIC_SUCCEEDED ){ \
    if( retval == GENERIC_FAILED ) { goto label ; } \
    else{     *reasonp++ = retval;   goto label ; } \
  } \
}while(0)

#define isgobj(x)  (isref(functor_of(x)))

#define data_object_method_table_of(class) \
  CONCATENATE(class, _g_data_method_table)

#define isclass(x, class) \
  ((struct data_object_method_table *)(functor_of(x)) == \
   &data_object_method_table_of(class))

#define declare_method_table_of(class) \
  extern struct data_object_method_table data_object_method_table_of(class)

#endif /* _KLIC_GENERIC_H_ */
