/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_GB_H_
#define _KLIC_GB_H_

#include <klic/stdc.h>  /* CONCATENATE */
#include <klic/functorstuffs.h>  /* functoratom, arityof */
#include <klic/control.h>  /* check_stack_for_alternatively */

/* runtime/cmphsh.c */
extern q builtin_compare_terms(q x, q y);
extern q builtin_hash_term(q x, long l);


/** gblt_compare: procedure
 * x, y: q
 * r: q&
 * fail: LABEL
 */

#define gblt_compare(x, y, r, fail) \
do{ \
  (r) = builtin_compare_terms((x), (y)); \
  if (isref(r)) { \
    *reasonp++ = (r); \
    goto fail; \
  } \
}while(0)

#define gblt_hash(x, r, fail) \
  ((r) = builtin_hash_term((x), 0))


/** gblt_deep_hash: procedure
 * x: q
 * l: q  long hash value
 * r: q&
 * fail: LABEL
 */
#define gblt_deep_hash(x, l, r, fail) \
do{ \
  (r) = builtin_hash_term((x), intval(l)); \
  if (isref(r)) { \
    *reasonp++ = (r); \
    goto fail; \
  } \
}while(0)


#define gblt_current_prio(p, fail) \
  ((p) = makeint(current_prio))

#define gblt_wait( x, susp )

#define gblt_list( x, fail )

#define gblt_atom( x, fail )

#define gblt_integer( x, fail )

#define gblt_atomic( x, fail )

#define gblt_float( x, fail )

/* Multitude Comparison */

#define gblt_greater( x, y, fail ) \
do{ if ((long) (x) <= (long) (y)) goto fail; }while(0)

#define gblt_greater_or_eq( x, y, fail ) \
do{ if ((long) (x) < (long) (y)) goto fail; }while(0)

#define gblt_less( x, y, fail ) \
do{ if ((long) (x) >= (long) (y)) goto fail; }while(0)

#define gblt_less_or_eq( x, y, fail ) \
do{ if ((long) (x) > (long) (y)) goto fail; }while(0)

#define gblt_eq( x, y,  fail ) \
do{ if ((long) (x) != (long) (y)) goto fail; }while(0)

/* Arithmetical/Logical Operations on Integers */

#define gblt_and( x, y, z, fail ) \
do{ (z) = (q) ((unsigned long)(x) & (unsigned long)(y)); }while(0)

#define gblt_or( x, y, z, fail ) \
do{ (z) = (q) ((unsigned long)(x) | (unsigned long)(y)); }while(0)

#define gblt_exclusive_or( x, y, z, fail ) \
do{ (z) = (q) (((unsigned long)(x) ^ (unsigned long)(y)) + INT); }while(0)

#define gblt_rshift( x, y, z, fail ) \
do{ (z) =  makeint((unsigned long) (intval(x)) >> intval(y)); }while(0)

#define gblt_lshift( x, y, z, fail ) \
do{ (z) = (q) ((((long)(x) - INT) << intval(y)) + INT); }while(0)

#define gblt_add( x, y, z, fail ) \
do{ (z) = (q) ((unsigned long)(x) + ((unsigned long)(y) - INT)); }while(0)

#define gblt_subtract( x, y, z, fail ) \
do{ (z) = (q) ((unsigned long)(x) - ((unsigned long)(y) - INT)); }while(0)

#define gblt_multiply( x, y, z, fail ) \
do{ (z) = (q) (((long)(x) - INT) * (intval(y)) + INT); }while(0)

#define gblt_divide( x, y, z, fail ) \
do{ \
  long macrotemp = (long)(y) - INT; \
  if (macrotemp == 0) goto fail; \
  (z) = makeint(((long)(x) - INT) / macrotemp); \
}while(0)

#define gblt_modulo( x, y, z, fail ) \
do{ \
  long macrotemp = (long)(y) - INT; \
  if (macrotemp == 0) goto fail; \
  (z) = (q) (((long)(x) - INT) % macrotemp + INT); \
}while(0)

#define gblt_complement( x, z, fail ) \
do{ (z) = makeint((long)(x) ^ ((-1L) << ATAGBITS)); }while(0)

#define gblt_plus( x, z, fail ) \
do{ (z) = (x); }while(0)

#define gblt_minus( x, z, fail ) \
do{ (z) = (q) (2*INT - (long)(x)); }while(0)

#define gblt_fix( x, z, fail ) \
do{ (z) = makeint((long) float_value(x)); }while(0)

/* Functor Manipulation */

#define gblt_pfunctor( x, f, fail) \
do{ \
  if (isatomic(x)) { \
    (f) = (x); \
  } else if (iscons(x)) { \
    (f) = PERIODATOM; \
  } else if (!isref(functorp(x)->functor)) { \
    (f) = makesym(functoratom(functorp(x)->functor)); \
  } else  { \
    (f) = (x); \
  } \
}while(0)

#define gblt_arity( x, a, fail) \
do{ \
  if (isatomic(x)) { \
    (a) = makeint(0); \
  } else if (iscons(x)) { \
    (a) = makeint(2); \
  } else if (!isref(functorp(x)->functor)) { \
    (a) = makeint(arityof(functorp(x)->functor)); \
  } else { \
    (a) = makeint(0); \
  } \
}while(0)

#define gblt_arg( n, x, a, fail) \
do{ \
  long _n = intval(n); \
  if (isatomic(x)) { \
    goto fail; \
  } else if (iscons(x)) { \
    switch (_n) { \
    case 1:  (a) = car_of(x);  break; \
    case 2:  (a) = cdr_of(x);  break; \
    default:  goto fail; \
    } \
  } else if (!isref(functorp(x)->functor)) { \
    if (_n <= 0 || arityof(functorp(x)->functor) < _n) goto fail; \
    (a) = arg((x), _n-1); \
  } else { \
    goto fail; \
  } \
}while(0)

/* Generic Object Manipulation */

#define TableName(x)	CONCATENATE(x, _g_data_method_table)

#define jump_if_not_in_class(x, class, lab)				\
do{									\
  extern struct data_object_method_table TableName(class);		\
  if (!isgobj(x) || functor_of(x) != (q) &TableName(class))		\
    goto lab;								\
}while(0)

#define gblt_size_of_vector(v, s, faillab)				\
do{									\
  extern q size_of_vector();						\
  (s) = size_of_vector(v);						\
}while(0)

#define gblt_element_of_vector(v, k, e, faillab)			\
do{									\
  extern q element_of_vector();						\
  (e) = element_of_vector((v), (k));					\
  if ((long) (e) == 0) goto faillab;					\
}while(0)

#define gblt_is_string(s, faillab)					\
do{ jump_if_not_in_class((s), byte__string, faillab); }while(0)

#define gblt_size_of_string(v, s, faillab)				\
do{									\
  extern q size_of_string();						\
  (s) = size_of_string(v);						\
}while(0)

#define gblt_element_size_of_string(v, es, faillab)			\
do{ (es) = makeint(8); }while(0)

#define gblt_element_of_string(v, k, e, faillab)			\
do{									\
  extern q element_of_string();						\
  (e) = element_of_string((v), (k));					\
  if ((long) (e) == 0) goto faillab;					\
}while(0)

/* Guard General Unification */

/* runtime/unify2.c */
q eq_terms_body(q x, q y);

#define if_not_equal(x, y, faillab) \
do{ \
  if ((x)!=(y) || isref(x)) { \
    q retval = eq_terms_body((x), (y)); \
    switch((long) retval){ \
    case 0:  break; \
    default:  *reasonp++ = retval; /* fall thru */ \
    case 1:  goto faillab; \
    } \
  } \
}while(0)

/* Clause Grouping */

#define otherwise(lab) \
do{ if (reasonp != reasons) goto lab; }while(0)

#define alternative(lab) \
do{ \
  if (reasonp != reasons) { \
    int macrotmp; \
    set_heapp(allocp); \
    macrotmp = check_stack_for_alternatively(reasonp); \
    allocp = heapp(); \
    if (macrotmp != 0) goto lab; \
  } \
}while(0)

/* Misc */

#define gblt_assign( x, y, fail )  do{ (x) = (y); }while(0)

#define gblt_not_eq( x, y, fail ) \
do{ if ((long)(x) == (long)(y)) goto fail; }while(0)

#define gblt_diff( x, y, fail )	\
do{ \
  if ((isatomic(y) || isatomic(x) ? (x) == (y) : \
      (iscons(y) ? iscons(x) : \
        (isfunctor(x) && functor_of(x) == functor_of(y))))) \
          goto fail; \
}while(0)

#define gblt_display_console(w,fail)  printl(w)

#define gblt_tag(x, y, faillab)   ((y) = makeint(ptagof(x)))
#define gblt_value(x, y, faillab) \
  ((y) = makeint(((unsigned long) (x)) >> ATAGBITS))

#endif /* _KLIC_GB_H_ */
