/* ---------------------------------------------------------- 
%   (C)1993, 1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_BASIC_H_
#define _KLIC_BASIC_H_

#include <stdio.h>
#include <klic/stdc.h>  /* const, volatile */

#ifdef MAIN
#define Extern
#define Init(x)		= (x)
#else
#define Extern		extern
#define Init(x)
#endif

#ifdef __GNUC__
#define Inline		__inline__
#define NeverReturn	volatile
#else
#define Inline
#define NeverReturn
#endif

/* runtime/debug.c */
extern NeverReturn void fatal(char* message);
extern NeverReturn void fatalf();
extern NeverReturn void fatalp();
extern void debug_printf();
extern void debug_fprintf();
extern void klic_fprintf();

/*
  PARALLEL flag is DIST || SHM.
*/
#if defined(DIST) || defined(SHM)
#define PARALLEL
#endif


/* runtime/xio.c
  For handling I/O interrupts during I/O,
  we use our own version of getc &c
*/

extern int klic_getc(FILE* f);
extern int klic_fread(void* pt, size_t size, size_t items, FILE* f);

extern int klic_putc(int c, FILE* out);
extern int klic_fwrite(const void* pt, size_t size, size_t items, FILE* f);
extern int klic_fflush(FILE* f);


#endif /* _KLIC_BASIC_H_ */
