/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997, 1998, 1999 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */

#ifndef _KLIC_ALLOC_H_
#define _KLIC_ALLOC_H_

/* heapbottom, heaplimit, real_heaplimit, interrupt_off */
#include <klic/struct.h>


/** Reverse allocation from "heaptop"
 * heapalloc: procedure
 *   s: maketype&
 *   words > 0: offset_t
 *   maketype: type cast or function returning q
 */

#define heapalloc(s, words, maketype) \
do{ \
  heapbottom -= (words); \
  (s) = maketype(heapbottom); \
\
  real_heaplimit -= (words); \
  if(heaplimit != 0) \
    heaplimit = (interrupt_off ? real_heaplimit : 0); \
}while(0)


typedef void (*gc_t)(void);

/* runtime/intrpt.c */
extern void klic_interrupt(struct goalrec* qp);

/* runtime/alloc.c */
extern void* malloc_check(unsigned long size);
extern void* realloc_check(void* original, unsigned long newsize);
extern void initalloc(void);
extern void register_gc_hook(gc_t routine);
extern void register_after_gc_hook(gc_t routine);
extern gc_t gc_hook_table(int k);
extern gc_t after_gc_hook_table(int k);
extern int num_gc_hooks(void);
extern int num_after_gc_hooks(void);

#endif /* _KLIC_ALLOC_H_ */
