/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.lambdalabel;

import java.awt.Color;

public abstract class LambdaLabel {
    private int width;
    protected boolean parenRequired;

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public abstract boolean isAbstract();

    public abstract boolean isAtomic();

    public abstract <T> void accept(Visitor<T> var1, T var2);

    public abstract <T> T accept(VisitorR<T> var1);

    public abstract <TRet, TParam> TRet accept(VisitorRP<TRet, TParam> var1, TParam var2);

    public static LiteralLabel literal(String string) {
        return new LiteralLabel(string);
    }

    public static ApplyLabel apply(LambdaLabel lambdaLabel, LambdaLabel lambdaLabel2) {
        return new ApplyLabel(lambdaLabel, lambdaLabel2);
    }

    public static AbstractLabel abs(String string, LambdaLabel lambdaLabel) {
        return new AbstractLabel(string, lambdaLabel);
    }

    public static MacroLabel macro(String string) {
        return new MacroLabel(string);
    }

    public static RedexWrapper wrap(LambdaLabel lambdaLabel, Color color) {
        return new RedexWrapper(lambdaLabel, color);
    }

    public static class RedexWrapper
    extends LambdaLabel {
        public final LambdaLabel lambda;
        public final Color color;

        public RedexWrapper(LambdaLabel lambdaLabel, Color color) {
            this.lambda = lambdaLabel;
            this.color = color;
        }

        @Override
        public boolean isAbstract() {
            return this.lambda.isAbstract();
        }

        @Override
        public boolean isAtomic() {
            return this.lambda.isAtomic();
        }

        @Override
        public <T> void accept(Visitor<T> visitor, T t) {
            visitor.visit(this, t);
        }

        @Override
        public <T> T accept(VisitorR<T> visitorR) {
            return visitorR.visit(this);
        }

        @Override
        public <TRet, TParam> TRet accept(VisitorRP<TRet, TParam> visitorRP, TParam TParam) {
            return visitorRP.visit(this, TParam);
        }
    }

    public static class MacroLabel
    extends LambdaLabel {
        public final String name;

        public MacroLabel(String string) {
            this.name = string;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isAtomic() {
            return true;
        }

        @Override
        public <T> void accept(Visitor<T> visitor, T t) {
            visitor.visit(this, t);
        }

        @Override
        public <T> T accept(VisitorR<T> visitorR) {
            return visitorR.visit(this);
        }

        @Override
        public <TRet, TParam> TRet accept(VisitorRP<TRet, TParam> visitorRP, TParam TParam) {
            return visitorRP.visit(this, TParam);
        }
    }

    public static class AbstractLabel
    extends LambdaLabel {
        public final String name;
        public final LambdaLabel body;

        public AbstractLabel(String string, LambdaLabel lambdaLabel) {
            this.name = string;
            this.body = lambdaLabel;
        }

        @Override
        public boolean isAbstract() {
            return true;
        }

        @Override
        public boolean isAtomic() {
            return false;
        }

        @Override
        public <T> void accept(Visitor<T> visitor, T t) {
            visitor.visit(this, t);
        }

        @Override
        public <T> T accept(VisitorR<T> visitorR) {
            return visitorR.visit(this);
        }

        @Override
        public <TRet, TParam> TRet accept(VisitorRP<TRet, TParam> visitorRP, TParam TParam) {
            return visitorRP.visit(this, TParam);
        }
    }

    public static class ApplyLabel
    extends LambdaLabel {
        public final LambdaLabel lexpr;
        public final LambdaLabel rexpr;
        private boolean leftParen;
        private boolean rightParen;

        public ApplyLabel(LambdaLabel lambdaLabel, LambdaLabel lambdaLabel2) {
            this.lexpr = lambdaLabel;
            this.rexpr = lambdaLabel2;
        }

        public void setLeftParen(boolean bl) {
            this.leftParen = bl;
        }

        public void setRightParen(boolean bl) {
            this.rightParen = bl;
        }

        public boolean isLeftParen() {
            return this.leftParen;
        }

        public boolean isRightParen() {
            return this.rightParen;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isAtomic() {
            return false;
        }

        @Override
        public <T> void accept(Visitor<T> visitor, T t) {
            visitor.visit(this, t);
        }

        @Override
        public <T> T accept(VisitorR<T> visitorR) {
            return visitorR.visit(this);
        }

        @Override
        public <TRet, TParam> TRet accept(VisitorRP<TRet, TParam> visitorRP, TParam TParam) {
            return visitorRP.visit(this, TParam);
        }
    }

    public static class LiteralLabel
    extends LambdaLabel {
        public final String name;

        public LiteralLabel(String string) {
            this.name = string;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isAtomic() {
            return true;
        }

        @Override
        public <T> void accept(Visitor<T> visitor, T t) {
            visitor.visit(this, t);
        }

        @Override
        public <T> T accept(VisitorR<T> visitorR) {
            return visitorR.visit(this);
        }

        @Override
        public <TRet, TParam> TRet accept(VisitorRP<TRet, TParam> visitorRP, TParam TParam) {
            return visitorRP.visit(this, TParam);
        }
    }

    public static interface VisitorRP<TRet, TParam> {
        public TRet visit(LiteralLabel var1, TParam var2);

        public TRet visit(ApplyLabel var1, TParam var2);

        public TRet visit(AbstractLabel var1, TParam var2);

        public TRet visit(MacroLabel var1, TParam var2);

        public TRet visit(RedexWrapper var1, TParam var2);
    }

    public static interface VisitorR<T> {
        public T visit(LiteralLabel var1);

        public T visit(ApplyLabel var1);

        public T visit(AbstractLabel var1);

        public T visit(MacroLabel var1);

        public T visit(RedexWrapper var1);
    }

    public static interface Visitor<T> {
        public void visit(LiteralLabel var1, T var2);

        public void visit(ApplyLabel var1, T var2);

        public void visit(AbstractLabel var1, T var2);

        public void visit(MacroLabel var1, T var2);

        public void visit(RedexWrapper var1, T var2);
    }
}

