/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;

public class RenameVisitor
implements Lambda.Visitor<Lambda, Map<String, String>> {
    private Lambda lambda;
    private Set<String> bounded = new HashSet<String>();

    public RenameVisitor(Lambda lambda) {
        this.lambda = lambda;
    }

    public Lambda rename() {
        return this.lambda.accept(this, new HashMap());
    }

    @Override
    public Lambda visitAbstract(ASTAbstract aSTAbstract, Map<String, String> map) {
        ASTAbstract aSTAbstract2;
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        if (this.bounded.contains(aSTAbstract.originalName)) {
            aSTAbstract2 = aSTAbstract;
        } else {
            this.bounded.add(aSTAbstract.originalName);
            hashMap.put(aSTAbstract.name, aSTAbstract.originalName);
            aSTAbstract2 = new ASTAbstract(aSTAbstract.originalName, aSTAbstract.originalName, aSTAbstract.e);
        }
        Lambda lambda = aSTAbstract2.e.accept(this, hashMap);
        this.bounded.remove(aSTAbstract.originalName);
        return lambda == aSTAbstract2.e ? aSTAbstract2 : new ASTAbstract(aSTAbstract2.originalName, aSTAbstract2.name, lambda);
    }

    @Override
    public Lambda visitApply(ASTApply aSTApply, Map<String, String> map) {
        Lambda lambda = aSTApply.lexpr.accept(this, map);
        Lambda lambda2 = aSTApply.rexpr.accept(this, map);
        return lambda == aSTApply.lexpr && lambda2 == aSTApply.rexpr ? aSTApply : new ASTApply(lambda, lambda2);
    }

    @Override
    public Lambda visitLiteral(ASTLiteral aSTLiteral, Map<String, String> map) {
        if (map.containsKey(aSTLiteral.name)) {
            return new ASTLiteral(aSTLiteral.originalName, map.get(aSTLiteral.name));
        }
        return aSTLiteral;
    }

    @Override
    public Lambda visitMacro(ASTMacro aSTMacro, Map<String, String> map) {
        return aSTMacro;
    }
}

