/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.ArrayList;
import java.util.List;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import util.Unit;

public class RedexFinder {
    private static VisitorImpl visitor;

    public static List<IRedex> getRedexList(Lambda lambda) {
        if (visitor == null) {
            visitor = new VisitorImpl();
        }
        ArrayList<IRedex> arrayList = new ArrayList<IRedex>();
        lambda.accept(visitor, arrayList);
        return arrayList;
    }

    private static class VisitorImpl
    implements Lambda.Visitor<Unit, List<IRedex>> {
        private VisitorImpl() {
        }

        @Override
        public Unit visitAbstract(ASTAbstract aSTAbstract, List<IRedex> list) {
            aSTAbstract.e.accept(this, list);
            return Unit.VALUE;
        }

        @Override
        public Unit visitApply(ASTApply aSTApply, List<IRedex> list) {
            if (aSTApply.lexpr.isAbstraction()) {
                list.add(aSTApply);
            }
            aSTApply.lexpr.accept(this, list);
            aSTApply.rexpr.accept(this, list);
            return Unit.VALUE;
        }

        @Override
        public Unit visitLiteral(ASTLiteral aSTLiteral, List<IRedex> list) {
            return Unit.VALUE;
        }

        @Override
        public Unit visitMacro(ASTMacro aSTMacro, List<IRedex> list) {
            list.add(aSTMacro);
            return Unit.VALUE;
        }
    }
}

