/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.Environment;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IDContext;
import lambda.ast.IRedex;
import lambda.ast.LambdaPrinter;
import util.Pair;
import util.Unit;

public abstract class Lambda {
    public boolean isMacro() {
        return false;
    }

    public boolean isLiteral() {
        return false;
    }

    public boolean isApplication() {
        return false;
    }

    public boolean isAbstraction() {
        return false;
    }

    public boolean isAtomic() {
        return this.isMacro() || this.isLiteral();
    }

    public abstract int getPrec();

    public abstract Pair<Boolean, Lambda> betaReduction(IDContext var1, Environment var2);

    public abstract Pair<Boolean, Lambda> betaReduction(IDContext var1, Environment var2, IRedex var3);

    public Pair<Boolean, Lambda> etaReduction() {
        return Pair.of(false, this);
    }

    protected Lambda apply(IDContext iDContext, Lambda lambda) {
        return this;
    }

    protected abstract Lambda substitute(IDContext var1, String var2, Lambda var3);

    public abstract <T, U> T accept(Visitor<T, U> var1, U var2);

    public <T> T accept(SingleVisitor<T> singleVisitor) {
        return this.accept(singleVisitor, Unit.VALUE);
    }

    public String toString() {
        return LambdaPrinter.toString(this);
    }

    public static interface Visitor<T, U> {
        public T visitAbstract(ASTAbstract var1, U var2);

        public T visitApply(ASTApply var1, U var2);

        public T visitLiteral(ASTLiteral var1, U var2);

        public T visitMacro(ASTMacro var1, U var2);
    }

    public static abstract class SingleVisitor<T>
    implements Visitor<T, Unit> {
        @Override
        public final T visitAbstract(ASTAbstract aSTAbstract, Unit unit) {
            return this.visitAbstract(aSTAbstract);
        }

        @Override
        public final T visitApply(ASTApply aSTApply, Unit unit) {
            return this.visitApply(aSTApply);
        }

        @Override
        public final T visitLiteral(ASTLiteral aSTLiteral, Unit unit) {
            return this.visitLiteral(aSTLiteral);
        }

        @Override
        public final T visitMacro(ASTMacro aSTMacro, Unit unit) {
            return this.visitMacro(aSTMacro);
        }

        public abstract T visitAbstract(ASTAbstract var1);

        public abstract T visitApply(ASTApply var1);

        public abstract T visitLiteral(ASTLiteral var1);

        public abstract T visitMacro(ASTMacro var1);
    }
}

