/* << human finger >>
 * hfinger.c       ver. 1.01
 * 96/02/03
 * By Kenta Cho(cho@ueda.info.waseda.ac.jp)
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "hfinger.h"

#define MAXLINE 255
#define MAXHOST 4

typedef struct {
  char name[9];
  char idle[6];
  char host[MAXHOST][9];
  int hostnum;
  char console[21];
} User;

typedef struct {
  User *us;
  char name[9];
  int xco,yco;
  int x,y;
  int st,cou;
  int f;
  int bx,by;
} Scuser;

User us[MAXUSERMAX];
Scuser scus[MAXUSERMAX];
int maxuser=12;
int xmannum=-1;
char fingerstr[256]={FINGERCOMMAND};

XFontStruct *fo1,*fo2;
int f_height;
char fontname1[256]={FONTNAME1},fontname2[256]={FONTNAME2};

Display *disp;
Window win;
GC gc;

char windowtitle[256]={"hfinger"};
int xscsize,yscsize;
int xwinsize,ywinsize;
int xwinoffset,ywinoffset;

int screeninterval=SCREENINTERVAL,fingerinterval=FINGERINTERVAL;

int fsnapshot=SNAPSHOT;
int fanho=0;

char geom[256];

char dpy[256]={NULL};

int fplt=1,fpco=0,fpcopa=0;

int manpoint[][16][2]={
  {{0,-120},{-40,-100},{-40,-60},{0,-40},{40,-60},{40,-100},
  {0,40},{10,80},{0,120},{10,80},{0,120},{0,-20},{2,0},{4,40},{-2,0},{-4,40}},
  {{0,-120},{-40,-100},{-40,-60},{0,-40},{40,-60},{40,-100},
  {0,40},{30,60},{30,100},{0,80},{-30,120},{0,-20},{15,-5},{30,30},{-15,-5},{-30,30}},
  {{0,-120},{-40,-100},{-40,-60},{0,-40},{40,-60},{40,-100},
  {0,40},{10,80},{0,120},{10,80},{0,120},{0,-20},{-2,0},{-4,40},{2,0},{4,40}},
  {{0,-120},{-40,-100},{-40,-60},{0,-40},{40,-60},{40,-100},
  {0,40},{0,80},{-30,120},{30,60},{30,100},{0,-20},{-15,-5},{-30,30},{15,-5},{30,30}},

  {{0,-120},{-40,-100},{-40,-60},{0,-40},{40,-60},{40,-100},
  {0,40},{20,60},{20,100},{-20,90},{-20,140},{0,-20},{10,10},{20,40},{-10,-10},{-20,0}},
     
  {{0,-120},{-40,-100},{-40,-60},{0,-40},{40,-60},{40,-100},
  {0,40},{20,80},{20,120},{-20,80},{-20,120},{0,-20},{10,0},{20,20},{-10,0},{-20,20}},
  {{0,-120},{-40,-100},{-40,-60},{0,-40},{40,-60},{40,-100},
  {0,40},{20,90},{20,140},{-20,60},{-20,100},{0,-20},{10,-10},{20,0},{-10,10},{-20,40}},
  {{0,-120},{-40,-100},{-40,-60},{0,-40},{40,-60},{40,-100},
  {0,40},{20,80},{20,120},{-20,80},{-20,120},{0,-20},{10,0},{20,20},{-10,0},{-20,20}},

  {{0,-120},{-40,-100},{-40,-60},{0,-40},{40,-60},{40,-100},
  {0,40},{30,20},{30,100},{-30,30},{-30,100},{0,-20},{30,-30},{30,-40},{-30,-30},{-30,-40}},
  {{0,-120},{-40,-100},{-40,-60},{0,-40},{40,-60},{40,-100},
  {0,40},{30,20},{30,100},{-30,30},{-30,100},{0,-20},{30,-40},{30,-80},{-30,-30},{-30,-40}},
  {{0,-120},{-40,-100},{-40,-60},{0,-40},{40,-60},{40,-100},
  {0,40},{30,20},{30,100},{-30,30},{-30,100},{0,-20},{30,-30},{30,-40},{-30,-30},{-30,-40}},
  {{0,-120},{-40,-100},{-40,-60},{0,-40},{40,-60},{40,-100},
  {0,40},{30,20},{30,100},{-30,30},{-30,100},{0,-20},{30,-30},{30,-40},{-30,-40},{-30,-90}},

  {{0,-110},{-40,-90},{-40,-60},{0,-40},{40,-60},{40,-90},
  {0,40},{30,20},{30,100},{-30,30},{-30,100},{0,-20},{30,-50},{10,-100},{-30,-30},{-30,-40}},
  {{0,-110},{-40,-90},{-40,-60},{0,-40},{40,-60},{40,-90},
  {0,40},{30,20},{30,100},{-30,30},{-30,100},{0,-20},{30,-40},{10,-60},{-30,-30},{-30,-40}},
  {{0,-110},{-40,-90},{-40,-60},{0,-40},{40,-60},{40,-90},
  {0,40},{30,20},{30,100},{-30,30},{-30,100},{0,-20},{30,-40},{10,-60},{-30,-30},{-30,-40}},
  {{0,-110},{-40,-90},{-40,-60},{0,-40},{40,-60},{40,-90},
  {0,40},{30,20},{30,100},{-30,30},{-30,100},{0,-20},{30,-50},{10,-100},{-30,-30},{-30,-40}},

  {{0,-90},{-40,-80},{-40,-60},{0,-40},{40,-60},{40,-80},
  {0,40},{30,20},{30,100},{-30,30},{-30,100},{0,-20},{40,-40},{10,-60},{-40,-40},{-10,-60}},
  {{0,-90},{-40,-80},{-40,-60},{0,-40},{40,-60},{40,-80},
  {0,40},{30,20},{30,100},{-30,30},{-30,100},{0,-20},{40,-40},{10,-60},{-40,-40},{-10,-60}},
  {{0,-90},{-40,-80},{-40,-60},{0,-40},{40,-60},{40,-80},
  {0,40},{30,20},{30,100},{-30,30},{-30,100},{0,-20},{40,-40},{10,-60},{-40,-40},{-10,-60}},
  {{0,-90},{-40,-80},{-40,-60},{0,-40},{40,-60},{40,-80},
  {0,40},{30,20},{30,100},{-30,30},{-30,100},{0,-20},{40,-40},{10,-60},{-40,-40},{-10,-60}},
};  

/*
 * initializing
 */
initall()
{
  int r,i,c=0;
  int ymannum;
  for ( r=0 ; r<maxuser ; r++ ) {
    scus[r].st=-1;
    scus[r].bx=-10000;
  }
  ymannum=(int)((maxuser-1)/xmannum)+1;
  xscsize=256+256*xmannum;
  yscsize=(520+WALKWIDTH)*ymannum;
  xwinsize=xscsize*SCREENSIZE;
  ywinsize=yscsize*SCREENSIZE;
  for ( r=0 ; r<ymannum ; r++ )
    for ( i=0 ; i<xmannum ; i++ ) {
      scus[c].xco=(xmannum-i)*256-128;
      scus[c].yco=r*(520+WALKWIDTH);
      c++;
    }
}

/*
 * display usage
 */
usage()
{
  fprintf(stderr,"Usage:  hfinger [-options ...] [@name]\n");
  fprintf(stderr,"\n");
  fprintf(stderr,"where options include:\n");
  fprintf(stderr,"    -display dpy            X server on which to display\n");
  fprintf(stderr,"    -geometry geom          size and location of window\n");
  fprintf(stderr,"    -fn1 font               font to use in console name\n");
  fprintf(stderr,"    -fn2 font               font to use in user name\n");
  fprintf(stderr,"    -si 0.1seconds          interval between screen updates\n");
  fprintf(stderr,"    -fi 0.1seconds          interval between finger updates\n");
  fprintf(stderr,"    -mn number              maximum number of users\n");
  fprintf(stderr,"    -xn number              number of horizontal console\n");
  fprintf(stderr,"    -an                     show animation\n");
  fprintf(stderr,"    -sn                     show snapshot\n");
}

/*
 * parse options
 */
parseoptions(int argc,char **argv)
{
  int r;
  for ( r=1 ; r<argc ; r++ ) {
    if ( argv[r][0]=='@' ) {
      strcat(fingerstr," ");
      strcat(fingerstr,argv[r]);
      fanho=1;
      strcpy(windowtitle,argv[r]);
    }
    else if ( strcmp(argv[r],"-si")==0 && r<argc-1 ) {
      screeninterval=atoi(argv[r+1]); r++;
      fsnapshot=0;
    }
    else if ( strcmp(argv[r],"-fi")==0 && r<argc-1 ) {
      fingerinterval=atoi(argv[r+1]); r++;
      fsnapshot=0;
    }
    else if ( (strcmp(argv[r],"-mn")==0 || strcmp(argv[r],"-mu")==0) && r<argc-1 ) {
      maxuser=atoi(argv[r+1]); r++;
    }
    else if ( (strcmp(argv[r],"-xn")==0 || strcmp(argv[r],"-xu")==0) && r<argc-1 ) {
      xmannum=atoi(argv[r+1]); r++;
    }
    else if ( strcmp(argv[r],"-an")==0 ) fsnapshot=0;
    else if ( strcmp(argv[r],"-sn")==0 ) fsnapshot=1;
    else if ( strcmp(argv[r],"-fn1")==0 && r<argc-1 ) {
      strcpy(fontname1,argv[r+1]); r++;
    }
    else if ( strcmp(argv[r],"-fn2")==0 && r<argc-1 ) {
      strcpy(fontname2,argv[r+1]); r++;
    }
    else if ( (strcmp(argv[r],"-display")==0 || strcmp(argv[r],"-d")==0) && r<argc-1 ) {
      strcpy(dpy,argv[r+1]); r++;
    }
    else if ( (strcmp(argv[r],"-geometry")==0 || strcmp(argv[r],"-g")==0) && r<argc-1 ) {
      strcpy(geom,argv[r+1]);
      r++;
    }
    else {
      usage(); exit(1);
    }
  }
  if ( maxuser>MAXUSERMAX ) maxuser=MAXUSERMAX;
  if ( xmannum<0 || xmannum>maxuser ) xmannum=maxuser;
}

/*
 * open window
 */
openwindow(char *title)
{
  XSizeHints xsh;
  int f;

  if ( NULL==(disp=XOpenDisplay(dpy)) ) {
    fprintf(stderr,"Error: I cannot open display: %s\n",dpy);
    exit(0);
  }

  if ( NULL==(fo1=XLoadQueryFont(disp,fontname1)) ) {
    fprintf(stderr,"Error: I cannot convert string \"%s\" to type FontStruct\n",fontname1);
    exit(0);
  }
  if ( NULL==(fo2=XLoadQueryFont(disp,fontname2)) ) {
    fprintf(stderr,"Error: I cannot convert string \"%s\" to type FontStruct\n",fontname2);
    exit(0);
  }

  f=XWMGeometry(disp,DefaultScreen(disp),geom,NULL,1,&xsh,&(xsh.x),&(xsh.y),&(xsh.width),&(xsh.height),&(xsh.win_gravity));
  xsh.flags=0;
  if ( (f&(XValue | YValue))!=0 ) {
    xsh.flags|=USPosition;
    xwinoffset=xsh.x; ywinoffset=xsh.y;
  }
  if ( (f&(WidthValue | HeightValue))!=0 ) {
    xsh.flags|=USSize;
    xwinsize=xsh.width; ywinsize=xsh.height;
  }

  win=XCreateSimpleWindow(disp,RootWindow(disp,0),xwinoffset,ywinoffset,xwinsize,ywinsize,1,WhitePixel(disp,0),BlackPixel(disp,0));
  XStoreName(disp,win,title);
  XSetWMNormalHints(disp,win,&xsh);
  XMapWindow(disp,win);
  XSelectInput(disp,win,StructureNotifyMask | ExposureMask | ButtonPressMask);
  gc=XCreateGC(disp,win,0,NULL);
  XSetForeground(disp,gc,WhitePixel(disp,0));

  f_height=fo2->max_bounds.ascent+fo2->max_bounds.descent;
  XSetFont(disp,gc,fo2->fid); 
}

/*
 * draw line
 */
setline(int x1,int y1,int x2,int y2)
{
  int sx1,sy1,sx2,sy2;
  sx1=x1*xwinsize/xscsize;
  sx2=x2*xwinsize/xscsize;
  sy1=y1*ywinsize/yscsize;
  sy2=y2*ywinsize/yscsize;
  XDrawLine(disp,win,gc,sx1,sy1,sx2,sy2);
}

/*
 * clear area
 */
cleararea(int x1,int y1,int wid,int hei)
{
  int sx1,sy1,swid,shei;
  sx1=x1*xwinsize/xscsize;
  swid=wid*xwinsize/xscsize;
  sy1=y1*ywinsize/yscsize;
  shei=hei*ywinsize/yscsize;
  XClearArea(disp,win,sx1,sy1,swid,shei,0);
}

cleararea2(int x1,int y1,int wid,int hei)
{
  int sx1,sy1,swid,shei;
  sx1=x1*xwinsize/xscsize;
  sy1=y1*ywinsize/yscsize;
  XClearArea(disp,win,sx1,sy1-hei,wid,hei+(hei>>1),0);
}

/*
 * draw string
 */
drawstring(int x,int y,char *str)
{
  int sx,sy;
  sx=x*xwinsize/xscsize;
  sy=y*ywinsize/yscsize;
  XDrawString(disp,win,gc,sx,sy,str,strlen(str));
}

/*
 * display human
 */
putman(int x,int y,int st,int cou,int f,char *name)
{
  int r,c1,c2,co,s;
  int tx[16],ty[16];
  if ( cou<256 ) {
    co=cou&63;
    c1=(cou>>6);
  }
  else {
    if ( !fplt ) return;
    co=0; 
    c1=0;
  }
  c2=(c1+1)&3;
  s=(st<<2);
  for ( r=0 ; r<16 ; r++ ) {
    if ( r>6 ) {
      tx[r]=((manpoint[s+c1][r][0]*(64-co)+manpoint[s+c2][r][0]*co)>>6);
      ty[r]=((manpoint[s+c1][r][1]*(64-co)+manpoint[s+c2][r][1]*co)>>6);
    }
    else {
      tx[r]=manpoint[s][r][0];
      ty[r]=manpoint[s][r][1];
    }
    tx[r]*=f;
    tx[r]+=x; ty[r]+=y;
  }
  setline(tx[0],ty[0],tx[1],ty[1]);
  setline(tx[1],ty[1],tx[2],ty[2]);
  setline(tx[2],ty[2],tx[3],ty[3]);
  setline(tx[3],ty[3],tx[4],ty[4]);
  setline(tx[4],ty[4],tx[5],ty[5]);
  setline(tx[5],ty[5],tx[0],ty[0]);
  setline(tx[3],ty[3],tx[6],ty[6]);
  setline(tx[6],ty[6],tx[7],ty[7]);
  setline(tx[7],ty[7],tx[8],ty[8]);
  setline(tx[6],ty[6],tx[9],ty[9]);
  setline(tx[9],ty[9],tx[10],ty[10]);
  setline(tx[11],ty[11],tx[12],ty[12]);
  setline(tx[12],ty[12],tx[13],ty[13]);
  setline(tx[11],ty[11],tx[14],ty[14]);
  setline(tx[14],ty[14],tx[15],ty[15]);
  if ( fplt ) drawstring(x-100,y+100,name);
}

/*
 * display terminal
 */
putconsole()
{
  int r,i;
  int x,y;
  char coname[11];
  XClearWindow(disp,win);
  XSetFont(disp,gc,fo1->fid); 
  for ( r=0 ; r<maxuser ; r++ ) scus[r].bx=-10000;
  for ( r=0 ; r<maxuser ; r++ ) {
    if ( scus[r].st>=4 && scus[r].st<=6 ) {
      x=scus[r].xco; y=scus[r].yco;
      y+=192;
      setline(x+32,y+190,x+224,y+190);
      setline(x+224,y+190,x+192,y+128);
      setline(x+192,y+128,x+64,y+128);
      setline(x+64,y+128,x+32,y+190);
      setline(x+64,y+112,x+192,y+112);
      setline(x+192,y+112,x+192,y+40);
      setline(x+192,y+40,x+64,y+40);
      setline(x+64,y+40,x+64,y+112);
      strncpy(coname,scus[r].us->console,8);
      coname[8]='\0';
      drawstring(x,y+70,coname);
      for ( i=0 ; i<scus[r].us->hostnum ; i++ ) {
	setline(x+60,y+28,x+190,y+28);
	setline(x+190,y+28,x+190,y);
	setline(x+190,y,x+60,y);
	setline(x+60,y,x+60,y+28);
	drawstring(x,y+28,scus[r].us->host[i]);
	y-=48;
      }
    }
  }
  XSetFont(disp,gc,fo2->fid); 
  fplt=1; fpco=0;
}

putconsolepart()
{
  int r,i;
  int x,y;
  char coname[11];
  for ( r=0 ; r<maxuser ; r++ ) {
    if ( scus[r].st>=4 && scus[r].st<=6 ) {
      x=scus[r].xco; y=scus[r].yco;
      y+=192;
      setline(x+32,y+190,x+224,y+190);
      setline(x+224,y+190,x+192,y+128);
      setline(x+192,y+128,x+64,y+128);
      setline(x+64,y+128,x+32,y+190);
      setline(x+64,y+112,x+192,y+112);
      setline(x+192,y+112,x+192,y+40);
      setline(x+192,y+40,x+64,y+40);
      setline(x+64,y+40,x+64,y+112);
    }
  }
  fplt=1; fpcopa=0;
}

/*
 * display all human
 */
putscuser()
{
  int r;
  int mv=screeninterval*16;

  if ( fpcopa ) putconsolepart();
  if ( fpco ) putconsole();
  else {
    for ( r=0 ; r<maxuser ; r++ ) {
      if ( scus[r].st>=0 ) {
        if ( scus[r].bx!=-10000 ) {
          if ( scus[r].st<4 || scus[r].st>6 ) {
            cleararea(scus[r].bx-40,scus[r].by-120,100,265);
            cleararea2(scus[r].bx-100,scus[r].by+100,XTextWidth(fo2,scus[r].name,strlen(scus[r].name)),f_height);
            fplt=1;
          }
          else if ( ((scus[r].cou+mv)&511)<256 )
            cleararea(scus[r].bx-40,scus[r].by-120,85,160);
        }
      }
    }
  }
  for ( r=0 ; r<maxuser ; r++ ) {
    scus[r].bx=scus[r].x; scus[r].by=scus[r].y;
  }

  for ( r=0 ; r<maxuser ; r++ ) {
    scus[r].cou+=mv;
    switch (scus[r].st) {
    case 0:
      scus[r].cou&=255;
      if ( scus[r].x<(xscsize>>1) ) {
	putman(scus[r].x,scus[r].y,0,scus[r].cou,-1,scus[r].name);
	scus[r].x-=mv;
	if ( scus[r].x<-256 ) scus[r].st=-1;
      }
      else {
	putman(scus[r].x,scus[r].y,0,scus[r].cou,1,scus[r].name);
	scus[r].x+=mv;
	if ( scus[r].x>xscsize+256 ) scus[r].st=-1;
      }
      fpcopa=1;
      break;
    case 1:
      scus[r].cou&=255;
      putman(scus[r].x,scus[r].y,1,scus[r].cou,1,scus[r].name);
      scus[r].y+=mv;
      if ( scus[r].y>scus[r].yco+384+WALKWIDTH ) {
	scus[r].y=scus[r].yco+384+WALKWIDTH; scus[r].st=0;
	fpco=1;
      }
      fpcopa=1;
      break;
    case 2:
      scus[r].cou&=255;
      if ( scus[r].x<(xscsize>>1) ) {
	putman(scus[r].x,scus[r].y,0,scus[r].cou,1,scus[r].name);
	scus[r].x+=mv;
	if ( scus[r].x>scus[r].xco+128 ) {
	  scus[r].x=scus[r].xco+128; scus[r].st=3;
	}
      }
      else {
	putman(scus[r].x,scus[r].y,0,scus[r].cou,-1,scus[r].name);
	scus[r].x-=mv;
	if ( scus[r].x<scus[r].xco+128 ) {
	  scus[r].x=scus[r].xco+128; scus[r].st=3;
	}
      }
      fpcopa=1;
      break;
    case 3:
      scus[r].cou&=255;
      putman(scus[r].x,scus[r].y,1,scus[r].cou,1,scus[r].name);
      scus[r].y-=mv;
      if ( scus[r].y<scus[r].yco+384 ) {
	scus[r].y=scus[r].yco+384; scus[r].st=idle2st(scus[r].us->idle);
	scus[r].cou=random()&511;
	fpco=1;
      }
      fpcopa=1;
      break;
    case 4:
    case 5:
    case 6:
      scus[r].cou&=511;
      putman(scus[r].x,scus[r].y,scus[r].st-2,scus[r].cou,1,scus[r].name);
      break;
    }
  }
  fplt=0;
}

/*
 * check finger
 */
checkfingerver()
{
  FILE *fp;
  char line[MAXLINE];
  if ( (fp=popen(fingerstr,"r"))==NULL ) {
    fprintf(stderr,"Error: I cannot use 'finger' command\n");
    exit(0);
  }
  if ( fanho ) fgets(line,MAXLINE,fp);
  fgets(line,MAXLINE,fp);
  if ( strcmp(line,"  User     Real Name         What    Idle  TTY  Host      Console Location\n")!=0 ) {
    fprintf(stderr,"Warning: I cannot recogonize this 'finger' format\n");
  }
  pclose(fp);
}

/*
 * get idle time
 */
int str2time(char *str)
{
  char t[2],t2[2];
  if ( str[2]>='a' && str[2]<='z' ) return(1440);
  if ( str[2]==':' ) {
    t[0]=str[0]; t[1]=str[1]; t[2]='\0';
    t2[0]=str[3]; t2[1]=str[4]; t2[2]='\0';
    return(atoi(t)*60+atoi(t2));
  }
  else return(0);
}

/*
 * get finger data
 */
int getuserdata(User us[])
{
  FILE *fp;
  char line[MAXLINE];
  char user[9],idle[6],host[9],console[21];
  char th[256],tc[256];
  int r;
  int usernum=0;
  if ( (fp=popen(fingerstr,"r"))==NULL ) {
/*    fprintf(stderr,"Warning: I cannot use 'finger' command now\n");*/
    fclose(fp);
    return(-1);
  }
  if ( fanho ) fgets(line,MAXLINE,fp);
  fgets(line,MAXLINE,fp);
  if ( strcmp(line,"  User     Real Name         What    Idle  TTY  Host      Console Location\n")!=0 ) {
    fclose(fp);
    return(-1);
  }
  usernum=0;
  while (!feof(fp)) {
    fgets(line,MAXLINE,fp);
    strncpy(user,&line[0],8);
    user[8]='\0';
    if ( strcmp(user,"No one l")==0 ) {
      fclose(fp);
      return(0);
    }
    strncpy(idle,&line[36],5);
    idle[5]='\0';
    sscanf(&line[47],"%s %s",th,tc);
    strncpy(host,th,8);
    host[8]='\0';
    strncpy(console,tc,20);
    console[20]='\0';
    for ( r=0 ; r<usernum ; r++ ) {
      if ( strcmp(us[r].name,user)==0 ) {
	if ( str2time(idle)<str2time(us[r].idle) )
	  strcpy(us[r].idle,idle);
	if ( us[r].hostnum<MAXHOST ) {
	  strcpy(us[r].host[us[r].hostnum],host);
	  if ( strlen(console)>strlen(us[r].console) )
	    strcpy(us[r].console,console);
	  us[r].hostnum++;
	}
	break;
      }
    }
    if ( r==usernum ) {
      strcpy(us[usernum].name,user);
      strcpy(us[usernum].idle,idle);
      strcpy(us[usernum].host[0],host);
      us[usernum].hostnum=1;
      strcpy(us[usernum].console,console);
      usernum++;
    }
  }
  pclose(fp);
  return(usernum);
}

/*
 * get human's status
 */
int idle2st(char *idle)
{
  int t;
  t=str2time(idle);
  if ( t>=SLEEPTIME ) return(6);
  else if ( t>0 ) return(5);
  else return(4);
}

/*
 * update user's data
 */
updatescuser(User us[],int usernum)
{
  int r,i,an=-1,t;
  int amn=0;
  for ( r=0 ; r<maxuser ; r++ ) {
    if ( scus[r].st>=0 ) scus[r].f=0;
    else an=r;
  }
  for ( r=0 ; r<usernum ; r++ ) {
    for ( i=0 ; i<maxuser ; i++ ) {
      if ( scus[i].st>1 && strcmp(scus[i].name,us[r].name)==0 ) {
	scus[i].us=&us[r];
	scus[i].f=1;
	if ( scus[i].st>3 ) {
	  t=idle2st(scus[i].us->idle);
	  if ( scus[i].st!=t ) {
	    scus[i].st=t; scus[i].cou=0;
	  }
	}
	break;
      }
    }
    if ( i==maxuser && an!=-1 ) {
      scus[an].us=&us[r];
      strcpy(scus[an].name,us[r].name);
      if ( fsnapshot ) {
	scus[an].st=idle2st(scus[an].us->idle);
	scus[an].x=scus[an].xco+128;
	scus[an].y=scus[an].yco+384;
      }
      else {
	scus[an].st=2;
	if ( scus[an].xco<(xscsize>>1) ) scus[an].x=-amn*240;
	else scus[an].x=xscsize+amn*240;
	scus[an].y=scus[an].yco+384+WALKWIDTH;
	amn++;
      }
      scus[an].cou=0;

      scus[an].f=1;
      do {
	an--;
      } while ( scus[an].st>=0 && an>=0 );
    }
  }
  for ( r=0 ; r<maxuser ; r++ ) {
    if ( scus[r].st>1 && scus[r].f==0 ) {
      scus[r].st=1;
      scus[r].cou=0;
      fpco=1;
    }
  }
}

/*
 * main routine
 */
main(int argc,char **argv)
{
  int usn;
  int r;
  int time;
  XEvent ev;

  parseoptions(argc,argv);
  initall();
  openwindow(windowtitle);
  checkfingerver();

  if ( fsnapshot ) {
    usn=getuserdata(us);
    if ( usn!=-1 ) updatescuser(us,usn);
    while (1) {
      XNextEvent(disp,&ev);
      if ( ev.type==ConfigureNotify ) {
	xwinsize=ev.xconfigure.width;
	ywinsize=ev.xconfigure.height;
	putconsole();
      }
      else if ( ev.type==Expose ) putconsole();
      putscuser();
      XFlush(disp);
    }
  }
  else {
    while (1) {
      time=0;
      usn=getuserdata(us);
      updatescuser(us,usn);
      putconsole();
      while (1) {
	while ( XEventsQueued(disp,QueuedAfterFlush)>0 ) {
	  XNextEvent(disp,&ev);
	  if ( ev.type==ConfigureNotify ) {
	    xwinsize=ev.xconfigure.width;
	    ywinsize=ev.xconfigure.height;
	    putconsole();
	  }
	  else if ( ev.type==Expose ) putconsole();
	  else if ( ev.type==ButtonPress ) 
	    if ( ev.xbutton.button==Button3 ) exit(1);
	}
	putscuser();
	XFlush(disp);
	usleep(100000*screeninterval);
	time+=screeninterval;
	if ( time>=fingerinterval ) break;
      }
    }
  }
}
