// -*- C++ -*-
// Copyright (C) 1996,1997 Buntarou Shizuki(shizuki@is.titech.ac.jp)

#ifndef _tracer_types_h
#define _tracer_types_h

#include "debug.h"

#include <stdio.h>
#include <string.h>
#include <strstream.h>
#include <SLList.h>
#include <DLList.h>

extern "C" void bzero(void *, int);

void init_symbol();
char *get_symbol(char *name);

class PointSize {
public:
  int			left, top, width, height;

  void			SetPoint(int L, int T) { left = L; top = T; }
  void			SetSize(int W, int H) { width = W; height = H; }

  void			SetLeft(int L) { left = L; }
  void			SetTop(int T) { top = T; }
  void			SetWidth(int W) { width = W; }
  void			SetHeight(int H) { height = H; }

  int			GetLeft() { return left; }
  int			GetTop() { return top; }
  int			GetWidth() { return width; }
  int			GetHeight() { return height; }

  int			GetRight() { return left+width; }
  int			GetBottom() { return top+height; }
};

enum RuleType {
  rule_network,
  rule_vanishing,
  rule_continuous,
  rule_unknown
};

enum PortType {
  port_single_in,
  port_single_out,
  port_stream_in,
  port_stream_out,
  port_null
};

enum ActType {
  act_call,
  act_redu,
  act_susp,
  act_psus,
  act_fail,
  act_null
};

enum ExpandMethod {
  expand_default,
  expand_rightward,
  expand_downward,
  expand_null
};

//
//
//

/*
   runtime objects

   functor		{name, arity, args...}
   structure		{var, arity, args...}
   list(cons)		{car, cdr}
   vector		{size, terms...}
   string		{value}
   number(integer, real){value}
*/

enum TermType {
  tt_variable,
  tt_functor,
  tt_structure,
  tt_cons,
  tt_nil,
  tt_vector,
  tt_string,
  tt_integer,
  tt_real,
  tt_unknown
};

extern ostrstream buf;

//class rterm;
//extern rterm *rterm_list;
class rterm {
  rterm			*next;

 public:
  TermType		tt;

//			rterm() { next = rterm_list;
//				  rterm_list = this;
//				}

  int			isatom();
  int			isunbound();
  TermType		Type() { return tt; }
  char			*Get() { buf.seekp(0);
				 Unparse();
				 buf << '\0';
				 return buf.str(); }
  virtual int		isconcrete() = 0;
  virtual void		Unparse() = 0;
  virtual void		Print() = 0;
};

class term_variable : public rterm {
  char			*name;
  rterm			*content;
  
 public:
			term_variable() { tt = tt_variable;
					  name = NULL; }
			term_variable(char *n) { tt = tt_variable;
						 name = strdup(n);
						 content = NULL;
						 if (debug_variable)
						   printf("New Variable(%s)\n", name);
					       }
			~term_variable() {}

  char			*GetName() { return name; }
  int			Bound() { return (int) content; }
  rterm			*GetContent() { return content; }
  void			SetContent(rterm *t) { content = t;
					       if (debug_variable)
						 printf("bound %s\n", name);
					     }
  rterm			*GetValue();
  int			SetValue(rterm *t);

  int			isconcrete();
  void			Unparse();
  void			Print();
};

class term_functor : public rterm {
  char			*module;
  char			*name;
  int			arity;
  SLList<rterm *>	args;

public:
			term_functor() { tt = tt_functor;
					 module = NULL;
					 name = NULL;
					 arity = 0; // default
				       }
			term_functor(char *m, char *n);
  char			*GetModule() { return module; }
  char			*GetName() { return name; }
  int			GetArity() { return arity; }
  void			SetModule(char *m) { module = m; }
  void			SetArity(int a) { arity = a; }
  int			AppendArg(rterm *t) { args.append(t); }
  rterm			*GetArg(int n);
  SLList<rterm *>	GetArgs() { return args; }

  int			isconcrete();
  void			Unparse();
  void			Print();
};

class term_structure : public rterm {
public:
  term_structure() { tt = tt_structure; }
};

class term_cons : public rterm {
  rterm			*car, *cdr;

public:
			term_cons() { tt = tt_cons;
				      car = NULL;
				      cdr = NULL; }
			term_cons(rterm *t1, rterm *t2) { tt = tt_cons;
							  car = t1;
							  cdr = t2;
							}

  rterm			*Car() { return car; }
  rterm			*Cdr() { return cdr; }
  rterm			*SetCar(rterm *term) { rterm *old;
					       car = term;
					       return old; }
  rterm			*SetCdr(rterm *term) { rterm *old;
					       cdr = term;
					       return old; }
  int			isconcrete();
  void			Unparse();
  void			Print();
};

class term_nil : public rterm {
public:
  term_nil() { tt = tt_nil; }

  int			isconcrete() { return 1; }
  void			Unparse();
  void			Print() { printf("nil"); }
};

class term_vector : public rterm {
public:
  term_vector() { tt = tt_vector; }

  int			isconcrete() { return 0; } // XXX
  void			Unparse() {}
  void			Print() {}
};

class term_string : public rterm {
public:
  term_string() { tt = tt_string; }

  int			isconcrete() { return 0; } // XXX
  void			Unparse() {}
  void			Print() {}
};

class term_integer : public rterm {
  int			value;
  term_integer		*next;	// for linked list
public:
			term_integer(int i, term_integer *n) {
			  tt = tt_integer;
			  value = i;
			  next = n; }
			term_integer(int n) { tt = tt_integer;
					      value = n;
//					      printf("Creating integer(%d)\n", n);
					    }
					      
  int			GetValue() { return value; }
  void			SetValue(int n) { value = n; }
  term_integer		*GetNext() { return next; }

  int			isconcrete() { return 1; }
  void			Unparse();
  void			Print() { printf("%d", value); }
};

class term_real : public rterm {
public:
  term_real() { tt = tt_real; }

  int			isconcrete() { return 1; }
  void			Unparse() {}
  void			Print() {}
};

class rsubgoal {
  int		goalid;
  int		subgoalid;
  char		suspended;	// ':' or '!'
  char		state;		// '+' or '-'
  rterm		*term;
  rsubgoal	*next;		// for linked list
public:
		rsubgoal(int id, int subid, char sus, char s, rterm *t) {
		  goalid = id;
		  subgoalid = subid;
		  suspended = sus;
		  state = s;
		  term = t;
		  next = NULL;
		  if (debug_trace)
		    printf("Creating subgoal(%d) \n", id); }

  int		GetID() { return goalid; }
  rterm		*GetTerm() { return term; }
  rsubgoal	*GetNext() { return next; }
  void		SetNext(rsubgoal *n) { next = n; }

  //
  int		isproc() { term_functor *func = (term_functor *) term;
			   char *module = func->GetModule();
			   // XXX: crazy comparison!!!
			   return (module != get_symbol("unify_term_dcode")
				   && module != get_symbol("unify_goal")
				   && module != get_symbol("integer_arithmetics")
				   && module != get_symbol("builtin"));
			   //return module == NULL; // HHHHmmmm
                }
  int		wassuspended() { return suspended == '!'; }
  int		ismerger() { term_functor *func = (term_functor *) term;;
			     char *module = func->GetModule();
			     if (module)
			       return strcmp("unify_term_dcode", module) == 0;
			     else
			       return 0;
			   }
  int		isruleid() { term_functor *func = (term_functor *) term;;
			     char *name = func->GetName();
			     return name[0] == 'c' && name[1] == '_'; // XXX
			   }
			     
  
  //
  // for debugging
  //
  Dump()	{}
};

RuleType str_to_RuleType(char *name);
char *RuleType_to_str(RuleType type);
PortType char_to_PortType(char io, char *name);
char *PortType_to_char(PortType type);

ActType str_to_ActType(char *name);
char *ActType_to_str(ActType act);

rterm *deref(rterm *t);
void init_term_integer();
term_integer *alloc_term_integer(int n);

#endif

/* eof */
