// Copyright (C) 1996,1997 Buntarou Shizuki(shizuki@is.titech.ac.jp)

#include "parse.h"
#include "rproc.h"

#include <SLList.h>
Am_Object Am_Rproc;
Am_Object Am_Rlink;
Am_Object rgroup;
Am_Object rlinks;
Am_Object Stream_Monitor;
Am_Object port_enable_button;
Am_Object port_disable_button;
Am_Object change_layout_button;

int global_time = 0;
int mode_update_monitor = 0;
int mode_creation_time = 0;
int mode_show_continuous_change = 0;
int mode_draw_links = 1;
int mode_draw_links_always = 0;
int mode_draw_fixed_links = 0;
int mode_animation = 1;
int interpolation_step = INTERPOLATION_STEP;

rterm *NIL;
static SLList<term_variable *> run_env;

//-----------------------------------------------------------------------------
Am_Slot_Key RPROC		= Am_Register_Slot_Name("RPROC");
Am_Slot_Key RPROC_MOVER_PART	= Am_Register_Slot_Name("RPROC_MOVER_PART");
Am_Slot_Key RPROC_NORMAL	= Am_Register_Slot_Name("RPROC_NORMAL");
Am_Slot_Key RPROC_SMALL		= Am_Register_Slot_Name("RPROC_SMALL");
Am_Slot_Key RPROC_LITTLE	= Am_Register_Slot_Name("RPROC_LITTLE");
Am_Slot_Key RPROC_SELECT	= Am_Register_Slot_Name("RPROC_SELECT");
Am_Slot_Key RPROC_BACK		= Am_Register_Slot_Name("RPROC_BACK");
Am_Slot_Key PROC_PART		= Am_Register_Slot_Name("PROC_PART");
Am_Slot_Key BL_SRC_NAME		= Am_Register_Slot_Name("BL_SRC_NAME");
Am_Slot_Key BL_DEST_NAME	= Am_Register_Slot_Name("BL_DEST_NAME");
Am_Slot_Key RPROC_POPUP		= Am_Register_Slot_Name("RPROC_POPUP");

Am_Define_Formula(bool, rproc_normal_visible)
{
  Am_Object proc = self.GV_Owner();
  if (proc.Valid()
      && (int)proc.GV(CZSTATE) == CZSTATE_LEAF
      && (int)self.GV(Am_WIDTH) +1 < (int)proc.GV(Am_WIDTH) // XXX
      && (int)self.GV(Am_HEIGHT)+1 < (int)proc.GV(Am_HEIGHT) // XXX
      )
    return true;
  return false;
}

Am_Define_Formula(bool, rproc_small_visible)
{
  Am_Object proc = self.GV_Owner();
  if (proc.Valid() && (int)proc.GV(CZSTATE) == CZSTATE_LEAF) {
    int proc_w = proc.GV(Am_WIDTH);
    int proc_h = proc.GV(Am_HEIGHT);
    Am_Object normal_image = proc.GV_Part(RPROC_NORMAL);
    if (normal_image.Valid()) {
      if (!normal_image.GV(Am_VISIBLE)
	  && (int)self.GV(Am_WIDTH) +2 < proc_w // XXX
	  && (int)self.GV(Am_HEIGHT)+2 < proc_h // XXX
	  )
	return true;
      else
	return false;
    } else
      return true;
  }
  return false;
}

Am_Define_Formula(bool, rproc_little_visible)
{
  Am_Object proc = self.GV_Owner();
  if (proc.Valid() && (int)proc.GV(CZSTATE) == CZSTATE_LEAF) {
    //proc.GV(Am_WIDTH); proc.GV(Am_HEIGHT);
    Am_Object normal_image = proc.GV_Part(RPROC_NORMAL);
    Am_Object small_image = proc.GV_Part(RPROC_SMALL);
    if (!small_image.GV(Am_VISIBLE) && !normal_image.GV(Am_VISIBLE))
      return true;
  }
  return false;
}

Am_Define_Formula(int, width_of_grand_owner)
{
  Am_Object proc = self.GV_Owner();
  if (proc.Valid()) {
    Am_Object grand_proc = proc.GV_Owner();
    if (grand_proc.Valid())
      return grand_proc.GV(Am_WIDTH);
  }
  return 0;
}

Am_Define_Formula(int, height_of_grand_owner)
{
  Am_Object proc = self.GV_Owner();
  if (proc.Valid()) {
    Am_Object grand_proc = proc.GV_Owner();
    if (grand_proc.Valid())
      return grand_proc.GV(Am_HEIGHT);
  }
  return 0;
}

Am_Define_String_Formula(owner_proc_name)
{
  Am_Object proc = self.GV_Owner();
  if (proc.Valid())
    return (Am_String) proc.GV(PROC_NAME);
  else
    return (Am_String) "rproc";
}

Am_Define_Formula(int, width_of_name_part)
{
  Am_Object owner = self.GV_Owner();
  if (owner.Valid()) {
    Am_Object name_part = owner.GV_Part(NAME_PART);
    if (name_part.Valid())
      return (int)name_part.GV(Am_LEFT)*2 + (int)name_part.GV(Am_WIDTH);
  }
  return 0;
}
Am_Define_Formula(int, height_of_name_part)
{
  Am_Object owner = self.GV_Owner();
  if (owner.Valid()) {
    Am_Object name_part = owner.GV_Part(NAME_PART);
    if (name_part.Valid())
      return (int)name_part.GV(Am_TOP)*2 + (int)name_part.GV(Am_HEIGHT);
  }    
  return 0;
}

Am_Define_Formula(bool, rlink_visible)
{
  Am_Object bl_src  = (Am_Object)self.GV(BL_SRC);
  Am_Object bl_dest = (Am_Object)self.GV(BL_DEST);

  if (bl_src.Valid() && bl_src.GV(Am_VISIBLE)
      && bl_dest.Valid() && bl_dest.GV(Am_VISIBLE))
    return true;
  else
    return false;
}

Am_Define_Formula(int, rlink_xy)
{
  int x1, y1, x2, y2;

  Am_Object bl_src = (Am_Object)self.GV(BL_SRC);
  Am_Object bl_dst = (Am_Object)self.GV(BL_DEST);
  if (!(bl_src.Valid() && bl_dst.Valid())) {
    self.Set(Am_Y1, 0).Set(Am_X2, 0).Set(Am_Y2, 0);
    return 0;
  }

  Am_Object src_proc;
  {
    Am_Object parent = bl_src.Get_Owner();
    while (parent.Valid()) {
      if (parent.Is_Instance_Of(Am_Rproc)) {
	src_proc = parent;
	break;
      }
      parent = parent.Get_Owner();
      parent.GV(Am_LEFT);  parent.GV(Am_TOP);
      parent.GV(Am_WIDTH); parent.GV(Am_HEIGHT);
    }
  }
  Am_Object dst_proc;
  {
    Am_Object parent = bl_dst.Get_Owner();
    while (parent.Valid()) {
      if (parent.Is_Instance_Of(Am_Rproc)) {
	dst_proc = parent;
	break;
      }
      parent = parent.Get_Owner();
      parent.GV(Am_LEFT);  parent.GV(Am_TOP);
      parent.GV(Am_WIDTH); parent.GV(Am_HEIGHT);
    }
  }
  
  bool src_cluster = false;
  bool dst_cluster = false;
  if ((int)src_proc.GV(CZSTATE) == CZSTATE_CLUSTER)
    src_cluster = true;
  if ((int)dst_proc.GV(CZSTATE) == CZSTATE_CLUSTER)
    dst_cluster = true;

  Am_Object top_obj = rlinks;
  Am_Object src_obj, dst_obj;
  Am_Object normal_part, small_part, little_part;
  if (src_cluster) {
    src_obj = src_proc;
    rproc *p = (rproc*)(void*)src_proc.GV(RPROC);
    SubProc *sp = p->GetSubProc();
    Am_String bl_src_name = (Am_String)self.GV(BL_SRC_NAME);
    double rx = sp->GetPortRx(bl_src_name);
    double ry = sp->GetPortRy(bl_src_name);
    x1 = (int)(rx * (double)src_proc.GV(Am_WIDTH) + (double)src_proc.GV(Am_LEFT));
    y1 = (int)(ry * (double)src_proc.GV(Am_HEIGHT) + (double)src_proc.GV(Am_TOP));
  } else {
    normal_part = src_proc.GV_Part(RPROC_NORMAL);
    small_part  = src_proc.Get_Part(RPROC_SMALL);
    little_part = src_proc.Get_Part(RPROC_LITTLE);
    if (normal_part.Valid() && (bool)normal_part.GV(Am_VISIBLE)) {
      src_obj = bl_src;
    } else if (small_part.Valid() && (bool)small_part.GV(Am_VISIBLE)) {
      src_obj = small_part;
    } else if (little_part.Valid() && (bool)little_part.GV(Am_VISIBLE)) {
      src_obj = little_part;
    } else {
      src_obj = NULL;
    }
  }
  if (dst_cluster) {
    dst_obj = dst_proc;
    rproc *p = (rproc*)(void*)dst_proc.GV(RPROC);
    SubProc *sp = p->GetSubProc();
    Am_String bl_dst_name = (Am_String)self.GV(BL_DEST_NAME);
    double rx = sp->GetPortRx(bl_dst_name);
    double ry = sp->GetPortRy(bl_dst_name);
    x2 =(int)(rx*(double)dst_proc.GV(Am_WIDTH) + (double)dst_proc.GV(Am_LEFT));
    y2 =(int)(ry*(double)dst_proc.GV(Am_HEIGHT) + (double)dst_proc.GV(Am_TOP));
  } else {
    normal_part = dst_proc.GV_Part(RPROC_NORMAL);
    small_part  = dst_proc.Get_Part(RPROC_SMALL);
    little_part = dst_proc.Get_Part(RPROC_LITTLE);
    if (normal_part.Valid() && (bool)normal_part.GV(Am_VISIBLE)) {
      dst_obj = bl_dst;
    } else if (small_part.Valid() && (bool)small_part.GV(Am_VISIBLE)) {
      dst_obj = small_part;
    } else if (little_part.Valid() && (bool)little_part.GV(Am_VISIBLE)) {
      dst_obj = little_part;
    } else {
      dst_obj = NULL;
    }
  }
  
  if (src_obj.Valid() && dst_obj.Valid()) {
    // now, src_obj and dst_obj contains the right Am_Object
    int src_x, src_y, dst_x, dst_y;
    int src_w, src_h, dst_w, dst_h;

    if (src_cluster) {
      src_x = x1; src_y = y1;
      src_w = 0; src_h = 0;
    } else {
      Am_Translate_Coordinates(src_obj, 0, 0, top_obj, src_x, src_y);
      src_w = src_obj.GV(Am_WIDTH); src_h = src_obj.GV(Am_HEIGHT);
    }
    if (dst_cluster) {
      dst_x = x2; dst_y = y2;
      dst_w = 0; dst_h = 0;
    } else {
      Am_Translate_Coordinates(dst_obj, 0, 0, top_obj, dst_x, dst_y);
      dst_w = dst_obj.GV(Am_WIDTH); dst_h = dst_obj.GV(Am_HEIGHT);
    }

    x1 = src_x + src_w/2;	y1 = src_y + src_h/2;
    x2 = dst_x + dst_w/2;	y2 = dst_y + dst_h/2;
    if (x1 < dst_x)		x2 = dst_x;
    if (x1 > dst_x+dst_w)	x2 = dst_x+dst_w;
    if (src_x+src_w < dst_x)	x1 = src_x+src_w;
    if (src_x > dst_x+dst_w)	x1 = src_x;
    if (y1 < dst_y)		y2 = dst_y;
    if (y1 > dst_y+dst_h)	y2 = dst_y+dst_h;
    if (src_y+src_h < dst_y)	y1 = src_y+src_h;
    if (src_y > dst_y+dst_h)	y1 = src_y;

    self.Set(Am_Y1, y1).Set(Am_X2, x2).Set(Am_Y2, y2);
    return x1;
  } else {
    self.Set(Am_Y1, 0).Set(Am_X2, 0).Set(Am_Y2, 0);
    return 0;
  }
}

//-----------------------------------------------------------------------------
enum GoalType {
  goal_ruleid,
  goal_suspended,
  goal_process,
  goal_merger,
  goal_arith,
  goal_null
  };

class GoalEntry {
  int		goalid;
  GoalType	type;
  rterm		*term;
  rproc		*proc;
  GoalEntry	*next;		// for linked list
  
public:
  GoalEntry(int id, GoalType gtype,
	    rterm *t, rproc *p) { goalid = id;
				  type = gtype;
				  term = t;
				  proc = p;
				  next = NULL; }
  
  int		GetID() { return goalid; }
  GoalType	Type() { return type; }
  rterm		*GetTerm() { return term; }
  rproc		*GetProc() { return proc; }
  GoalEntry	*GetNext() { return next; }
  void		SetNext(GoalEntry *e) { next = e; }
  void		Suspended() { type = goal_suspended; }
  void		resume() { }	// XXX
};

//-----------------------------------------------------------------------------
static void animate();
/*static*/ void remove_links();
/*static*/ void draw_links();

/*
static void do_grow(Am_Object cmd_obj);
static void do_shrink(Am_Object cmd_obj);
*/
static void create_Am_Rproc();
static void create_Am_Rlink();
static void create_rproc_popup();
static void create_Stream_Monitor();

static int gstore_init();
static int gstore_add(int goalid, GoalType t, rterm *term, rproc *proc);
static GoalEntry *gstore_get(int goalid);

//-----------------------------------------------------------------------------
//
// initialize execution environment
//
rterm *rterm_list = NULL;
rproc *proc_main = NULL;

int
env_init()
{
  gstore_init();
  pstore_init();
  
  //
  // bootstrap goal '1 main'
  // creating rproc No. 0
  //
  char *sym_main = get_symbol("main");

  Proc  *p = getProc(sym_main, sym_main, 0);
  Rule  *r = p->GetRule(0);	// Rule 0 of main process
  rterm *func_main = new term_functor(sym_main, sym_main);
  proc_main = pstore_create(sym_main, sym_main, NULL, NULL, 0);
  CZNode::CZSetRoot(proc_main);
  proc_main->SetPoint(0, 0);	// XXX
  proc_main->SetSize(100, 100); // XXX
  proc_main->SetLeader(NULL);	// XXX
  proc_main->CZSetState(CZ_be_opened);
  gstore_add(1, goal_process, func_main, proc_main);
  
  //
  // create [] object
  //
  NIL = new term_nil();
  init_term_integer();
  
  main_draw();
  window_update();
  
  return 0;
}

//
// update execution environment
//
int
env_update()
{
  return 0;
}

//
// find variable NAME and return it. if no variable NAME is found,
// create one.
//
term_variable *
env_getvar(char *name)
{
  term_variable *v;
  Pix i;
  
  //
  // Oh..., a linear search!!
  //
  for (i = run_env.first(); i != 0; run_env.next(i)) {
    v = run_env(i);
    if (strcmp(v->GetName(), name) == 0) {
      return v;
    }
  }  
  
  v = new term_variable(name);
  run_env.append(v);
  
  return v;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
static int update_call(int goalid, rterm *head, rsubgoal *subgoal);
static int update_redu(int goalid, rterm *head, rsubgoal *subgoal);
static int update_susp(int goalid, rterm *head, rsubgoal *subgoal);
static int update_psus(int goalid, rterm *head, rsubgoal *subgoal);
static int update_fail(int goalid, rterm *head, rsubgoal *subgoal);

#define UPDATE_NONE	0
#define UPDATE_ERROR	1
#define UPDATE_REDRAW	2
#define UPDATE_MONITOR	4

int
update(int goalid, ActType acttype, rterm *head, rsubgoal *subgoal)
{
  window_update();

  int ret;
  if (debug_trace)
    printf("Update: Goal = %d, Type = %s\n", goalid, ActType_to_str(acttype));
  
  switch (acttype) {
  case act_call:
    ret = update_call(goalid, head, subgoal);
    break;
  case act_redu: 
    ret = update_redu(goalid, head, subgoal);
    break;
  case act_susp:
    ret = update_susp(goalid, head, subgoal);
    break;
  case act_psus:
    ret = update_psus(goalid, head, subgoal);
    break;
  case act_fail:
    ret = update_fail(goalid, head, subgoal);
    break;
  case act_null:
  default:
    ret = 1;
    break;
  }
  if (ret & UPDATE_REDRAW)
    main_draw();
  if (ret & UPDATE_MONITOR)
    pstore_monitor();
  window_update();
  
  global_time++;		// XXX
  if (mode_creation_time) {
    rproc *main_proc = pstore_get(0);
    main_proc->update_system_doi();
  }
  return ret;
}

static int
update_call(int goalid, rterm *head, rsubgoal *subgoal)
{
  GoalEntry *e = gstore_get(goalid);
  if (e == NULL) {
    printf("Update_call: Fatal error: can't find goal %d in gstore\n", goalid);
    return UPDATE_ERROR;
  }
  if (e->Type() == goal_ruleid) {
    if (debug_update_call)
      printf("Update_call: Called ruleid(%d)\n", goalid);
    return UPDATE_NONE;
  }
  if (e->Type() == goal_merger) {
    if (debug_update_call)
      printf("Update_call: Called merger(%d)\n", goalid);
    return UPDATE_NONE;
  }
  if (e->Type() == goal_process) {
    // now...
    if (debug_update_call)
      printf("Update_call: Called procss goal %d\n", goalid);
    rproc *p = e->GetProc();
    if (p != NULL)
      p->run();
    return UPDATE_NONE;
  }
  if (e->Type() == goal_suspended) {
    // XXX:
  }

  //
  // sometimes unification is necessary...???
  //

  return UPDATE_NONE;
}

static int
update_redu(int goalid, rterm *head, rsubgoal *subgoal)
{
  if (head->Type() != tt_functor) {
    printf("Fatal error: head must be a functor\n");
    return UPDATE_ERROR;
  }
  
  GoalEntry *e = gstore_get(goalid);
  if (e == NULL) {
    printf("Fatal error: can't find goal %d in gstore\n", goalid);
    return UPDATE_ERROR;
  }
  
/*
  //
  // for ruleid goal
  //
  if (e->Type() == goal_ruleid)
    return UPDATE_NONE;
*/
  
  //
  // unification
  //
  int ret_unify = unify_term(head, e->GetTerm());
  if (ret_unify) {
    printf("Fatal error: unification failed(goal %d)\n", goalid);
    return UPDATE_ERROR;
  }
  
  //
  // process resumed subgoals and merger goals
  // example:
  //  17 REDU: main:filter([3|_5A],2,[3|_6E]) :-
  //  12   0!+sifts([3|_6E],_35)
  //  18   1:+c_filter(1)
  //  19   2:+filter(_5A,2,_6E)? 
  // or
  //  94 REDU: unify_term_dcode:unify_goal([[1]|_270],[[1]|_270]) :-
  //  64   0!+main:filter([[1]|_270],1,_6140)
  //  69   1!+main:filter([[1]|_270],2,_60FC)
  //  74   2!+main:filter([[1]|_270],3,_60B8)
  //  79   3!+main:filter([[1]|_270],4,_6074)? 
  //
  while (subgoal != NULL) {
    if (subgoal->wassuspended()) {
      int subgid = subgoal->GetID();
      GoalEntry *sube = gstore_get(subgid);
      if (sube == NULL) {
	printf("Update_redu: Fatal error: can't find goal %d in gstore\n",
	       subgid);
	return UPDATE_ERROR;
      }
      if (debug_trace)
	printf("Update_redu: Resumed goal %d\n", subgid);
      sube->resume();
      // SUBGOAL pointer is proceeded
      subgoal = subgoal->GetNext();
    } else if (subgoal->ismerger()) {
      // XXX:
      rproc *proc = e->GetProc();
      gstore_add(subgoal->GetID(), goal_merger, subgoal->GetTerm(), proc);
      subgoal = subgoal->GetNext();
    } else
      break;
  }

  //
  // if there is no more subgoal
  //
  if (subgoal == NULL) {
    if (e->Type() == goal_ruleid)
      return UPDATE_NONE;
    if (e->Type() == goal_arith)
      return UPDATE_MONITOR;
    if (e->Type() == goal_merger)
      return UPDATE_MONITOR;
    //
    printf("Update_redu: Fatal error: unknown goal type(%d)\n", e->Type());
    return UPDATE_ERROR;
  }

  //
  // sometimes, strange logs are created like this:
  //	83 REDU: main:combo_add([[a,b],[b,b],...,[a,b,c],_1C4) :-
  //	91   0:+combo_add([[a,b],[b,b],...,[a,b,c],_1C4)? 
  //
  // one subgoal and same functor name XXX
  //
  if (subgoal != NULL && subgoal->GetNext() == NULL) {
    int           subgoal_id    = subgoal->GetID();
    term_functor *subgoal_term  = (term_functor *) subgoal->GetTerm();
    char	 *subgoal_module= subgoal_term->GetModule();
    char	 *subgoal_name  = subgoal_term->GetName();
    char         *head_module   = ((term_functor *) head)->GetModule();
    char         *head_name     = ((term_functor *) head)->GetName();
    if (head_name == subgoal_name && head_module == subgoal_module) { // XXX
      //printf("Update_redu: Strange log... is it right?\n");
      gstore_add(subgoal_id, e->Type(), subgoal_term, e->GetProc());
      return UPDATE_MONITOR;
    } else {
      //
    }
  }

  //
  // this is a process
  //
  char *module;
  char *name;
  Proc *p;
  Rule *r;
  int rule_num;

  module = ((term_functor *) head)->GetModule();
  name = ((term_functor *) head)->GetName();
  p = getProc(module, name, 0);
  if (p == NULL) {
    printf("Can't find process definition: %s : %s\n", module, name);
    return UPDATE_ERROR;
  }

  //
  // now, process ruleid goal and arithmentic goals
  //
  while (subgoal != NULL) {
    term_functor *func = (term_functor *) subgoal->GetTerm();
    if (subgoal->isruleid()) {
      //
      // handling rule_id goal
      //	prepare int rule_num, Rule *r
      //
      term_integer *id = (term_integer *) func->GetArg(0);
      rule_num = id->GetValue();
      r = p->GetRule(rule_num);
      if (r == NULL) {
	printf("Update_redu: Rule #%d is not defined in %s\n", rule_num, name);
	return UPDATE_ERROR;
      }
      if (debug_trace)
	printf("Fire %s rule #%d\n", name, rule_num);
      
      rproc *proc = e->GetProc();
      gstore_add(subgoal->GetID(), goal_ruleid, subgoal->GetTerm(), proc);
      subgoal = subgoal->GetNext(); // proceed subgoal pointer
      break;
    } else {
      // something like a arithmetic function XXX
      gstore_add(subgoal->GetID(), goal_arith, subgoal->GetTerm(), NULL);
    }
    subgoal = subgoal->GetNext(); // proceed subgoal pointer
  }

  rsubgoal *sg;

  switch (r->Type()) {
    ;
  case rule_network: {
    int subproc_number = 0;
    rproc *parent = e->GetProc();

    //
    // updating rproc hierarchy
    //
    for (sg = subgoal; sg != NULL; sg = sg->GetNext()) {
      int		subgoal_id = sg->GetID();
      term_functor	*subgoal_term = (term_functor *) sg->GetTerm();
      char		*subgoal_module = subgoal_term->GetModule();
      char		*subgoal_name = subgoal_term->GetName();
      
      if (sg->isproc()) {
	// spawning processes
	rproc *proc = pstore_create(subgoal_module, subgoal_name,
				    parent, r, global_time);
	
	// binding process ports with runtime-created terms
	SLList<rterm *> args = subgoal_term->GetArgs();
	proc->bind(args);
	// OLD: proc->calc_init();
	proc->CZCalcInit(parent);
	gstore_add(subgoal_id, goal_process, subgoal_term, proc);

	// set ports' coordinate of processes based on the rule definition
	SLList<Port *> portlist = proc->GetProc()->GetPorts();
	Pix pi;
	for (pi = portlist.first(); pi != NULL; portlist.next(pi)) {
	  char *portname         = portlist(pi)->name;
	  Port *thisport         = r->GetPort(subproc_number, portname);
	  Am_Object normal_image = proc->Image().Get_Part(RPROC_NORMAL);
	  Am_Object port_image   = Proc_Get_Port(normal_image, thisport->name);
	  port_image
	    .Set(Am_LEFT,  thisport->left)
	    .Set(Am_TOP,   thisport->top)
	    .Set(PORT_DIR, thisport->lr == Port_Left ? KL_Left : KL_Right)
	    ;
	  if (debug_port_coordinate)
	    printf("Update_redu: setting %s(%s:%s,pid=%d)(%d,%d)\n",
		   portname,
		   proc->GetModule(), proc->GetName(), proc->GetID(),
		   thisport->left, thisport->top);
	}
	subproc_number++;
      } else {
	// something like a arithmetic function
	gstore_add(subgoal_id, goal_arith, subgoal_term, NULL);
      }
    }
    parent->update();
    parent->Image().Set(Am_VISIBLE, false); // XXX
    
    //
    // updating link network
    //
    SLList<Link *> links = r->GetLinks();
    Pix j;
    for (j = links.first(); j != 0; links.next(j)) {
      Link *link = links(j);
      rproc *p1, *p2;
      Port *my_port, *to_port;
      int id1 = link->id1;
      int id2 = link->id2;
      
      my_port = r->GetPort(id2); // XXX
      to_port = r->GetPort(id1); // XXX
      
      if (my_port == NULL || to_port == NULL)
	printf("update_redu: Link src or dst is not defined(src=%d,dst=%d)\n",
	       id2, id1);

      if (my_port->where < 0)
	p1 = parent;
      else
	p1 = parent->GetChild(my_port->where);
      if (to_port->where < 0)
	p2 = parent;
      else
	p2 = parent->GetChild(to_port->where);
      
      //
      p1->SetLink(my_port->name, to_port->name, p2);
    }
    break;
  }
  case rule_continuous: {
    // continuous process
    rproc *proc = e->GetProc();
    
    if (mode_show_continuous_change) {
      if (proc->IsVisible()) {
	//
	// should be modified to change the color of
	// not only VisiblePart but also the all of the parts
	// blinking only VisiblePart
	//
	Am_Object image = proc->VisiblePart();
	Am_Style red_stipple("red", 8, Am_CAP_BUTT, Am_JOIN_MITER, Am_LINE_SOLID,
			     Am_DEFAULT_DASH_LIST, Am_DEFAULT_DASH_LIST_LENGTH,
			     Am_FILL_STIPPLED, Am_FILL_POLY_EVEN_ODD,
			     (Am_Image_Array(50)));
	window_highlight_object(image, red_stipple, red_stipple,
				1, SPEED_CHECK, 0);
      }
    }

    for (sg = subgoal; sg != NULL; sg = sg->GetNext()) {
      if (sg->isproc()) {
	term_functor *subgoal_term = (term_functor *) sg->GetTerm();
	SLList<rterm *> args = subgoal_term->GetArgs();
	proc->bind_cont(args);
	gstore_add(sg->GetID(), goal_process, sg->GetTerm(), proc);
      } else {
	//
	// XXX: more check should be made
	//
	gstore_add(sg->GetID(), goal_arith, sg->GetTerm(), NULL);
      }
    }
    break;
  }
  case rule_vanishing: {
    //
    rproc *proc = e->GetProc();
    if (debug_trace)
      printf("Terminating process %d\n", proc->GetID());
    proc->die();
    
    break;
  }
  default:
    return UPDATE_ERROR;
  }
  return UPDATE_REDRAW|UPDATE_MONITOR;
}

static int
update_susp(int goalid, rterm *head, rsubgoal *subgoal)
{
  GoalEntry *e = gstore_get(goalid);
  if (e == NULL) {
    printf("Update_susp: Fatal error: can't find goal %d in gstore\n", goalid);
    return UPDATE_ERROR;
  }
  if (e->Type() == goal_ruleid) {
    printf("Update_susp: Fatal eroor: Called ruleid(%d)\n", goalid);
    return UPDATE_ERROR;
  }

  //
  // Is This RIGHT???
  //
  if (e->Type() == goal_process) {
    rproc *p = e->GetProc();
    p->suspend();
    if (debug_trace)
      printf("Update_susp: Suspend goal %d(pid=%d)\n", goalid, p->GetID());
    return UPDATE_REDRAW;
  }

  return UPDATE_NONE;		// XXX
}

static int
update_psus(int goalid, rterm *head, rsubgoal *subgoal)
{
  // must do something depending on each goal type
  return UPDATE_ERROR;
}

static int
update_fail(int goalid, rterm *head, rsubgoal *subgoal)
{
  // must do something depending on each goal type
  return UPDATE_ERROR;
}
    
//-----------------------------------------------------------------------------
// draw processes
//-----------------------------------------------------------------------------
Am_Define_Style_Formula(rproc_style)
{
  Am_Object obj = self;
  while (obj.Valid()) {
    if (obj.Is_Instance_Of(Am_Rproc))
      break;
    obj = obj.GV_Owner();
  }
  if (! obj.Valid())
    return Am_Motif_Light_Gray;
  
  return obj.GV(Am_FILL_STYLE);
}

Am_Define_Formula(bool, rproc_back_visibility)
{
  Am_Object proc = self.GV_Owner();
  if (proc.Valid())
    return (int)proc.GV(CZSTATE) == CZSTATE_CLUSTER;
  return false;
}

Am_Define_Style_Formula(rproc_back_line_style)
{
  Am_Object back = self.GV_Owner();
  Am_Object proc = back.GV_Owner(); // XXX
  if (proc.Valid()) {
    //    rproc *p = (rproc*)(void*)self.GV_Owner().GV(RPROC);
    rproc *p = (rproc*)(void*)proc.GV(RPROC);
    if (p != NULL) {
      int ptype = p->GetProc()->Type();
      if (ptype == PROC_TYPE_NORMAL) // XXX
	return Am_Line_2;
    }
  }
  return Am_Line_1;
}

Am_Define_Method(Am_Object_Method,
		 void, do_open_close, (Am_Object cmd))
{
  Am_Object menu_item = cmd.Get_Owner();
  if (! menu_item.Valid())
    return;
  Am_Object popup_menu = menu_item.Get_Owner();
  if (! popup_menu.Valid())
    return;
  Am_Object proc = (Am_Object)popup_menu.Get(TargetObj);
  if (! proc.Valid())
    return;
  rproc *p = (rproc*)(void*)proc.Get(RPROC);
  if (p == 0)
    return;
  if (debug_czoom_action)
    printf("proc(name=%s:%s,id=%d): Open/Close\n",
	   p->GetModule(),p->GetName(), p->GetID());
  if (p->do_expand() == 0)
    main_draw();
}

Am_Define_Method(Am_Object_Method,
		 void, do_open_close_auto, (Am_Object cmd))
{
  Am_Object menu_item = cmd.Get_Owner();
  if (! menu_item.Valid())
    return;
  Am_Object popup_menu = menu_item.Get_Owner();
  if (! popup_menu.Valid())
    return;
  Am_Object proc = (Am_Object)popup_menu.Get(TargetObj);
  if (! proc.Valid())
    return;
  rproc *p = (rproc*)(void*)proc.Get(RPROC);
  if (p == 0)
    return;
  if (debug_czoom_action)
    printf("proc(name=%s:%s,id=%d): Auto Open/Close\n",
	   p->GetModule(), p->GetName(), p->GetID());
  if (p->do_auto() == 0)
    main_draw();
}

Am_Define_Method(Am_Object_Method,
		 void, do_enable_port, (Am_Object cmd))
{
  Am_Object menu_item = cmd.Get_Owner();
  if (! menu_item.Valid())
    return;
  Am_Object popup_menu = menu_item.Get_Owner();
  if (! popup_menu.Valid())
    return;
  Am_Object proc = (Am_Object)popup_menu.Get(TargetObj);
  if (! proc.Valid())
    return;
  rproc *p = (rproc*)(void*)proc.Get(RPROC);
  if (p == 0)
    return;

  Am_String port_name = (Am_String)cmd.Get(PORT_NAME);

  Am_Object_Method method = popup_menu.Get_Part(Am_COMMAND).Get(Am_DO_METHOD);
  method.Call(cmd);

  // for updating menu contents
  popup_menu.Set(TargetObj, NULL); // XXX

  p->monitor_enable(port_name);
  printf("proc(name=%s:%s,id=%d): %s enabled\n",
	 p->GetModule(), p->GetName(), p->GetID(), (char*)port_name);
}

Am_Define_Method(Am_Object_Method,
		 void, do_disable_port, (Am_Object cmd))
{
  Am_Object menu_item = cmd.Get_Owner();
  if (! menu_item.Valid())
    return;
  Am_Object popup_menu = menu_item.Get_Owner();
  if (! popup_menu.Valid())
    return;
  Am_Object proc = (Am_Object)popup_menu.Get(TargetObj);
  if (! proc.Valid())
    return;
  rproc *p = (rproc*)(void*)proc.Get(RPROC);
  if (p == 0)
    return;

  Am_String port_name = (Am_String)cmd.Get(PORT_NAME);

  Am_Object_Method method = popup_menu.Get_Part(Am_COMMAND).Get(Am_DO_METHOD);
  method.Call(cmd);

  // for updating menu contents
  popup_menu.Set(TargetObj, NULL); // XXX

  p->monitor_disable(port_name);
  printf("proc(name=%s:%s,id=%d): %s disabled\n",
	 p->GetModule(), p->GetName(), p->GetID(), (char*)port_name);
}

Am_Slot_Key LAYOUT_ID		= Am_Register_Slot_Name("LAYOUT_ID");

Am_Define_Formula(Am_Wrapper *, rproc_popup_value)
{
  // prepare p(rproc)
  rproc *p;
  char title[1024];		// XXX
  //char *title;
  Am_Object popup_menu = self;
  Am_Object proc = (Am_Object)popup_menu.GV(TargetObj);
  if (proc.Valid()) {
    p = (rproc*)(void*)proc.GV(RPROC);
    //    printf("Popup menu of rproc(name=%s,pid=%d)\n", p->GetName(), p->GetID());
    sprintf(title, "%s:%s", p->GetModule(), p->GetName());
    //title = p->GetName();
  } else {
    p = NULL;
    //    printf("Popup menu of rproc(name=NULL,pid=???)\n");
    strcpy(title, "NULL");
    //title = "NULL";
  }

  // making default menu items
  Am_Value_List list = Am_Value_List()
    .Add(MenuCommand.Create("Process Menu Title")
	 .Set(Am_LABEL, title))
    .Add(Am_Menu_Line_Command.Create("line"))
    .Add(MenuCommand.Create("Open/Close")
	 .Set(Am_LABEL, "Open/Close")
	 .Set(Am_DO_METHOD, do_open_close))
    .Add(MenuCommand.Create("Auto_Open/Close")
	 .Set(Am_LABEL, "Auto Open/Close")
	 .Set(Am_DO_METHOD, do_open_close_auto)
//	 .Set(Am_ACTIVE, p != NULL && p->is_forced())
	 )
//    .Add(MenuCommand.Create()
//	 .Set(Am_LABEL, "Info..."))
    ;

  //
  // items for monitoring ports...
  //
  if (p) {
    SLList<rproc::port *> ports = p->get_ports();
    if (ports.length() > 0)
      list.Add(Am_Menu_Line_Command.Create("line"));
    Pix pi;
    for (pi = ports.first(); pi != 0; ports.next(pi)) {
      rproc::port *port = ports(pi);
      if (port->type == port_stream_in || port->type == port_stream_out) {
	if (port->monitored) {
	  list.Add(port_disable_button.Create(port->name)
		   .Set(PORT_NAME, port->name)
		   .Set(Am_LABEL, port->name));
	} else {
	  list.Add(port_enable_button.Create(port->name)
		   .Set(PORT_NAME, port->name)
		 .Set(Am_LABEL, port->name));
	}
      }
    }

    // desired representaion
    // ...
  }

  //
  // menu itmes for selecting a layout of pattern
  // when this is a process comprising top level of a pattern...
  //
  if (p && p->GetProc()->Type() == PROC_TYPE_PATTERN_TOP) {
    list.Add(Am_Menu_Line_Command.Create("line"));

    SLList<LayoutDef *>	layouts = p->GetProc()->GetLayoutDef();
    Pix li;
    int i;
    for (li = layouts.first(), i = 0; li != 0; layouts.next(li), i++) {
      LayoutDef *layout = layouts(li);

      list.Add(change_layout_button.Create(layout->GetName())
	       .Set(Am_LABEL, layout->GetName())
	       .Set(LAYOUT_ID, i));
    }
  }
  
  return (Am_Wrapper *)list;
}

extern Am_Object T_canvas;
Am_Define_Method(Am_Where_Method, Am_Object, In_Rproc,
		 (Am_Object inter,
		  Am_Object object, Am_Object event_window,
		  Am_Input_Char ic, int x, int y)) {
  cout << " --In_Rproc: " << inter << object << "\n";

  Am_Object proc_agg = T_canvas.Get_Part(PROC_PART);
  Am_Object proc = Am_Point_In_Part(proc_agg, x, y, event_window);
  if (proc.Is_Instance_Of(Am_Rproc)) {
    //return Popup_Menu_and_Return_First_Item(inter, proc, x, y);
  }
  return NULL;
}

int
draw_init()
{
  //
  // rgroup
  //
  rgroup = Am_Group.Create("processes")
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, 0)
    //    .Set(Am_WIDTH,  Am_Width_Of_Parts)
    //    .Set(Am_HEIGHT, Am_Height_Of_Parts)
    .Set(Am_WIDTH,  Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    ;
  window_draw(PROC_PART, rgroup);
  CZNode::CZInitCZoom(rgroup);
  CZNode::CZSetInterpolation(INTERPOLATION_STEP);
//  Am_Initialize_Inspector(rgroup);

  create_Am_Rproc();
  create_Am_Rlink();


  //
  // rlinks
  //
  rlinks = Am_Group.Create("links")
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, 0)
    .Set(Am_WIDTH,  Am_Width_Of_Parts)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
    ;
  window_draw(BINDER_PART, rlinks);
//  Am_Initialize_Inspector(rlinks);

  create_rproc_popup();
  create_Stream_Monitor();
}

#define PROCESS_TITLE_HEIGHT 18
Am_Define_Formula(int, rproc_title_height)
{
  return PROCESS_TITLE_HEIGHT;
}

Am_Define_Formula(int, rproc_frame_height)
{
  Am_Object parent = self.GV_Owner();
  if (parent.Valid())
    return (int)parent.GV(Am_HEIGHT) - PROCESS_TITLE_HEIGHT;
  else
    return 0;
}

// Am_Define_Formula(int, rproc_back_width)
// {
//   int f_width = self.GV_Part(FRAME_PART).GV(Am_WIDTH);
//   int n_width = self.GV_Part(NAME_PART).GV(Am_WIDTH);
// }

Am_Define_Method(Am_Object_Method,
		 void, do_change_layout, (Am_Object cmd))
{
  Am_Object menu_item = cmd.Get_Owner();
  if (! menu_item.Valid())
    return;
  Am_Object popup_menu = menu_item.Get_Owner();
  if (! popup_menu.Valid())
    return;
  Am_Object proc = (Am_Object)popup_menu.Get(TargetObj);
  if (! proc.Valid())
    return;
  rproc *p = (rproc*)(void*)proc.Get(RPROC);
  if (p == 0)
    return;

  Am_String layout_name = (Am_String)cmd.Get(Am_LABEL);
  int layout_id = (int)cmd.Get(LAYOUT_ID);

  if (debug_layout)
    printf("layout: setting layout of %s(%d) to '%s'\n",
	   p->GetName(), p->GetID(), (char *)layout_name);

  Am_Object_Method method = popup_menu.Get_Part(Am_COMMAND).Get(Am_DO_METHOD);
  method.Call(cmd);

  // for updating menu contents
  popup_menu.Set(TargetObj, NULL); // XXX

  // do change
  p->change_layout_top(layout_id);
}

#define RPROC_MARGIN 4
static void
create_Am_Rproc()
{
  //
  // Am_Rproc
  //
  Am_Object rproc_back_frame = Am_Rectangle.Create("rproc_back_frame")
    .Set(Am_LEFT, 0)
    //.Set(Am_TOP, 0)
    .Set(Am_TOP, rproc_title_height)
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    //.Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Set(Am_HEIGHT, rproc_frame_height)
    .Set(Am_LINE_STYLE, rproc_back_line_style)
    .Set(Am_FILL_STYLE, Am_No_Style)
    ;
  Am_Object rproc_back_name = ZoomingText.Create("rproc_back_name")
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, RPROC_MARGIN/2)
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, rproc_title_height)
    .Set(Am_TEXT, Am_From_Owner(PROC_NAME))
    .Set(FontFamily, FontSansSerif)
    .Set(FontIsBold, true)
    ;
//   Am_Object rproc_back_name = Am_Text.Create("rproc_back_name")
//     //.Set(Am_LEFT, RPROC_MARGIN/2) // XXX
//     .Set(Am_LEFT, Am_Center_X_Is_Center_Of_Owner) // XXX
//     .Set(Am_TOP,  RPROC_MARGIN/2) // XXX
//     .Set(Am_TEXT, Am_From_Owner(PROC_NAME))
//     .Set(Am_FONT, Am_Font("-*-helvetica-*-r-*--12-*"))
//     ;
  Am_Object rproc_back = Am_Group.Create("rproc_back")
    .Set(PROC_NAME, Am_From_Owner(PROC_NAME))
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, 0)
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    //.Set(Am_WIDTH, rproc_back_width)
    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Set(Am_VISIBLE,rproc_back_visibility)
    .Add_Part(FRAME_PART, rproc_back_frame)
    .Add_Part(NAME_PART, rproc_back_name)
    ;
  Am_Object rproc_small_frame = Am_Border_Rectangle.Create("rproc_small_frame")
    //Am_Object rproc_small_frame = Am_Rectangle.Create("rproc_small_frame")
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, 0)
    .Set(Am_WIDTH,  width_of_name_part)
    .Set(Am_HEIGHT, height_of_name_part)
    .Set(Am_FILL_STYLE, rproc_style)
    ;
  Am_Object rproc_small_name = Am_Text.Create("rproc_small_name")
    .Set(Am_LEFT, RPROC_MARGIN)
    .Set(Am_TOP,  RPROC_MARGIN)
    .Set(Am_TEXT, Am_From_Owner(PROC_NAME))
    .Set(Am_FONT, Am_Font("-*-helvetica-*-r-*--12-*"))
    ;
  Am_Object rproc_small = Am_Group.Create("rproc_small")
    .Set(PROC_NAME, Am_From_Owner(PROC_NAME))
    .Set(Am_LEFT,   Am_Center_X_Is_Center_Of_Owner)
    .Set(Am_TOP,    Am_Center_Y_Is_Center_Of_Owner)
    .Set(Am_WIDTH,  Am_From_Part(FRAME_PART, Am_WIDTH))
    .Set(Am_HEIGHT, Am_From_Part(FRAME_PART, Am_HEIGHT))
    .Set(Am_VISIBLE, rproc_small_visible)
    .Add_Part(FRAME_PART, rproc_small_frame)
    .Add_Part(NAME_PART, rproc_small_name)
    ;
  Am_Object rproc_little = Am_Border_Rectangle.Create("rproc_little")
  //Am_Object rproc_little = Am_Rectangle.Create("rproc_little")
    .Set(Am_LEFT,   Am_Center_X_Is_Center_Of_Owner)
    .Set(Am_TOP,    Am_Center_Y_Is_Center_Of_Owner)
    .Set(Am_WIDTH,  10-2)
    .Set(Am_HEIGHT, 10-2)
    .Set(Am_VISIBLE, rproc_little_visible)
    .Set(Am_FILL_STYLE, rproc_style)
    ;

  //
  // commands for popup menu items
  //
  port_enable_button = MenuCommand.Create("port_enable")
    .Set(PORT_NAME, "port name")
    .Set(Am_DO_METHOD, do_enable_port)
    ;
  port_disable_button = MenuCommand.Create("port_disable")
    .Set(PORT_NAME, "port name")
    .Set(Am_DO_METHOD, do_disable_port)
    ;

  change_layout_button = MenuCommand.Create("change_layout")
    .Set(Am_LABEL, "default layout")
    .Set(LAYOUT_ID, -1)
    .Set(Am_DO_METHOD, do_change_layout)
    ;

  //
  // Popup Menu
  //
  PopUpMenu
    .Get_Part(MenuBody)
      .Set(Am_FONT, Am_Font(MENUBAR_FONT))
      .Set(Am_FILL_STYLE, Am_Motif_Gray)
    ;
  Am_Object rproc_popup_menu = PopUpMenu.Create("rproc_popup_menu")
    //.Set(RPROC, NULL)
    .Get_Part(MenuBody)
      .Set(Am_ITEMS, rproc_popup_value)
      .Get_Owner()
    ;
  Am_Screen.Add_Part(rproc_popup_menu);
  Am_Object rproc_popper = PopUpMenuInteractor.Create("rproc_popupper")
    .Set(MenuWindow, rproc_popup_menu)
    ;

  // popup menu object must be added to window after process group
  //window_draw(RPROC_POPUP, rproc_popup);

  Process_Proto
    .Set(Am_LEFT, Am_Center_X_Is_Center_Of_Owner)
    .Set(Am_TOP, Am_Center_Y_Is_Center_Of_Owner)
    .Get_Part(FRAME_PART)
      .Set(Am_FILL_STYLE, rproc_style)
    ;
  Am_Rproc = CZNODE_PROTO.Create("rproc")
    .Set(Am_FILL_STYLE, Am_Motif_Light_Gray)
    .Set(RPROC, NULL)
    .Set(PROC_NAME, "rproc")
    .Add_Part(RPROC_BACK, rproc_back)
    .Add_Part(RPROC_SMALL, rproc_small)
    .Add_Part(RPROC_LITTLE, rproc_little)
    .Add_Part(rproc_popper.Create()
	      .Set(Am_START_WHEN, "middle_down"))
    ;
}
#undef RPROC_MARGIN

static void
create_Am_Rlink()
{
  //
  // Am_Rlink
  //
  Am_Rlink = Am_Line.Create("rlink")
    .Set(BL_SRC, 0)
    .Set(BL_SRC_NAME, "")
    .Set(BL_DEST, 0)
    .Set(BL_DEST_NAME, "")
    .Set(Am_VISIBLE, rlink_visible)
    .Set(Am_X1, rlink_xy)
    ;
}

static void
create_rproc_popup()
{
  return;
}

static Am_Object
get_monitor_window(Am_Object obj)
{
  for (;;) {
    if (! obj.Valid())
      return NULL;
    if (obj.Is_Instance_Of(Stream_Monitor))
      return obj;
    obj = obj.Get_Owner();
  }
}

Am_Define_Method(Am_Object_Method,
		 void, do_dismiss, (Am_Object cmd))
{
  Am_Object top = get_monitor_window(cmd);
  if (top == NULL)
    return;
  top.Set(Am_VISIBLE, false);
  rproc *p = (rproc*)(void*)top.Get(RPROC);
  Am_String port_name = (Am_String)top.Get(PORT_NAME);
  p->monitor_disable(port_name);
  printf("%s:%s(pid=%d):%s dismissing...\n",
	 p->GetModule(), p->GetName(), p->GetID(), (char*)port_name);
}

Am_Define_Method(Am_Object_Method,
		 void, do_check, (Am_Object cmd))
{
  Am_Object top = get_monitor_window(cmd);
  if (top == NULL)
    return;
  rproc *p = (rproc*)(void*)top.Get(RPROC);
  Am_String port_name = (Am_String)top.Get(PORT_NAME);
  printf("%s:%s(pid=%d):%s checking...\n",
	 p->GetModule(), p->GetName(), p->GetID(), (char*)port_name);

//  Am_Object proc_image = p->Image().Get_Part(RPROC_NORMAL);
//  Am_Object port_image = Proc_Get_Port(proc_image, port_name);

  Am_Object proc_image = p->Image();
  Am_Object port_image;
  if (proc_image.Get_Part(RPROC_NORMAL).Get(Am_VISIBLE)) {
    port_image = Proc_Get_Port(proc_image.Get_Part(RPROC_NORMAL), port_name);
  } else if (proc_image.Get_Part(RPROC_SMALL).Get(Am_VISIBLE)) {
    port_image = proc_image.Get_Part(RPROC_SMALL);
  } else
    port_image = proc_image.Get_Part(RPROC_LITTLE);
  
  // check the target process is displayed or not

  // if the target process is now expanded, close it...

  //
  Am_Style red_stipple("red", 8, Am_CAP_BUTT, Am_JOIN_MITER, Am_LINE_SOLID,
		       Am_DEFAULT_DASH_LIST, Am_DEFAULT_DASH_LIST_LENGTH,
		       Am_FILL_STIPPLED, Am_FILL_POLY_EVEN_ODD,
		       (Am_Image_Array(50)));
  window_highlight_object(port_image,
			  red_stipple, red_stipple,
			  3, SPEED_CHECK, SPEED_CHECK);
}
  
Am_Slot_Key MONITOR_GROUP	= Am_Register_Slot_Name("MONITOR_GROUP");
Am_Slot_Key MONITOR_DISMISS	= Am_Register_Slot_Name("MONITOR_DISMISS");
Am_Slot_Key MONITOR_CHECK	= Am_Register_Slot_Name("MONITOR_CHECK");
Am_Slot_Key MONITOR_CONTENT	= Am_Register_Slot_Name("MONITOR_CONTENT");
Am_Slot_Key MONITOR_SCROLL	= Am_Register_Slot_Name("MONITOR_SCROLL");
Am_Slot_Key MONITOR_TEXT	= Am_Register_Slot_Name("MONITOR_TEXT");

#define MAX_TITLE_LEN 256	// XXX

Am_Define_String_Formula(monitor_title)
{
  char s[MAX_TITLE_LEN];	// XXX
  rproc *p = (rproc*)(void*)self.GV(RPROC);
  char *proc_module;
  char *proc_name;
  if (p) {
    proc_module = p->GetModule();
    proc_name = p->GetName();
  } else {
    proc_module = "NULL";
    proc_name = "NULL";
  }
  Am_String port_name = (Am_String)self.GV(PORT_NAME);
  sprintf(s, "Stream Monitor(%s:%s : %s)",
	  proc_module, proc_name, (char*)port_name);
  return (Am_String)s;
}

Am_Define_String_Formula(monitor_icon_title)
{
  char s[MAX_TITLE_LEN];	// XXX
  rproc *p = (rproc*)(void*)self.GV(RPROC);
  char *proc_module;
  char *proc_name;
  if (p) {
    proc_module = p->GetModule();
    proc_name = p->GetName();
  } else {
    proc_module = "NULL";
    proc_name = "NULL";
  }
  Am_String port_name = (Am_String)self.GV(PORT_NAME);
  sprintf(s, "KLIEG Stream Monitor(%s: %s : %s)",
	  proc_module, proc_name, (char*)port_name);
  return (Am_String)s;
}

Am_Define_String_Formula(monitor_text)
{
  Am_Object scroll = self.GV_Owner();
  if (! scroll.Valid())
    return (Am_String)"";
  Am_Object group = scroll.GV_Owner();
  if (! group.Valid())
    return (Am_String)"";
  Am_Object top = group.GV_Owner();
  if (! top.Valid())
    return (Am_String)"";
  return top.GV(MONITOR_TEXT);
}

#define MONITOR_SCROLL_DEFAULT_WIDTH 100
#define MONITOR_DEFAULT_WIDTH 240
#define MONITOR_DEFAULT_HEIGHT 40

Am_Define_Formula(int, check_button_left)
{
  Am_Object group = self.GV_Owner();
  if (! group.Valid())
    return 0;
  return (int)group.GV_Part(MONITOR_DISMISS).GV(Am_WIDTH);
}

Am_Define_Formula(int, scroll_text_left)
{
  Am_Object group = self.GV_Owner();
  if (! group.Valid())
    return 0;
  Am_Object check = group.GV_Part(MONITOR_CHECK);
  return (int)check.GV(Am_LEFT) + (int)check.GV(Am_WIDTH);
}

Am_Define_Formula(int, scroll_text_width)
{
  Am_Object group = self.GV_Owner();
  if (! group.Valid())
    return MONITOR_SCROLL_DEFAULT_WIDTH;
  Am_Object window = group.GV_Owner();
  if (! window.Valid())
    return MONITOR_SCROLL_DEFAULT_WIDTH;
  return (int)window.GV(Am_WIDTH) - (int)self.GV(Am_LEFT);
}

static void
create_Stream_Monitor()
{
  Am_Object dismiss_button = Am_Button.Create("dismiss_button")
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, 0)
    .Set(Am_HEIGHT, MONITOR_DEFAULT_HEIGHT)
    .Set(Am_FILL_STYLE, Am_Motif_Gray)
    .Get_Part(Am_COMMAND)
      .Set(Am_LABEL, "dismiss")
      .Set(Am_DO_METHOD, do_dismiss)
      .Get_Owner()
      ;
  Am_Object check_button = Am_Button.Create("check_button")
    .Set(Am_LEFT, check_button_left)
    .Set(Am_TOP, 0)
    .Set(Am_HEIGHT, MONITOR_DEFAULT_HEIGHT)
    .Set(Am_FILL_STYLE, Am_Motif_Gray)
    .Get_Part(Am_COMMAND)
      .Set(Am_LABEL, "check")
      .Set(Am_DO_METHOD, do_check)
      .Get_Owner()
      ;
  Am_Object scroll_text = Am_Scrolling_Group.Create("scroll_text")
    .Set(Am_LEFT, scroll_text_left)
    .Set(Am_TOP, 0)
    .Set(Am_WIDTH, scroll_text_width)
    .Set(Am_HEIGHT, MONITOR_DEFAULT_HEIGHT)
    .Set(Am_FILL_STYLE, Am_Motif_Gray)
    .Set(Am_H_SCROLL_BAR, true)
    .Set(Am_V_SCROLL_BAR, false)
    .Set(Am_INNER_WIDTH, Am_Width_Of_Parts)
    .Set(Am_INNER_HEIGHT, Am_Height_Of_Parts)
    .Add_Part(MONITOR_CONTENT, Am_Text.Create("monitored content")
	      .Set(Am_LEFT, 0)
	      .Set(Am_TOP, 0)
#ifndef DEMO
#define TEXT_FONT  Am_Font("-*-courier-medium-r-*-*-16-*-*-*-*-*-*-*")
	      .Set(Am_FONT, TEXT_FONT)
#endif	      
	      .Set(Am_TEXT, monitor_text))
    ;
  Am_Object monitor_group = Am_Group.Create("monitor_group")
    .Set(Am_WIDTH, Am_Width_Of_Parts)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
    .Add_Part(MONITOR_DISMISS, dismiss_button)
    .Add_Part(MONITOR_CHECK, check_button)
    .Add_Part(MONITOR_SCROLL, scroll_text)
    ;
  Stream_Monitor = Am_Window.Create("stream_monitor_proto")
    .Set(RPROC, NULL)
    .Set(PORT_NAME, "PORT")
    .Set(MONITOR_TEXT, "monitoring...")
    .Set(Am_WIDTH, MONITOR_DEFAULT_WIDTH)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
//    .Set(Am_MIN_WIDTH, )
    .Set(Am_MIN_HEIGHT, MONITOR_DEFAULT_HEIGHT)
//    .Set(Am_USE_MIN_WIDTH, true)
    .Set(Am_USE_MIN_HEIGHT, true)
    .Set(Am_QUERY_POSITION, true)
    .Set(Am_FILL_STYLE, Am_Motif_Gray)
    .Set(Am_TITLE, monitor_title)
    .Set(Am_ICON_TITLE, monitor_icon_title)
    .Add_Part(MONITOR_GROUP, monitor_group)
    ;
//  Am_Object monitor_combo_in = Stream_Monitor.Create("hogehoge");
//  Am_Initialize_Inspector(monitor_combo_in);
//  Am_Screen.Add_Part(monitor_combo_in);
}
    
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
#define GSTORE_HASH_SIZE 1021

static GoalEntry *goal_table[GSTORE_HASH_SIZE];

static int
gstore_init()
{
  int i;
  for (i = 0; i < GSTORE_HASH_SIZE; i++) {
    goal_table[i] = NULL;
  }
  return 0;
}

static int
gstore_add(int goalid, GoalType t, rterm *term, rproc *proc)
{
  GoalEntry *e = new GoalEntry(goalid, t, term, proc);
  int i = goalid % GSTORE_HASH_SIZE;
  e->SetNext(goal_table[i]);
  goal_table[i] = e;

  if (debug_gstore)
    printf("gstore: add %d\n", goalid);
  return 0;
}

static GoalEntry *
gstore_get(int goalid)
{
  GoalEntry *e;
  int i = goalid % GSTORE_HASH_SIZE;
  for (e = goal_table[i]; e != NULL; e = e->GetNext()) {
    if (e->GetID() == goalid)
      return e;
  }
  return NULL;
}

//-----------------------------------------------------------------------------
static mode_skip_update_network = 0;

int
main_draw()
{
  if (mode_skip_update_network)
    return 0;

  CZNode::CZCalc();
  CZNode::CZSetPoint();
  
  if (debug_process_main_draw) {
    proc_main->dump_member(0);
    proc_main->dump_children(0);
  }

  animate();

  return 0;
}

static void
animate()
{
  if (mode_draw_links_always) {
    CZNode::CZShow();
  } else {
    remove_links();
    CZNode::CZShow();
    draw_links();
  }
}  

static int mode_links_with_flicker = 0;

/*static*/ void
remove_links()
{
  if (mode_links_with_flicker)
    ;
  else {
    if (rlinks.Valid())
     rlinks.Destroy();
  }
}

/*static*/ void
draw_links()
{
  rproc *root = proc_main;	// XXX

  if (! mode_draw_links)
    return;			// XXX

  if (mode_links_with_flicker)
    if (rlinks.Valid())
      rlinks.Destroy();
  rlinks = Am_Group.Create("links")
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, 0)
    .Set(Am_WIDTH,  Am_Width_Of_Parts)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
    ;
  window_draw(BINDER_PART, rlinks);
//  Am_Initialize_Inspector(rlinks);
  root->draw_links();
}

void
My_Goal_Modify(Am_Object process)
{
  Am_Value_List slots = Proc_Ports(process);
  Am_Object port;
  for (slots.Start(); !slots.Last(); slots.Next()) {
    port = slots.Get();
    port.Set(PORT_OPEN, KL_Open);
  }
  slots.Start();
}

/* eof */
