// Copyright (C) 1996,1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet/am_io.h>

#if defined(SHORT_NAMES)
#include <amulet/widgts_a.h>
#include <amulet/std_slot.h>
#include <amulet/val_lst.h>
#include <amulet/object_a.h>	// for Am_Slot_Advanced
#include <amulet/opal_a.h>	// for Am_DRAWONABLE, Am_Window_Coordinate
#else
#include <amulet/widgets_advanced.h>
#include <amulet/standard_slots.h>
#include <amulet/value_list.h>
#include <amulet/object_advanced.h> // for Am_Slot_Advanced
#include <amulet/opal_advanced.h> // for Am_DRAWONABLE, Am_Window_Coordinate
#endif

#include <amulet/gem.h>
#include <amulet/inter.h>
#include <amulet/opal.h>
#include <amulet/widgets.h>

#include <math.h>
#include "my_amulet.h"

/* ---------------- Useful functions ------------------ */

void Am_Center_Of_Object(Am_Object obj, int& cx, int& cy)
{
  int x = obj.Get(Am_LEFT);
  int y = obj.Get(Am_TOP);
  int width = obj.Get(Am_WIDTH);
  int height = obj.Get(Am_HEIGHT);

  cx = x + width  / 2;
  cy = y + height / 2;
}
  

/* ---------------- Opal ---------------- */

void get_fixed_sizes (Am_Object self, Am_Value_List& components,
		      Am_Constraint_Context& cc,
		      int& fixed_width, int& fixed_height);

void get_max_rank_and_size (Am_Object self, Am_Constraint_Context& cc,
			    int& max_rank, int& max_size);

void find_line_size_and_rank (Am_Value_List& components, int indent,
			      int fixed_primary, Am_Slot_Key primary_slot,
			      int primary_spacing, Am_Slot_Key secondary_slot,
			      int max_rank, int max_size,
			      int& rank, int& max_secondary);

Am_Define_Formula (int, my_Am_Horizontal_Layout)
{
  Am_Value_List components;
  components = self.GV (Am_GRAPHICAL_PARTS);
  Am_Object component;
  for (components.Start(); !components.Last(); components.Next()) {
    component = components.Get();
    if (!(bool)component.GV(Am_VISIBLE)) components.Delete();
  }
  int fixed_width, fixed_height;
  get_fixed_sizes (self, components, cc, fixed_width, fixed_height);
  int max_rank, max_size;
  get_max_rank_and_size (self, cc, max_rank, max_size);
  int x_offset = self.GV (Am_X_OFFSET);
  int y_offset = self.GV (Am_Y_OFFSET);
  int left = x_offset;
  int top = y_offset;
  int h_spacing = self.GV (Am_H_SPACING);
  int v_spacing = self.GV (Am_V_SPACING);
  int h_align = self.GV (Am_H_ALIGN);
  int v_align = self.GV (Am_V_ALIGN);
  int indent = self.GV (Am_INDENT);
  components.Start ();
  while (!components.Last ()) {
    int line_rank;
    int line_height;
    find_line_size_and_rank (components, left, fixed_width, Am_WIDTH,
			     h_spacing, Am_HEIGHT, max_rank, max_size,
			     line_rank, line_height);
    int rank = 0;
    while (rank < line_rank) {
      Am_Object item;
      item = components.Get ();
      if ((bool)item.GV (Am_VISIBLE)) {
        int width = item.GV (Am_WIDTH);
        int height = item.GV (Am_HEIGHT);
	if (fixed_width) {
	  switch (h_align) {
	  case Am_LEFT_ALIGN:
            item.Set (Am_LEFT, left);
	    break;
	  case Am_RIGHT_ALIGN:
            item.Set (Am_LEFT, left + fixed_width - width);
	    break;
	  default:
            item.Set (Am_LEFT, left + (fixed_width - width) / 2);
	    break;
	  }
	}
	else
	  item.Set (Am_LEFT, left);
        switch (v_align) {
	case Am_TOP_ALIGN:
          item.Set (Am_TOP, top);
	  break;
	case Am_BOTTOM_ALIGN:
          item.Set (Am_TOP, top + (fixed_height ? fixed_height : line_height)
		     - height);
	  break;
	default:
          item.Set (Am_TOP, top + ((fixed_height ? fixed_height: line_height)
				    - height) / 2);
	  break;
	}
        left += (fixed_width ? fixed_width : width) + h_spacing;
        ++rank;
      }
      components.Next ();
    }
    while(!components.Last()) {
      Am_Object item = (Am_Object)components.Get();
      if (!(bool)item.GV(Am_VISIBLE)) {
	components.Next();
      } else
	break;
    }
    top += (fixed_height ? fixed_height : line_height) + v_spacing;
    left = x_offset + indent;
  }
  return 0;
}

void rev_find_line_size_and_rank (Am_Value_List& components, int indent,
				  int fixed_primary, Am_Slot_Key primary_slot,
				  int primary_spacing, Am_Slot_Key secondary_slot,
				  int max_rank, int max_size,
				  int& rank, int& max_secondary)
{
  Am_Object start_item;
  start_item = components.Get ();
  rank = 0;
  max_secondary = 0;
  int position = indent;
  while (!components.First ()) {
    Am_Object item;
    item = components.Get ();
    if ((bool)item.Get (Am_VISIBLE)) {
      int primary = item.Get (primary_slot);
      int secondary = item.Get (secondary_slot);
      if (rank &&
	  ((max_rank && (rank == max_rank)) ||
	   (max_size &&
	    ((position + (fixed_primary ? fixed_primary : primary)) >=
	     max_size))))
	break;
      ++rank;
      position += (fixed_primary ? fixed_primary : primary) + primary_spacing;
      if (secondary > max_secondary)
        max_secondary = secondary;
    }
    components.Prev ();
  }
  components.Start ();
  components.Member (start_item);
}

Am_Define_Formula (int, Am_Horizontal_Rev_Layout)
{
  Am_Value_List components;
  components = self.GV (Am_GRAPHICAL_PARTS);
  Am_Object component;
  for (components.Start(); !components.Last(); components.Next()) {
    component = components.Get();
    if (!(bool)component.GV(Am_VISIBLE)) components.Delete();
  }
  int fixed_width, fixed_height;
  get_fixed_sizes (self, components, cc, fixed_width, fixed_height);
  int max_rank, max_size;
  get_max_rank_and_size (self, cc, max_rank, max_size);
  int x_offset = self.GV (Am_X_OFFSET);
  int y_offset = self.GV (Am_Y_OFFSET);
  int left = x_offset;
  int top = y_offset;
  int h_spacing = self.GV (Am_H_SPACING);
  int v_spacing = self.GV (Am_V_SPACING);
  int h_align = self.GV (Am_H_ALIGN);
  int v_align = self.GV (Am_V_ALIGN);
  int indent = self.GV (Am_INDENT);
  components.End ();
  while (!components.First ()) {
    int line_rank;
    int line_height;
    rev_find_line_size_and_rank (components, left, fixed_width, Am_WIDTH,
				 h_spacing, Am_HEIGHT, max_rank, max_size,
				 line_rank, line_height);
    int rank = 0;
    while (rank < line_rank) {
      Am_Object item;
      item = components.Get ();
      if ((bool)item.GV (Am_VISIBLE)) {
        int width = item.GV (Am_WIDTH);
        int height = item.GV (Am_HEIGHT);
	if (fixed_width) {
	  switch (h_align) {
	  case Am_LEFT_ALIGN:
            item.Set (Am_LEFT, left);
	    break;
	  case Am_RIGHT_ALIGN:
            item.Set (Am_LEFT, left + fixed_width - width);
	    break;
	  default:
            item.Set (Am_LEFT, left + (fixed_width - width) / 2);
	    break;
	  }
	}
	else
	  item.Set (Am_LEFT, left);
        switch (v_align) {
	case Am_TOP_ALIGN:
          item.Set (Am_TOP, top);
	  break;
	case Am_BOTTOM_ALIGN:
          item.Set (Am_TOP, top + (fixed_height ? fixed_height : line_height)
		     - height);
	  break;
	default:
          item.Set (Am_TOP, top + ((fixed_height ? fixed_height: line_height)
				    - height) / 2);
	  break;
	}
        left += (fixed_width ? fixed_width : width) + h_spacing;
        ++rank;
      }
      components.Prev ();
    }
    while(!components.First()) {
      Am_Object item = (Am_Object)components.Get();
      if (!(bool)item.GV(Am_VISIBLE)) {
	components.Prev();
      } else
	break;
    }
    top += (fixed_height ? fixed_height : line_height) + v_spacing;
    left = x_offset + indent;
  }
  return 0;
}

Am_Slot_Key Am_ARROW_LENGTH = Am_Register_Slot_Name("Am_ARROW_LENGTH");
Am_Slot_Key Am_ARROW_WIDTH = Am_Register_Slot_Name("Am_ARROW_WIDTH");

void My_Opal_Initialize(void)
{
  Am_Horizontal_Layout = my_Am_Horizontal_Layout;
}
/* ---------------- Widgets ---------------- */

extern Am_Formula Am_Get_Computed_Colors_Record_Form;

void Am_Draw_Motif_Round_Box(int left, int top, int width, int height,
			     int radius, bool depressed,
			     const Computed_Colors_Record& rec, Am_Drawonable* draw)
{
  Am_Style top_fill;
  Am_Style bot_fill;
  Am_Style inside_fill;
  if (depressed) {
    top_fill = rec.data->shadow_style;
    bot_fill = rec.data->highlight_style;
    inside_fill = rec.data->background_style;
  }
  else {
    top_fill = rec.data->highlight_style;
    bot_fill = rec.data->shadow_style;
    inside_fill = rec.data->foreground_style;
  }
  //top edges
  draw->Draw_Roundtangle(Am_No_Style, top_fill, left, top, width, height,
			 radius, radius);
  //bottom edges
  draw->Draw_Roundtangle(Am_No_Style, bot_fill, left + 1, top + 1, width-1,
			 height-1, radius, radius);
  //inside of box
  draw->Draw_Roundtangle(Am_No_Style, inside_fill, left+1, top+1, width-2,
			 height-2, radius, radius);
}

// draw routine for a plain border'ed round rectangle. added by toyoda
Am_Define_Method(Am_Draw_Method, void, border_roundtangle_draw,
		 (Am_Object self, Am_Drawonable* drawonable,
		  int x_offset, int y_offset))
{
  int left = (int)self.Get (Am_LEFT) + x_offset;
  int top = (int)self.Get (Am_TOP) + y_offset;
  int width = self.Get (Am_WIDTH);
  int height = self.Get (Am_HEIGHT);
  int radius = self.Get(Am_DRAW_RADIUS);
  bool selected = self.Get (Am_SELECTED);
  Computed_Colors_Record rec = self.Get(Am_STYLE_RECORD);
  Am_Widget_Look look = (Am_Widget_Look)(int)self.Get (Am_WIDGET_LOOK);
  if (look == Am_MOTIF_LOOK)
    Am_Draw_Motif_Round_Box(left, top, width, height, radius, selected, rec, drawonable);
  else
    Am_Error("Sorry, only the Motif Style implemented for now");
}

// exported objects

Am_Object Am_Border_Roundtangle;

void My_Widgets_Initialize () {
  Am_Object_Advanced obj_adv; // to get at advanced features like
			       // local-only and demons.

  //////////// border round rectangle ////////////
  Am_Border_Roundtangle = Am_Roundtangle.Create("Border_Roundtangle")
    .Set (Am_SELECTED, false)
    .Set (Am_WIDGET_LOOK, (int)Am_MOTIF_LOOK)
    .Set (Am_STYLE_RECORD, Am_Get_Computed_Colors_Record_Form)
    .Set (Am_WIDTH, 50)
    .Set (Am_HEIGHT, 50)
    .Set (Am_FILL_STYLE, Am_Motif_Light_Blue)
    .Set (Am_DRAW_METHOD, border_roundtangle_draw)
    ;
  
  obj_adv = (Am_Object_Advanced&)Am_Border_Roundtangle;
  obj_adv.Get_Slot (Am_RADIUS)
    .Set_Demon_Bits (Am_MOVING_REDRAW | Am_EAGER_DEMON);
  obj_adv.Get_Slot (Am_DRAW_RADIUS)
    .Set_Demon_Bits (Am_MOVING_REDRAW | Am_EAGER_DEMON);
  obj_adv.Get_Slot (Am_SELECTED)
    .Set_Demon_Bits (Am_STATIONARY_REDRAW | Am_EAGER_DEMON);
  obj_adv.Get_Slot (Am_WIDGET_LOOK)
    .Set_Demon_Bits (Am_STATIONARY_REDRAW | Am_EAGER_DEMON);
  obj_adv.Get_Slot (Am_FILL_STYLE)
    .Set_Demon_Bits (Am_STATIONARY_REDRAW | Am_EAGER_DEMON);
    
}

extern Computed_Colors_Record black_and_white_rec;
extern Computed_Colors_Record_Data black_and_white_rec_data;

Am_Define_Formula (Am_Wrapper*, my_Am_Get_Computed_Colors_Record_Form)
{
  Am_Style foreground_color;
  Am_Value value;
  bool is_color = true;
  self.GVM (Am_FILL_STYLE, value);
  if (Am_Type_Class (value.type) == Am_WRAPPER)
    foreground_color = value;
  Am_Object window;
  window = self.GV(Am_WINDOW);
  if (window.Valid ()) {
    Am_Drawonable* draw = Am_Drawonable::Narrow (window.GV (Am_DRAWONABLE));
    is_color = !draw || draw->Is_Color();
  }
  if (is_color)
    return Computed_Colors_Record (foreground_color);
  else
    return black_and_white_rec;
}

/* ---------------- Initialize ---------------- */

void My_Amulet_Initialize(void)
{
  Am_Get_Computed_Colors_Record_Form = my_Am_Get_Computed_Colors_Record_Form;
  My_Opal_Initialize();
  My_Widgets_Initialize();
}

// eof
