// Copyright (C) 1996,1997 Buntarou Shizuki(shizuki@is.titech.ac.jp)

#include "parse.h"

static int parse_file(char *path);

int tracing_mode;

int
main(int argc, char **argv)
{
  char *program_name = argv[0];

  if (argc != 2 && argc != 4) {
    fprintf(stderr, "Usage: %s file\n", program_name);
    fprintf(stderr, "    or %s -l logfile file\n", program_name);
    return 1;
  }

  char *input_file;
  char *log_file;

#if defined(HAVE_PTY)
  if (argc == 2) {
    input_file = argv[1];
    tracing_mode = TRACE_OBJECT;
  }
#endif
  if (argc == 4) {
    if (argv[1][0] == '-' && argv[1][1] == 'l') {
      log_file = argv[2];
      input_file = argv[3];
      tracing_mode = TRACE_LOGFILE;
    } else {
      fprintf(stderr, "Wrong Option\n");
      return 1;
    }
  }

  //
  // initialization
  //
  initProcRegister();
  subprocess_init();
  window_create();
  int ret = parse_file(input_file);

  if (debug_process_definition)
    dumpProcs();

  if (tracing_mode == TRACE_OBJECT)
    subprocess_compile(input_file);
  else
    subprocess_openlog(log_file);
  env_init();
  window_init();

  //
  // main event loop
  //
  window_main();

  window_clean();
  subprocess_clean();
    
  exit(0);
}

static int
parse_file(char *path)
{
  return fghc_parse(path);
}

/* eof */
