#include <amulet.h>
#include "ToyWidgets.h"

// ------------------------------------------------------------
// Zooming Text
// ------------------------------------------------------------

Am_Font FontTable[NofFontFamilies][2][2][NofFontSizes];

Am_Object ZoomingText = 0;
// public
DEFINE_SLOT(TextPart);
DEFINE_SLOT(FontFamily);
DEFINE_SLOT(FontIsBold);
DEFINE_SLOT(FontIsItalic);
DEFINE_SLOT(FontIsUnderline);


char* make_font_name(int family, bool is_bold, bool is_italic, int size)
{
  char* wild_font_name = new char[50];  // Given hard-coded defaults, max length is 50
  char *family_part, *face_part;

  switch(family) {
  case FontFixed:      family_part = "courier"; break;
  case FontSerif:      family_part = "times"; break;
  case FontSansSerif:  family_part = "helvetica"; break;
  }
  
  if((is_bold == false) && (is_italic == false))
    face_part = "medium-r";
  else if ((is_bold == true) && (is_italic == false))
    face_part = "bold-r";
  else if ((is_bold == false) && (is_italic == true)) {
    if (family == Am_FONT_SERIF) face_part = "medium-i";
    else face_part = "medium-o";
  }
  else if ((is_bold == true) && (is_italic == true)) {
    if (family == Am_FONT_SERIF) face_part = "bold-i";
    else face_part = "bold-o";
  }
  // Guide to fonts.dir format (try xfontsel on an HP):
  // -fndry-fmly-weight-slant-sWidth-adstyl-pixelsize-pointsize-...
  // ...resx-resy-spc-avgWdth-registry-encoding
  sprintf(wild_font_name, "-*-%s-%s-*-*-%i-*-*-*-*-*-*-*", family_part, face_part, size);
  //  printf("fontname = %s\n", wild_font_name);
  return wild_font_name;
}

Am_Define_Formula(int, ResizeTextForm) {
//  printf("Entering ResizeTextForm...\n");

  const int sizeList[NofFontSizes] = FontSizes;

  int  family       = self.GV(FontFamily);
  bool is_bold      = self.GV(FontIsBold);
  bool is_italic    = self.GV(FontIsItalic);
  bool is_underline = self.GV(FontIsUnderline);

  Am_Font* fontList = FontTable[family][is_bold][is_italic];
  if ((void *)fontList[0] == (void *)0) {
    for (int i = 0; i < NofFontSizes; ++i) {
      fontList[i] = Am_Font(make_font_name(family, is_bold, is_italic, sizeList[i]));
    }
  }

  int w = self.GV(Am_WIDTH);
  int h = self.GV(Am_HEIGHT);
  Am_Object textObj = self.Get_Part(TextPart);

  for (int i = 0; i < NofFontSizes; ++i) {
    textObj.Set(Am_FONT, fontList[i]);
    int tw = textObj.GV(Am_WIDTH);
    int th = textObj.GV(Am_HEIGHT);
//     printf("text = (%d, %d) and font size(%d) = (%d, %d)\n", 
// 	   w, h, sizeList[i], tw, th);
    if (tw <= w && th <= h) return 0;
  }
  return 0;
}

void Initialize_ZoomingText(void)
{
  bzero((void*) &FontTable, sizeof(FontTable));

  Am_Object textObj = Am_Text.Create("ZoomingTextPart")
    .Set_Single_Constraint_Mode(Am_TEXT, false);

  ZoomingText = Am_Group.Create("ZoomingText")
    .Set(FontFamily, FontFixed)
    .Set(FontIsBold, false)
    .Set(FontIsItalic, false)
    .Set(FontIsUnderline, false)
    .Set(Am_LAYOUT, ResizeTextForm)
    .Set(Am_TEXT, "")
    .Add_Part(TextPart, textObj
	      .Set(Am_TEXT, Am_From_Owner(Am_TEXT))
	      .Set(Am_LEFT, Am_Center_X_Is_Center_Of_Owner)
	      .Set(Am_TOP,  Am_Center_Y_Is_Center_Of_Owner))
    ;
}

// eof
