// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>

#include "ToyWidgets.h"
#include "PovlWidgets.h"
#include "Resources.h"
#include "Module.h"
#include "Process.h"
#include "Pattern.h"
#include "Port.h"
#include "Message.h"
#include "Guard.h"

// ------------------------------------------------------------
// Process Prototype
// ------------------------------------------------------------

// Global objects

Am_Object RuleProto = 0;
Am_Object NetworkRuleProto = 0;
Am_Object TransitionRuleProto = 0;

// Methods

Am_Define_Method(Copy_Method, Am_Object, New_Rule, (Am_Object net))
{
  Am_Object new_net = net.Create()
    .Set(Am_WIDTH, 60)
    .Set(Am_HEIGHT, 60)
    ;
  return new_net;
}

void rule_add_port(Am_Object rule, Am_Object orig_port)
{
  int mode = (int)orig_port.Get(Mode);
  Am_Object new_port = Align_Zoom_Create_Part(orig_port);
  Disable_Name_Edit(new_port);
  Change_Menu(new_port, ProcessPortMenuPopper.Create());
  new_port
    .Set(Age, PortOld)   // old port$B$K$9$k!#(B
    .Set(Mode, 1 - mode) // mode $B$NH?E>(B
    ;

  Am_Object dist_agg = rule.Get_Part(ContentsPart);
  dist_agg.Add_Part(new_port);

  Am_Object model = orig_port.Get(Model); // Transition $B$N$P$"$$(Bnew port$B$bDI2C!#(B
  if (rule.Is_Instance_Of(TransitionRuleProto) &&
      (int)model.Get(Type) == PortSingleton &&
      (int)orig_port.Get(Mode) == PortInput) {
      Am_Object new_port = Align_Zoom_Create_Part(orig_port);
      Disable_Name_Edit(new_port);
      Change_Menu(new_port, ProcessPortMenuPopper.Create());
      dist_agg.Add_Part(new_port);
  }
}

Am_Object Rule_Create(Am_Object process, Am_Object rule_proto) {
  Am_Object rule = CALL1(rule_proto, Copy_Method, NewMethod);
  // $B?F%W%m%;%9(B,$B%b%G%k;XDj!%(B
  rule.Set(Process, process)
      .Set(Model, process.Get_Object(Model))
    ;
  // $B%]!<%HDI2C!%(B
  Am_Value_List ports = process.Get(PortList);
  Am_Object dist_agg = rule.Get_Part(ContentsPart);
  dist_agg.Set(Am_ACTIVE, false);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object pt = ports.Get();
    rule_add_port(rule, pt);
  }
  dist_agg.Set(Am_ACTIVE, true);
  return rule;
}

Am_Define_Method(Bin_Check_Method, bool, Rule_Add, (Am_Object rule, Am_Object obj))
{
  if (obj.Is_Instance_Of(GuardProto)) {
    rule.Get_Part(ContentsPart).Add_Part(obj);
    return true;
  }
  if (obj.Is_Instance_Of(PortProto)) {
    rule_add_port(rule, obj);
    return true;
  }
  if (obj.Is_Instance_Of(ProcessProto) || obj.Is_Instance_Of(PatternProto)) {
    rule.Get_Part(ContentsPart).Add_Part(obj);
    return true;
  }
  cerr << "Can't add " << obj << " to " << rule << endl;
  return false;
}

Am_Define_Method(Bin_Check_Method, bool, Rule_Remove, (Am_Object rule, Am_Object obj))
{
  if (obj.Is_Instance_Of(GuardProto)) {
    rule.Get_Part(ContentsPart).Remove_Part(obj);    
    return true;
  }
  if (obj.Is_Instance_Of(PortProto)) {
    //    Remove_All_Binder(port);
    rule.Get_Part(ContentsPart).Remove_Part(obj);
    return true;
  }
  if (obj.Is_Instance_Of(ProcessProto)) {
    //    Remove_All_Binder(port);
    rule.Get_Part(ContentsPart).Remove_Part(obj);
    return true;
  }

  if (obj.Is_Instance_Of(PatternProto)) {
    //    Remove_All_Binder(port);
    rule.Get_Part(ContentsPart).Remove_Part(obj);
    return true;
  }
  return false;
}

Am_Define_Method(Bin_Check_Method, bool, Rule_Check_Drop, (Am_Object source, Am_Object target))
{
  Am_Object group = target.Get_Part(ContentsPart);
  if (source == target) return false;
  if (source.Get_Owner() == group) return false;
  if (target.Is_Part_Of(source)) return false;
  return true;
}

Am_Define_Method(Drop_Method, bool, Rule_Drop, (Am_Object source, Am_Object target, Am_Object cmd))
{
  Am_Object group = target.Get_Part(ContentsPart);
  //  cout << "dropping " << source << " in " << source.Get_Owner() << " into " << group << endl;
  Am_Inter_Location new_loc = cmd.Get(Am_VALUE);
  Am_Inter_Location old_loc = cmd.Get(Am_OLD_VALUE);

  bool as_line;
  Am_Object nref, oref;
  int nx, ny, ox, oy, w, h;
  new_loc.Get_Location(as_line, nref, nx, ny, w, h);
  old_loc.Get_Location(as_line, oref, ox, oy, w, h);
  Am_Translate_Coordinates(nref, nx, ny, group, nx, ny);

  Am_Object copy = source.Create()
    .Set(Am_LEFT, nx)
    .Set(Am_TOP, ny);
  group.Add_Part(copy);

  return true;
}



// Formulas

void inner_port_search(Am_Constraint_Context& cc, Am_Object port, Am_Value_List& list)
{
  Am_Value_List values = port.GV(ValueList);
  for (values.Start(); !values.Last(); values.Next()) {
    Am_Object val = values.Get();
    if (val.Is_Instance_Of(PortProto)) {
      Am_String val_name = val.GV_Object(Model).GV(Name);
      if (!Object_List_Get_By_Model_Key(list, Name, val_name).Valid())
	list.Add(val);
    }
    if (val.Is_Instance_Of(PortProto) || val.Is_Instance_Of(MessageProto))
      inner_port_search(cc, val, list);
  }
}

Am_Define_Value_List_Formula (InnerPortListForm) {
  Am_Value_List list = Am_Value_List();
  // search rule ports
  Am_Value_List ports = self.GV(PortList);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object pt = (Am_Object)ports.Get();
    if (pt.Is_Instance_Of(PortProto)) inner_port_search(cc, pt, list);
  }
  // search process ports
  Am_Value_List procs = self.GV(ProcessList);
  for (procs.Start(); !procs.Last(); procs.Next()) {
    Am_Object pr = procs.Get();
    if (pr.Is_Instance_Of(ProcessProto)) {
      Am_Value_List ports = pr.GV(PortList);
      for (ports.Start(); !ports.Last(); ports.Next()) {
	Am_Object pt = (Am_Object)ports.Get();
	if (pt.Is_Instance_Of(PortProto)) inner_port_search(cc, pt, list);
      }
    }
  }
  return list;
}

Am_Define_Value_List_Formula(GoalListForm)
{
  Am_Value_List list = Am_Value_List();
  Am_Value_List parts = ContentsListForm(cc, self);
  for (parts.Start(); !parts.Last(); parts.Next()) {
    Am_Object p = parts.Get();
    if (p.Is_Instance_Of(ProcessProto)) list.Add(p);
    if (p.Is_Instance_Of(PatternProto)) list.Add(p);
  }
  return list;
}

Am_Define_Formula(bool, RuleVisibleForm)
{
  return (bool)self.GV_Object(Model).GV(RuleVisible);
  /*  
  Am_Object owner = self.GV_Owner();
  if (!owner.Valid()) return false;
  Am_Value_List parts = owner.GV(Am_GRAPHICAL_PARTS);
  if (!parts.Valid()) return false;
  int number = parts.Length();
  // if (owner.Get_Slot_Type(numberThreshold) == Am_UNINIT) return false;
  //  if (!owner.GV(numberThreshold).Valid()) return false;
  int num_threshold = owner.GV(numberThreshold);
  if (number > (num_threshold - 5)) return false;
  return true;
  */
}

// Hyper Link List Formula
// ----------------------------------------------------------------------
Am_Define_Value_List_Formula(HyperLinkListForm)
{
  Am_Value_List links = Am_Value_List();

  Am_Value_List procs = self.GV(ProcessList);
  for (procs.Start(); !procs.Last(); procs.Next()) {
    Am_Object p = procs.Get();
    p.GV(Am_ACTIVE); // interface$B$,$J$/$J$C$F$$$J$$$+%A%'%C%/!#(B
    Am_Object interface = Process_Get_Interface(p);
    if (interface.Valid()) links.Add(interface);
  }
  return links;
}

void initRuleProto(void) {
  Am_Object name = ZoomingText.Create("RuleName")
    .Get_Part(TextPart).Set(Am_TEXT, ModelNameForm).Get_Owner()
    .Set(FontFamily, FontSansSerif)
    .Set(FontIsBold, true)
    .Set(NameHeightMax, GetResourceForm(NameHeightMax))
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, NameHeightForm)
    ;

  Am_Object network_frame = Am_Rectangle.Create("NetworkRuleFrame")
    .Set(Am_TOP, Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))     
    .Set(Am_HEIGHT, Am_From_Sibling(ContentsPart, Am_HEIGHT)) //$B$J$<(BFill_To_Bottom$B$G$&$^$/$$$+$J$$$s$@!<(B!
    .Set(Am_LINE_STYLE, Am_Line_2) // $BCf?H$,$J$$$H$-$OE@@~$K$9$k!#(B
    .Set(Am_FILL_STYLE, GetResourceForm(ProcessFill))
    ;

  Am_Object transition_frame = Am_Border_Rectangle.Create("TransitionRuleFrame")
    .Set(Am_TOP, Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))     
    .Set(Am_HEIGHT, Am_From_Sibling(ContentsPart, Am_HEIGHT)) //$B$J$<(BFill_To_Bottom$B$G$&$^$/$$$+$J$$$s$@!<(B!
    .Set(Am_FILL_STYLE, GetResourceForm(TransitionRuleFill))
    ;

  Am_Object contents = PovlContents.Create("RuleContents")
    .Set(Am_TOP,    Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH,  Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Fill_To_Bottom)
    ;

  Am_Object binders_part = PovlGroup.Create("BindersPart")
    .Set(Am_VISIBLE, SelfVisibleForm)
    .Set(Am_TOP,    Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Fill_To_Bottom)
    ;

  RuleProto = PovlGroup.Create("RuleProto")
    // Attributes
    .Set(Parent, ParentForm)
    .Set(Process, 0)
    .Set(Model, ProcessModel)
    // Methods
    .Set(NewMethod, New_Rule)
    .Set(AddMethod, Rule_Add)
    .Set(RemoveMethod, Rule_Remove)    
    .Set(CheckDropMethod, Rule_Check_Drop)
    .Set(DropMethod, Rule_Drop)
    // Graphics
    .Set_Single_Constraint_Mode(Am_WIDTH, false)
    .Set_Single_Constraint_Mode(Am_HEIGHT, false)
    .Set(Am_WIDTH,  80)
    .Set(Am_HEIGHT, 30)
    .Set(Am_VISIBLE, RuleVisibleForm)
    .Add_Part(NamePart, name)
    ;

  NetworkRuleProto = RuleProto.Create("NetworkRuleProto")
    // Attributes
    .Set(Model, ProcessModel.Copy().Set(Name, "Network Rule"))
    .Set(Type, NetworkRule)
    // Lists
    .Set(PortList, InstanceListForm(PortProto))
    .Set(PortNameList, NameListForm(PortList))
    .Set(GuardList, InstanceListForm(GuardProto))
    .Set(ProcessList, GoalListForm)
    .Set(HoleList, InstanceListForm(HoleProto))
    .Set(InnerPortList, InnerPortListForm)
    .Set(InnerPortNameList, NameListForm(InnerPortList))
    .Set(hyperLinks, HyperLinkListForm)
    // Graphics
    .Add_Part(FramePart, network_frame)
    .Add_Part(ContentsPart, contents)
    .Add_Part(BindersPart, binders_part)
    .Set(Am_WIDTH, Am_From_Part(ContentsPart, Am_WIDTH))
    .Set(Am_HEIGHT, PovlGroupHeightForm)
    ;

  TransitionRuleProto = RuleProto.Create("TransitionRuleProto")
    // Attributes
    .Set(Model, ProcessModel.Copy().Set(Name, "Transition Rule"))
    .Set(Type, TransitionRule)
    // Lists
    .Set(PortList, InstanceListForm(PortProto))
    .Set(PortNameList, NameListForm(PortList))
    .Set(GuardList, InstanceListForm(GuardProto))
    .Set(ProcessList, InstanceListForm(ProcessProto))
    .Set(HoleList, InstanceListForm(HoleProto))
    .Set(InnerPortList, InnerPortListForm)
    .Set(InnerPortNameList, NameListForm(InnerPortList))
    // Graphics
    .Add_Part(FramePart, transition_frame)
    .Add_Part(ContentsPart, contents.Create())
    .Add_Part(BindersPart, binders_part.Create())
    .Set(Am_WIDTH, Am_From_Part(ContentsPart, Am_WIDTH))
    .Set(Am_HEIGHT, PovlGroupHeightForm)
    ;
}

// ------------------------------------------------------------
// Rule Menu
// ------------------------------------------------------------

Am_Define_Formula(bool, MainRuleInactiveForm)
{
  Am_Object menu = self.GV_Owner().GV_Owner(); // $B%a%K%e!<(B
  Am_Object target = menu.GV(TargetObj); // $BDI2C@h(B
  if (!target.Valid()) return false;
  if (target.Is_Instance_Of(MainRuleProto)) return false;
  return true;
}

void initRuleMenu(void)
{
  Am_Object RuleMenu = PopUpMenu.Create("RuleMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, TargetNameForm))
	 .Add(Am_Menu_Line_Command.Create())
	 //	 .Add(UndoZoomCmd.Create())
	 //	 .Add(RedoZoomCmd.Create())
	 //	 .Add(SelectiveUndoZoomCmd.Create())
	 .Add(PovlOrigSizeCmd.Create())
	 .Add(PovlEditSizeCmd.Create())
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, GuardProto)
	      .Set(Am_ACTIVE, MainRuleInactiveForm))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete")
	      .Set(Am_ACTIVE, MainRuleInactiveForm))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(RuleMenu);

  Am_Object RuleMenuPopper = PopUpMenuInteractor.Create("RuleMenuPopper")
    .Set(MenuWindow, RuleMenu)
    ;
  NetworkRuleProto.Add_Part(RuleMenuPopper);
  TransitionRuleProto.Add_Part(RuleMenuPopper.Create());
}


// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void InitializeRule(void)
{
  initRuleProto();
  initRuleMenu();
}
