// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>
#include FORMULA_ADVANCED__H

#include "ToyWidgets.h"
#include "PovlWidgets.h"

// ------------------------------------------------------------
// Global Resources
// ------------------------------------------------------------

// Global Resources Object
Am_Object PovlResources = 0;

// Resource Slots

DEFINE_SLOT(ModuleFill);
DEFINE_SLOT(PortNewFill);
DEFINE_SLOT(PortOldFill);
DEFINE_SLOT(PortSpecialFill);
DEFINE_SLOT(PortNewTextFill);
DEFINE_SLOT(PortOldTextFill);
DEFINE_SLOT(PortMarkerOpenFill);
DEFINE_SLOT(PortMarkerCloseFill);
DEFINE_SLOT(PortWidthMargin);
DEFINE_SLOT(PortHeightMargin);
DEFINE_SLOT(ProcessMargin);
DEFINE_SLOT(ProcessFill);
DEFINE_SLOT(ProcessInvalidFill);
DEFINE_SLOT(TransitionRuleFill);
DEFINE_SLOT(AtomFill);
DEFINE_SLOT(AtomWidthMargin);
DEFINE_SLOT(AtomHeightMargin);
DEFINE_SLOT(MessageFill);
DEFINE_SLOT(StructWidthMargin);
DEFINE_SLOT(StructHeightMargin);
DEFINE_SLOT(GuardFill);
DEFINE_SLOT(GuardWidthMargin);
DEFINE_SLOT(GuardHeightMargin);
DEFINE_SLOT(BinderLine);
DEFINE_SLOT(BinderFill);
DEFINE_SLOT(BindMargin);
DEFINE_SLOT(ImplDialogFont);

// Formulas
// --------------------------------------------------
static void get_resource_procedure(Am_Constraint_Context& cc, Am_Object& self, Am_Value& value)
{
  Am_Slot_Key slot_key = (Am_Slot_Key)cc.Get_Data ();
  value = PovlResources.GV(slot_key);
}

Am_Constraint* GetResourceForm(Am_Slot_Key key)
{
  Am_Formula_Advanced* formula = (Am_Formula_Advanced*)(Am_Constraint*)
      Am_Formula (get_resource_procedure, "GetResourceForm");
  formula->Set_Data ((void*)key, NULL);
  return formula;
}

void InitializeResources(void)
{
  PovlResources = Am_Root_Object.Create()
    .Set(ModuleFill,		Am_Amulet_Purple)
    .Set(PortNewFill,		Am_Motif_Light_Gray)
    .Set(PortOldFill,		Am_Motif_Light_Orange)
    .Set(PortSpecialFill,	Am_White)
    .Set(PortNewTextFill,	Am_Black)
    .Set(PortOldTextFill,	Am_White)
    .Set(PortMarkerOpenFill,	Am_Green)
    .Set(PortMarkerCloseFill,	Am_Red)
    .Set(PortWidthMargin,	2)
    .Set(PortHeightMargin,	2)
    .Set(ProcessMargin,		4)
    .Set(ProcessFill,		Am_Motif_Light_Gray)
    .Set(ProcessInvalidFill,	Am_Motif_Orange)
    .Set(TransitionRuleFill,	Am_Motif_Light_Orange)
    .Set(AtomFill,		Am_White)
    .Set(AtomWidthMargin,	8)
    .Set(AtomHeightMargin,	1)
    .Set(MessageFill,		Am_Motif_Light_Orange)
    .Set(StructWidthMargin,	4)
    .Set(StructHeightMargin,	4)
    .Set(GuardFill,		Am_White)
    .Set(GuardWidthMargin,	4)
    .Set(GuardHeightMargin,	6)
    .Set(BinderLine,	     Am_Style(0, 0, 0, 3, Am_CAP_BUTT, Am_JOIN_MITER,
				      Am_LINE_SOLID, Am_DEFAULT_DASH_LIST,
				      Am_DEFAULT_DASH_LIST_LENGTH,
				      Am_FILL_STIPPLED, Am_FILL_POLY_EVEN_ODD,
				      Am_Image_Array(50)))
    .Set(BinderFill,		Am_Gray_Stipple)
    .Set(BindMargin,		2)
    .Set(ImplDialogFont,	Am_Font(Am_FONT_SANS_SERIF, false, false, false, Am_FONT_LARGE))
    .Set(NameHeightMax,		22)
    ;

  Am_Screen.Add_Part(PovlResources);
}

