// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#ifndef _INTERNAL_

// ------------------------------------------------------------
// Utility functions
// ------------------------------------------------------------

bool Port_Equal(Am_Object port1, Am_Object port2);
// $B%]!<%H$N>uBV$N%A%'%C%/(B
int Port_Outside_Mode(Am_Object port);
bool Port_Has_Value(Am_Object port);
bool Port_Has_Value2(Am_Object port, Am_Object src);
bool Port_Is_Bound(Am_Object port, Am_Object src);
// $B?F$NC5:w(B
Am_Object Port_Top_Parent(Am_Object port);
Am_Object Port_Parent_Proc(Am_Object port);
// $BDI2C!&0\F0$,2DG=$+$r%A%'%C%/(B
bool Port_Add_Allowed(Am_Object src_port, Am_Object des_port);
// $B%]!<%H$N%Q%94XO"(B
Am_Object Position_To_Obj(Am_Object root, Am_Value_List position);
// $B%]!<%H$NAjBPE*$J0LCV$NH=Dj(B
int Port_Side_Check(Am_Object obj_port, Am_Object sub_port);
int Port_Side(Am_Object obj_port, Am_Object sub_port);

// ------------------------------------------------------------
// Formulas
// ------------------------------------------------------------

int Value_Length(Am_Constraint_Context& cc, Am_Object value, int self_count);
extern Am_Formula PortLayoutForm;

// ------------------------------------------------------------
// Objects
// ------------------------------------------------------------

extern Am_Object PortProto;
extern Am_Object InSingletonProto;
extern Am_Object OutSingletonProto;
extern Am_Object InStreamProto;
extern Am_Object OutStreamProto;
extern Am_Object SpecialSingletonProto;
extern Am_Object SpecialStreamProto;
extern Am_Object BroadSingletonProto;
extern Am_Object BroadStreamProto;
extern Am_Object MergeProto;
extern Am_Object MapInProto;
extern Am_Object MapOutProto;
extern Am_Object NodePortProto;

extern Am_Object ProcessPortMenuPopper;

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void InitializePort(void);
#endif

enum PortMode    { PortOutput = 0,    PortInput = 1, PortUnknown = 2 };
enum PortType    { PortSingleton = 0, PortStream = 1 };
enum PortDir     { PortLeft = 0,      PortRight = 1 };
enum PortAge     { PortNew = 0,       PortOld = 1 };
enum PortState   { PortOpen = 0,      PortClose = 1 };
enum PortSpecial { PortNormal = 0, PortMap = 1, PortRecursive = 2,
		   PortBroadcast = 3, PortMerge = 4,
		   PortPatSingleton = 5, PortPatStream = 6,
		   PortNode = 7 };

enum PortSide 	 { PortParentSame = 0, PortGrandSame = 1,
		   PortInside = 2, PortOutside = 3, PortFarAway = 4 };
