// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>
#include OBJECT_ADVANCED__H

#include "ToyWidgets.h"
#include "PovlWidgets.h"
#include "Resources.h"
#include "Module.h"
#include "Process.h"
#include "ProcessMenu.h"
#include "Port.h"
#include "Rule.h"
#include "Binder.h"


// ------------------------------------------------------------
// Process Prototype
// ------------------------------------------------------------

// Global objects

Am_Object PatternModel = 0;
Am_Object PatternProto = 0;
Am_Object ReplPatternProto = 0;

Am_Object LayoutSelectionCmd = 0;
Am_Object LayoutSelectionMenu = 0;
Am_Object LayoutDialog = 0;

// ------------------------------------------------------------
// Utility Functions
// ------------------------------------------------------------

// Binder$B$N%3%T!<(B
// --------------
void pattern_copy_binders(Am_Object pattern)
{
  Am_Value_List binders = pattern.Get_Part(BindersPart).Get(Am_GRAPHICAL_PARTS);
  Am_Object copySrc = pattern.Get(Am_SOURCE_OF_COPY);
  cout << pattern << copySrc << endl;
  for (binders.Start(); !binders.Last(); binders.Next()) {
    Am_Object b = binders.Get();
    Am_Object src = b.Get(SrcPort);
    Am_Object des = b.Get(DestPort);
    //    Am_Object copySrc = Binder_Which_Rule(src, des);
        cout << b << src << des << copySrc << endl;
    Am_Value_List src_path = Obj_To_Path(src, copySrc);
    Am_Value_List des_path = Obj_To_Path(des, copySrc);
        cout << src_path << endl;
        cout << des_path << endl;
    Am_Object my_src = Path_To_Obj(pattern, src_path);
    Am_Object my_des = Path_To_Obj(pattern, des_path);
        cout << my_src << my_des << endl;
    b.Set(SrcPort, my_src)
     .Set(DestPort, my_des);
    src_path.Make_Empty();
    des_path.Make_Empty();
  }
  Am_Value_List children = pattern.Get(ProcessList);
  for (children.Start(); !children.Last(); children.Next()) {
    Am_Object c = children.Get();
    if (c.Is_Instance_Of(PatternProto)) {
      pattern_copy_binders(c);
    }
  }
}

Am_Object Pattern_Copy(Am_Object pattern);

void pattern_copy_proc_hole_link(Am_Object pattern)
{
  Am_Value_List holes = pattern.Get(HoleList);
  for (holes.Start(); !holes.Last(); holes.Next()) {
    Am_Object h = holes.Get();
    Am_Object proc = h.Get(Process);
    if (proc.Valid()) {
      Am_Object new_hole = h.Copy();
      Am_Value_List path = Obj_To_Path(proc, Parent_Rule(proc));
      Am_Object my_proc = Path_To_Obj(pattern, path);
      path.Make_Empty();
      new_hole.Set(Process, my_proc);
      my_proc.Set(Hole, new_hole);

      Am_Value_List impls = h.Get(ProcessList);
      Am_Value_List new_impls = Am_Value_List();
      for (impls.Start(); !impls.Last(); impls.Next()) {
	Am_Object i = impls.Get();
	if (i.Is_Instance_Of(ProcessProto)) new_impls.Add(i.Copy());
	else if (i.Is_Instance_Of(PatternProto)) new_impls.Add(Pattern_Copy(i));
      }
      new_hole.Set(ProcessList, new_impls);
		   
      if (my_proc.Is_Instance_Of(PatternProto))
	pattern_copy_proc_hole_link(my_proc);
    }
  }
}

Am_Object Pattern_Copy(Am_Object pattern)
{
  pattern.Set(Am_ACTIVE, false); // $B0l;~E*$K(BBinder$B$N%l%$%"%&%H$r$d$a$F!">C$5$l$J$$$h$&$K$9$k!#1x$$(B
  Am_Value_List children = pattern.Get(ProcessList);
  for (children.Start(); !children.Last(); children.Next()) {
    Am_Object c = children.Get();
    if (c.Is_Instance_Of(PatternProto)) {
      c.Set(Am_ACTIVE, false);
    }
  }

  Am_Object new_pattern = Align_Zoom_Copy_Part(pattern);
  pattern_copy_proc_hole_link(new_pattern);
  pattern_copy_binders(new_pattern);

  pattern.Set(Am_ACTIVE, true);
  children = pattern.Get(ProcessList);
  for (children.Start(); !children.Last(); children.Next()) {
    Am_Object c = children.Get();
    if (c.Is_Instance_Of(PatternProto)) {
      c.Set(Am_ACTIVE, true);
    }
  }

  new_pattern.Set(Am_ACTIVE, true);
  children = new_pattern.Get(ProcessList);
  for (children.Start(); !children.Last(); children.Next()) {
    Am_Object c = children.Get();
    if (c.Is_Instance_Of(PatternProto)) {
      c.Set(Am_ACTIVE, true);
    }
  }
  return new_pattern;
}

// $B0lIt$,JQ2=$7$?>l9g$=$l$,GH5Z$9$kHO0O$rD4$Y$k(B
// --------------------------------------------
Am_Value_List propagate_list_iter(Am_Object root, Am_Value_List path)
{
  path.Start();
  if (path.Empty()) return Am_Value_List().Add(root);
  int type = path.Get();  path.Delete();  path.Start();
  int idx = path.Get();   path.Delete();  path.Start();
  Am_Slot_Key list_slot = 0;
  if (type == PathProcess) list_slot = ProcessList;  else
  if (type == PathHole)    list_slot = HoleList;  else  
  if (type == PathPort)    list_slot = PortList;  else
  if (type == PathValue)   list_slot = ValueList;  else
  if (type == PathBinder)  list_slot = Binders;
  else return Am_Value_List();
  Am_Value_List obj_list = root.Get(list_slot);
  if ((root.Is_Instance_Of(ReplPatternProto) && (type == PathProcess || type == PathHole)) ||
      root.Is_Instance_Of(MapInProto) || root.Is_Instance_Of(MapOutProto)) {
    Am_Value_List list = Am_Value_List();
    for (obj_list.Start(); !obj_list.Last(); obj_list.Next()) {
      Am_Object obj = obj_list.Get();
      list.Append(propagate_list_iter(obj, path));
    }
    return list;
  } else {
    return propagate_list_iter(Object_List_Get(obj_list, idx), path);    
  }  
}

Am_Value_List Change_Propagate_List(Am_Object obj)
{
  Am_Object root = Top_Pattern(obj);
  if (!root.Valid()) return Am_Value_List().Add(obj);
  Am_Value_List path = Obj_To_Path(obj, root);
  Am_Value_List list = propagate_list_iter(root, path);
  path.Make_Empty();
  return list;
}

// $B%l%$%"%&%H%;!<%V!&%j%9%H%"5!G=(B
// ------------------------------
// TODO:
// $B!&(Bdialog box$B$K$*$1$kL>A0$NJT=8(B *DONE*
// $B!&%l%$%"%&%H$N:o=|(B *DONE*
// $B!&%:!<%`%"%s%I%%$H$N@09g@-(B
// $B!&?7$7$$%[!<%k!&%Q%?!<%s$NDI2C$X$NBP1~!J%j%9%H$N?t9g$o$;!K(B

Am_Define_Value_List_Formula(LayoutNameListForm)
{
  Am_Object hole = self.GV(Hole);
  if (hole.Valid()) {
    return (Am_Value_List)hole.GV(LayoutNameList);
  }
  return 0;
}

Am_Define_Value_List_Formula(LayoutSizeListForm)
{
  Am_Object hole = self.GV(Hole);
  if (hole.Valid()) {
    return (Am_Value_List)hole.GV(LayoutSizeList);
  }
  return 0;
}

bool Pattern_Can_Save_Layout(Am_Object pattern)
{
  Am_Value_List name_list = pattern.Get(LayoutNameList);
  Am_Value_List size_list = pattern.Get(LayoutSizeList);  
  return !(name_list.Empty() && !size_list.Empty());
}

void save_location(Am_Object list_holder, Am_Object obj)
{
  Am_Inter_Location loc = Align_Zoom_Get_Location(obj);
  list_holder.Make_Unique(LayoutSizeList);
  Am_Value_List size_list = list_holder.Get(LayoutSizeList);
  if (size_list.Empty()) {
    list_holder.Set(LayoutSizeList, size_list.Add(loc));
  } else {
    size_list.Add(loc, Am_TAIL, false);
    list_holder.Note_Changed(LayoutSizeList);
  }
}

void save_layout_iter(Am_Object hole)
{
  Am_Object size_base = hole;
  Am_Object proc = hole.Get(Process);
  if (proc.Valid()) size_base = proc;
  save_location(hole, size_base);

  if (proc.Is_Instance_Of(PatternProto)) {
    // LayoutNameList$B$,6u$G$J$$$H$-$O$=$l0J2<$N;R6!$NBg$-$5$r%;!<%V$7$J$$!#(B
    Am_Value_List name_list = proc.Get(LayoutNameList);
    if (name_list.Empty()) {
      Am_Value_List holes = proc.Get(HoleList);
      for (holes.Start(); !holes.Last(); holes.Next()) {
	Am_Object h = holes.Get();
	save_layout_iter(h);
      }
    }
  }
}

void Pattern_Save_Current_Layout(Am_Object pattern)
{
  // layout$B$r%;!<%V$G$-$k%Q%?!<%s$+!)(B
  if (!Pattern_Can_Save_Layout(pattern)) return;

  // $B?7$7$$L>A0$r(BLayoutNameList$B$KDI2C(B
  Am_String new_name = Next_Name(pattern, LayoutNameList, "unnamed layout");
  pattern.Make_Unique(LayoutNameList);
  Am_Value_List name_list = pattern.Get(LayoutNameList);
  if (name_list.Empty()) {
    pattern.Set(LayoutNameList, name_list.Add(new_name));
  } else {
    name_list.Add(new_name, Am_TAIL, false);
    pattern.Note_Changed(LayoutNameList);
  }
  // $B<+J,$N%5%$%:$r(BLayoutSizeList$B$KDI2C(B
  save_location(pattern, pattern);
  // $B;R6!$N%5%$%:$r:F5"E*$K%;!<%V(B
  Am_Value_List holes = pattern.Get(HoleList);
  for (holes.Start(); !holes.Last(); holes.Next()) {
    Am_Object h = holes.Get();
    save_layout_iter(h);
  }
}

void restore_layout_iter(Am_Object pattern, int index)
{
  if (!pattern.Is_Instance_Of(PatternProto)) return;

  Am_Value_List holes = pattern.Get(HoleList);
  for (holes.Start(); !holes.Last(); holes.Next()) {
    Am_Object h = holes.Get();
    Am_Value_List size_list = h.Get(LayoutSizeList);
    Am_Inter_Location loc = 0;
    int i = 1;
    for (size_list.Start(); !size_list.Last(); size_list.Next(), ++i) {
      if (i == index) loc = (Am_Inter_Location)size_list.Get();
    }
    Am_Object proc = h.Get(Process);
    if (!proc.Valid()) {
      Align_Zoom_Animate_Obj(h, loc);
    } else {
      Align_Zoom_Animate_Obj(proc, loc);
      if (proc.Is_Instance_Of(PatternProto)) {
	// LayoutNameList$B$,6u$G$J$$$J$i0J2<$NJQ99$O$J$7!#(B
	Am_Value_List name_list = proc.Get(LayoutNameList);
	if (name_list.Empty()) {
	  restore_layout_iter(proc, index);
	}
      }
    }
  }
}


void Pattern_Restore_Layout(Am_Object pattern, Am_String layout_name)
{
  Am_Value_List name_list = pattern.Get(LayoutNameList);
  int index = String_List_Index(name_list, layout_name);
  if (index == 0) return;

  // index$BHVL\$N(Blocation$B$r(Bget
  Am_Value_List size_list = pattern.Get(LayoutSizeList);
  Am_Inter_Location loc = 0;
  int i = 1;
  for (size_list.Start(); !size_list.Last(); size_list.Next(), ++i) {
    if (i == index) loc = (Am_Inter_Location)size_list.Get();
  }
  Align_Zoom_Animate_Obj(pattern, loc);

  restore_layout_iter(pattern, index);
}

void remove_layout_iter(Am_Object pattern, int index)
{
  pattern.Make_Unique(LayoutSizeList);
  Am_Value_List size_list = pattern.Get(LayoutSizeList);
  int i = 1;
  for (size_list.Start(); !size_list.Last(); size_list.Next(), ++i) {
    if (i == index) {
      size_list.Delete(false);
      break;
    }
  }
  pattern.Note_Changed(LayoutSizeList);

  if (pattern.Is_Instance_Of(PatternProto)) {
    Am_Value_List holes = pattern.Get(HoleList);
    for (holes.Start(); !holes.Last(); holes.Next()) {
      Am_Object h = holes.Get();
      h.Make_Unique(LayoutSizeList);
      Am_Value_List size_list = h.Get(LayoutSizeList);
      int i = 1;
      for (size_list.Start(); !size_list.Last(); size_list.Next(), ++i) {
	if (i == index) {
	  size_list.Delete(false);
	  break;
	}
      }
      h.Note_Changed(LayoutSizeList);

      Am_Object proc = h.Get(Process);
      if (proc.Valid()) {
	if (proc.Is_Instance_Of(PatternProto)) {
	  Am_Value_List name_list = proc.Get(LayoutNameList);
	  if (name_list.Empty()) {
	    remove_layout_iter(h, index);
	  }
	}
      }
    }
  }
}

void Pattern_Remove_Layout(Am_Object pattern, Am_String layout_name)
{
  pattern.Make_Unique(LayoutNameList);
  Am_Value_List name_list = pattern.Get(LayoutNameList);

  int i = 1;
  for (name_list.Start(); !name_list.Last(); name_list.Next(), ++i) {
    if (strcmp((Am_String)name_list.Get(), layout_name) == 0) {
      name_list.Delete(false);
      pattern.Note_Changed(LayoutNameList);
      remove_layout_iter(pattern, i);
      break;
    }
  }
}

void Pattern_Rename_Layout(Am_Object pattern, Am_String layout_name, Am_String new_name)
{
  pattern.Make_Unique(LayoutNameList);
  Am_Value_List name_list = pattern.Get(LayoutNameList);

  for (name_list.Start(); !name_list.Last(); name_list.Next()) {
    if (strcmp((Am_String)name_list.Get(), layout_name) == 0) 
      name_list.Set(new_name, false);
  }
  pattern.Note_Changed(LayoutNameList);
}

// ------------------------------------------------------------
// Methods
// ------------------------------------------------------------


Am_Define_Method(Copy_Method, Am_Object, New_Pattern, (Am_Object net))
{
  Am_Object new_model = net.Get_Object(Model).Create();
  Am_Object new_net = net.Create()
    .Set(Model, new_model)
    .Set(Am_WIDTH, 150)
    .Set(Am_HEIGHT, 150)
    ;
  return new_net;
}

Am_Define_Method(Copy_Method, Am_Object, New_Repl_Pattern, (Am_Object net))
{
  Am_Object new_model = net.Get_Object(Model).Create();
  Am_Object new_net = net.Create()
    .Set(Model, new_model)
    .Set(Am_WIDTH, 150)
    .Set(Am_HEIGHT, 150)
    ;
  Am_Object repl_holes = new_net.Get_Part(ContentsPart).Get_Part(ContentsPart);
  Am_Object new_hole_model = repl_holes.Get_Object(Model).Create();
  repl_holes.Set(Model, new_hole_model);
  return new_net;
}

Am_Define_Method(Copy_Method, Am_Object, Copy_Pattern, (Am_Object patt))
{
  Am_Object new_patt = Pattern_Copy(patt);
  return new_patt;
}

Am_Define_Method(Naming_Method, bool, Pattern_Rename, (Am_Object pattern, Am_String name))
{
  // Am_Object module = pattern.Get(Parent);
  //  if (module.Valid())
  //    if (Member_Name(module, ProcessNameList, name)) return false;
  Propagate_Rename(pattern, name);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Pattern_Check_Drop, (Am_Object source, Am_Object target))
{
  if (target.Is_Instance_Of(PatternProto)) return false; // $B1x$$!#(Bmodule$B$,A*Br$5$l$F$7$^$&$N$G!#(B
  Am_Object group = target.Get_Part(ContentsPart);
  if (source == target) return false;
  if (source.Get_Owner() == group) return false;
  if (target.Is_Part_Of(source)) return false;
  return true;
}

Am_Define_Method(Drop_Method, bool, Pattern_Drop, (Am_Object source, Am_Object target, Am_Object cmd))
{
  if (target.Is_Instance_Of(ModuleProto) || target.Is_Instance_Of(NetworkRuleProto)) {
    Am_Object group = target.Get_Part(ContentsPart);
    //  cout << "dropping " << source << " in " << source.Get_Owner() << " into " << group << endl;
    Am_Inter_Location new_loc = cmd.Get(Am_VALUE);
    Am_Inter_Location old_loc = cmd.Get(Am_OLD_VALUE);

    bool as_line;
    Am_Object nref, oref;
    int nx, ny, ox, oy, w, h;
    new_loc.Get_Location(as_line, nref, nx, ny, w, h);
    old_loc.Get_Location(as_line, oref, ox, oy, w, h);
    Am_Translate_Coordinates(nref, nx, ny, group, nx, ny);

    Am_Object copy = Pattern_Copy(source)
      .Set(Am_LEFT, nx)
      .Set(Am_TOP, ny);
    if (CALL2(target, Bin_Check_Method, AddMethod, copy)) return true;
    return false;
  } else if (target.Is_Instance_Of(HoleProto)) {
    Am_Object copy = Pattern_Copy(source);
    if (CALL2(target, Bin_Check_Method, AddMethod, copy)) return true;
    return false;
  } else if (target.Is_Instance_Of(ProcessProto)) {
    Am_Object hole = target.Get(Hole);
    if (hole.Valid()) {
      Am_Object copy = Pattern_Copy(source);
      if (CALL2(hole, Bin_Check_Method, AddMethod, copy)) return true;
      return false;
    }
  }

}

Am_Define_Object_Formula(ReplProcParentForm)
{
  Am_Object repl_holes = self.GV_Owner();
  if (repl_holes.Valid()) {
    return repl_holes.GV(Parent);
  }
  return 0;
}

Am_Define_Method(Bin_Check_Method, bool, Pattern_Add, (Am_Object rule, Am_Object obj))
{
  Am_Slot_Key list_key;
  Am_String base_name = (Am_String)obj.Get_Object(Model).Get(Name);

  // Process, Pattern$B$O(BHole$B$,4hD%$C$F2?$H$+$7$F$/$l$k!#(B
  // -------------------------------------------------
  if (obj.Is_Instance_Of(ProcessProto)) {
    //    obj.Set(LayoutNameList, LayoutNameListForm)
    //      .Set(LayoutSizeList, LayoutSizeListForm);
    rule.Get_Part(ContentsPart).Add_Part(obj);
    return true;
  }
  else if (obj.Is_Instance_Of(PatternProto)) {
    //    obj.Set(LayoutNameList, LayoutNameListForm)
    //      .Set(LayoutSizeList, LayoutSizeListForm);
    rule.Get_Part(ContentsPart).Add_Part(obj);
    return true;
  }

  // Port, Hole$B$O(Bpropagate$B$7$J$/$F$O$J$i$J$$!#(B
  // ----------------------------------------
  if (obj.Is_Instance_Of(PortProto))  list_key = PortNameList;  else
  if (obj.Is_Instance_Of(HoleProto))  list_key = HoleNameList;  else
    {
      cerr << "Can't add " << obj << " to " << rule << endl;
      return false;
    }

  Am_String new_name = Next_Name(rule, list_key, base_name);
  obj.Get_Object(Model).Set(Name, new_name);

  Propagate_Add(rule, obj);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Repl_Pattern_Add, (Am_Object rule, Am_Object obj))
{
  Am_Slot_Key list_key;
  Am_String base_name = (Am_String)obj.Get_Object(Model).Get(Name);

  // Process, Pattern$B$O(BHole$B$,4hD%$C$F2?$H$+$7$F$/$l$k!#(B
  // -------------------------------------------------
  if (obj.Is_Instance_Of(ProcessProto)) {
    rule.Get_Part(ContentsPart).Get_Part(ContentsPart).Add_Part(obj.Set(Parent, ReplProcParentForm));
    return true;
  }
  else if (obj.Is_Instance_Of(PatternProto)) {
    rule.Get_Part(ContentsPart).Get_Part(ContentsPart).Add_Part(obj.Set(Parent, ReplProcParentForm));
    return true;
  }
  
  // Port$B$O(Bpropagate$B$7$J$/$F$O$J$i$J$$!#(B
  // ----------------------------------
  if (obj.Is_Instance_Of(PortProto)) {
    list_key = PortNameList;
  } else {
    cerr << "Can't add " << obj << " to " << rule << endl;
    return false;
  }

  Am_String new_name = Next_Name(rule, list_key, base_name);
  obj.Get_Object(Model).Set(Name, new_name);

  Propagate_Add(rule, obj);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Pattern_Remove, (Am_Object rule, Am_Object obj))
{
  if (obj.Is_Instance_Of(ProcessProto) || obj.Is_Instance_Of(PatternProto)) {
    Hole_Recover(obj);
    obj.Set(Hole, 0);
    return true;
  }

  if (obj.Is_Instance_Of(PortProto) || obj.Is_Instance_Of(HoleProto)) {
    Propagate_Remove(obj);
    return true;
  }
  return false;
}


// ------------------------------------------------------------
// Formulas
// ------------------------------------------------------------

Am_Define_Value_List_Formula(PatternHoleListForm)
{
  Am_Value_List list = Am_Value_List();

  Am_Value_List parts = ContentsListForm(cc, self);
  if (self.Is_Instance_Of(ReplPatternProto)) {
    Am_Object conts = self.GV_Part(ContentsPart);  if (!conts.Valid()) return 0;
    parts = ContentsListForm(cc, conts);
  }
  for (parts.Start(); !parts.Last(); parts.Next()) {
    Am_Object p = parts.Get();
    if (p.Is_Instance_Of(HoleProto)) list.Add(p);
    if (p.Is_Instance_Of(ProcessProto) || p.Is_Instance_Of(PatternProto)) {
      Am_Object hole = p.GV(Hole);
      if (hole.Valid()) list.Add(hole);
    }
  }
  return list;
}
			       
Am_Define_Value_List_Formula(PatternProcessListForm)
{
  Am_Value_List list = Am_Value_List();
  Am_Value_List parts = ContentsListForm(cc, self);
  if (self.Is_Instance_Of(ReplPatternProto)) {
    Am_Object conts = self.GV_Part(ContentsPart);
    parts = ContentsListForm(cc, conts);
  }
  for (parts.Start(); !parts.Last(); parts.Next()) {
    Am_Object p = parts.Get();
    if (p.Is_Instance_Of(ProcessProto) || p.Is_Instance_Of(PatternProto)) list.Add(p);
  }
  return list;
}

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void initPatternProto(void) {
  Am_Object name = EditableZoomingText.Create("PatternName")
    .Get_Part(TextPart).Set(Am_TEXT, ModelNameForm).Get_Owner()
    .Set(FontFamily, FontSansSerif)
    .Set(FontIsBold, true)
    .Set(NameHeightMax, GetResourceForm(NameHeightMax))
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, NameHeightForm)
    ;

  //  Am_Object frame = Am_Border_Rectangle.Create("PatternFrame")
  Am_Object frame = Am_Rectangle.Create("PatternFrame")
    .Set(Am_TOP, Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))     
    .Set(Am_HEIGHT, Am_From_Sibling(ContentsPart, Am_HEIGHT))
    .Set(Am_RADIUS, 10)
    .Set(Am_THICKNESS, 1)
    .Set(Am_FILL_STYLE, GetResourceForm(ProcessFill))
    ;

  Am_Object contents = PovlContents.Create("PatternContents")
    .Set(Am_TOP,    Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH,  Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Fill_To_Bottom)
    ;

  Am_Object binders_part = PovlGroup.Create("BindersPart")
    .Set(Am_VISIBLE, SelfVisibleForm)
    .Set(Am_TOP,    Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Fill_To_Bottom)
    ;

  PatternModel = Am_Root_Object.Create("PatternModel")
    .Set(Name,	"pattern")
    .Set(Module, 0)
    .Set(Type,  NormalPattern)
    ;

  PatternProto = PovlGroup.Create("PatternProto")
    // Attributes
    .Set(Parent, ParentForm)
    .Set(Type, ProcessGoal)
    .Set(Dir, LeftRight)
    .Set(Model, PatternModel.Create())
    .Set(Priority, 0)
    // Methods
    .Set(NewMethod, New_Pattern)
    .Set(CopyMethod, Copy_Pattern)
    .Set(NamingMethod, Pattern_Rename)
    .Set(AddMethod, Pattern_Add)
    .Set(RemoveMethod, Pattern_Remove)
    .Set(CheckDropMethod, Pattern_Check_Drop)
    .Set(DropMethod, Pattern_Drop)
    // Lists
    .Set(PortList, InstanceListForm(PortProto))
    .Set(PortNameList, NameListForm(PortList))
    .Set(ProcessList, PatternProcessListForm)
    .Set(ProcessNameList, Am_Value_List())
    .Set(Hole, 0)
    .Set(HoleList, PatternHoleListForm)
    .Set(HoleNameList, NameListForm(HoleList))
    .Set(InnerPortList, InnerPortListForm)
    .Set(InnerPortNameList, NameListForm(InnerPortList))
    .Set(GuardList, Am_Value_List())
    .Set(LayoutNameList, Am_Value_List())
    .Set(LayoutSizeList, Am_Value_List())
    .Set(hyperLinks, HyperLinkListForm)
    // Graphics    
    .Set(Am_VISIBLE, ContentsVisibleForm)
    .Set_Single_Constraint_Mode(Am_WIDTH, false)
    .Set_Single_Constraint_Mode(Am_HEIGHT, false)
    .Set(Am_WIDTH,  50)
    .Set(Am_HEIGHT, 40)
    .Add_Part(NamePart, name)
    .Add_Part(FramePart, frame)
    .Add_Part(ContentsPart, contents)
    .Add_Part(BindersPart, binders_part)
    .Set(Am_WIDTH, Am_From_Part(ContentsPart, Am_WIDTH))
    .Set(Am_HEIGHT, PovlGroupHeightForm)
    ;

  ReplPatternProto = PatternProto.Create("ReplPatternProto")
    .Set(Model, PatternModel.Create().Set(Name, "replication").Set(Type, ReplPattern))
    .Set(Dir, LeftRight)
    .Set(NewMethod, New_Repl_Pattern)
    .Get_Part(ContentsPart)
      .Set(Dir, Am_From_Owner(Dir))
      .Add_Part(ContentsPart, ReplHolesProto
		.Set(Dir, Am_From_Owner(Dir)))
    .Get_Owner()

    .Set(AddMethod, Repl_Pattern_Add)
    ;

}

// ------------------------------------------------------------
// Pattern Menu
// ------------------------------------------------------------

Am_Define_Method(Am_Object_Method, void, Pattern_Rotate_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner(); // $B%a%K%e!<(B
  Am_Object target = menu.Get(TargetObj);

  Am_Object holes = target.Get_Part(ContentsPart).Get_Part(ContentsPart);
  int w = holes.Get(Am_WIDTH);
  int h = holes.Get(Am_HEIGHT);
  int dir = target.Get(Dir);
  target.Set(Dir, (dir + 1) % 4);
  holes
    .Set(Am_WIDTH, h)
    .Set(Am_HEIGHT, w)
    .Set(partMoved, true)
    ;
}

Am_Define_Method(Am_Object_Method, void, Pattern_Save_Layout_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner(); // $B%a%K%e!<(B
  Am_Object pattern = menu.Get(TargetObj);
  Pattern_Save_Current_Layout(pattern);
}

void Popup_Wait_Layout_Selection_Dialog(Am_Object pattern, int x, int y)
{
  // Dialog$B$NL>A0(B
  Am_Object dialog = LayoutDialog.Create()
    .Set(Am_ITEMS, Am_Value_List().Add("Modifiable behaviors of")
	                          .Add(pattern.MGet(Name)));

  cout << x << " " << y << endl;
  dialog
    .Set(Am_LEFT, x)
    .Set(Am_TOP, y);

  // Menu Item$B$N%j%9%H$r@8@.!#(B
  Am_Value_List menu_items = 0;
  Am_Value_List layouts = pattern.Get(LayoutNameList);
  for (layouts.Start(); !layouts.Last(); layouts.Next()) {
    Am_String name = layouts.Get();
    //    Am_Object text = Am_Text.Create()
    //      .Set(Am_TEXT, name)
    //    menu_items.Add(LayoutSelectionCmd.Create()
    //		   .Set(Am_LABEL, text)
    //		   .Set(Process, pattern));
    Am_Object cmd = LayoutSelectionCmd.Create()
      .Set(Am_TEXT, name)
      .Set(Process, pattern);

    dialog.Get_Part(Am_DIALOG_GROUP).Get_Part(Am_ITEMS).Get_Part(Am_ITEMS)
      .Add_Part(cmd);
  }
  //  dialog.Get_Part(Am_DIALOG_GROUP).Get_Part(Am_ITEMS).Get_Part(Am_ITEMS)
  //    .Set(Am_ITEMS, menu_items);


  Am_String result = Am_Show_Dialog_And_Wait(dialog, false);
}


Am_Define_Method(Am_Object_Method, void, Layout_Selection_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner(); // $B%a%K%e!<(B
  Am_Object window = menu.Get_Owner();
  Am_Finish_Pop_Up_Waiting(window, Am_No_Value); // $B%]%C%W%"%C%W%a%K%e!<$r>C$9(B

  Am_Object pattern = menu.Get_Object(TargetObj); // pattern
  Popup_Wait_Layout_Selection_Dialog(pattern, (int)window.Get(Am_LEFT), (int)window.Get(Am_TOP));
}

Am_Define_Method(Am_Object_Method, void, Layout_Menu_Do, (Am_Object command_obj))
{
  Am_Object layout_cmd = command_obj.Get_Owner().Get_Owner();

  //  Am_String layout_name = command_obj.Get_Object(Am_LABEL).Get(Am_TEXT);
  //  Am_Object pattern = command_obj.Get(Process);

  Am_String layout_name = layout_cmd.Get(Am_TEXT);
  Am_Object pattern = layout_cmd.Get(Process);

  Pattern_Restore_Layout(pattern, layout_name);
}

Am_Define_Method(Am_Object_Method, void, Layout_Remove_Do, (Am_Object command_obj))
{
  Am_Object layout_cmd = command_obj.Get_Owner().Get_Owner();
  layout_cmd.Remove_From_Owner();

  Am_String layout_name = layout_cmd.Get(Am_TEXT);
  Am_Object pattern = layout_cmd.Get(Process);

  Pattern_Remove_Layout(pattern, layout_name);
}

Am_Define_Method(Am_Object_Method, void, Layout_Rename_Do, (Am_Object command_obj))
{
  Am_Object layout_cmd = command_obj.Get_Owner().Get_Owner();

  Am_String old_name = command_obj.Get_Owner().Get(Am_OLD_VALUE);
  Am_String new_name = layout_cmd.Get(Am_TEXT);
  Am_Object pattern = layout_cmd.Get(Process);

  if (strcmp(old_name, new_name) != 0) {
    if (!Member_Name(pattern, LayoutNameList, new_name)) {
      layout_cmd.Set(Am_TEXT, new_name);
      Pattern_Rename_Layout(pattern, old_name, new_name);
    } else {
      Am_Abort_Interactor(command_obj.Get_Owner());
    }
  }
}

void initPatternMenu(void)
{
  Am_Object PatternMenu = PopUpMenu.Create("PatternMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, TargetNameForm))
	 .Add(Am_Menu_Line_Command.Create())
	 //	 .Add(UndoZoomCmd.Create())
	 //	 .Add(RedoZoomCmd.Create())
	 //	 .Add(SelectiveUndoZoomCmd.Create())
	 .Add(PovlOrigSizeCmd.Create())
	 .Add(PovlEditSizeCmd.Create())
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Implementations...")
	      .Set(Am_DO_METHOD, Impl_Selection_Do))
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Register Layout")
	      .Set(Am_DO_METHOD, Pattern_Save_Layout_Do))
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Change Layout...")
	      .Set(Am_DO_METHOD, Layout_Selection_Do))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, HoleProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, SpecialSingletonProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, SpecialStreamProto))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete"))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(PatternMenu);

  Am_Object PatternMenuPopper = PopUpMenuInteractor.Create("PatternMenuPopper")
    .Set(MenuWindow, PatternMenu)
    ;
  PatternProto.Add_Part(PatternMenuPopper);

  Am_Object ReplPatternMenu = PopUpMenu.Create("ReplPatternMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, TargetNameForm))
	 .Add(Am_Menu_Line_Command.Create())
	 //	 .Add(UndoZoomCmd.Create())
	 //	 .Add(RedoZoomCmd.Create())
	 //	 .Add(SelectiveUndoZoomCmd.Create())
	 .Add(PovlOrigSizeCmd.Create())
	 .Add(PovlEditSizeCmd.Create())
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, SpecialSingletonProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, SpecialStreamProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, BroadSingletonProto))	 
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, BroadStreamProto))	 
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, MergeProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, MapInProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, MapOutProto))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Rotate").Set(Am_DO_METHOD, Pattern_Rotate_Do))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete"))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(ReplPatternMenu);

  Am_Object ReplPatternMenuPopper = PopUpMenuInteractor.Create("PatternMenuPopper")
    .Set(MenuWindow, ReplPatternMenu)
    ;
  ReplPatternProto.Add_Part(ReplPatternMenuPopper);

  // Behavior Dialog --------------------------------------------------
  // LayoutSelectionMenu.Am_ITEMS: $B%l%$%"%&%HL>$N%j%9%H!#(B
  // LayoutDialog.Am_ITEMS: $B%Q%?!<%s$NL>A0!#(B
  LayoutSelectionCmd = Am_Text.Create()
    .Set(Am_FONT, GetResourceForm(ImplDialogFont))
    .Add_Part(Am_One_Shot_Interactor.Create()
	      .Get_Part(Am_COMMAND).Set(Am_DO_METHOD, Layout_Menu_Do).Get_Owner())
    .Add_Part(Am_Text_Edit_Interactor.Create()
	      .Set(Am_START_WHEN, "middle_down")
	      .Get_Part(Am_COMMAND).Set(Am_DO_METHOD, Layout_Rename_Do).Get_Owner())
    .Add_Part(Am_One_Shot_Interactor.Create()
	      .Set(Am_START_WHEN, "double_right_down")
	      .Get_Part(Am_COMMAND).Set(Am_DO_METHOD, Layout_Remove_Do).Get_Owner())
    ;

  LayoutSelectionMenu = Am_Group.Create()
    .Set(Am_WIDTH, 252)
    .Set(Am_HEIGHT, 600)
    .Set(Am_LAYOUT, Am_Vertical_Layout)
    .Set(Am_H_ALIGN, Am_LEFT_ALIGN)
    ;

  /*
  LayoutSelectionCmd = Am_Command.Create()
    .Set(Am_DO_METHOD, Layout_Menu_Do)
    ;

  LayoutSelectionMenu = Am_Menu.Create()
    .Set(Am_FONT, GetResourceForm(ImplDialogFont))
    .Set(Am_WIDTH, 252)
    .Set(Am_HEIGHT, 600)
    .Set(Am_ITEMS, Am_Value_List())
    ;
  */

  Am_Object scrolling_selection = Am_Scrolling_Group.Create()
    .Set(Am_WIDTH, 250)
    .Set(Am_HEIGHT, 150)
    .Set(Am_H_SCROLL_BAR, false)
    .Add_Part(Am_ITEMS, LayoutSelectionMenu)
    ;

  LayoutDialog = Am_Choice_Dialog.Create()
    .Set(Am_OMIT_TITLE_BAR, false)
    .Set(Am_VISIBLE, false)
    .Set(Am_TITLE, "Behaviors")
    .Set(Am_ITEMS, Am_Value_List())
    .Get_Part(Am_DIALOG_GROUP)
      .Add_Part(Am_ITEMS, scrolling_selection)
      .Get_Part(Am_DIALOG_BUTTONS)
        .Set(Am_H_SPACING, 5)
      .Get_Owner()
    .Get_Owner()
    ;

  Am_To_Top(LayoutDialog.Get_Part(Am_DIALOG_GROUP).Get_Part(Am_DIALOG_BUTTONS));
  Am_Value_List parts = LayoutDialog.Get_Part(Am_DIALOG_GROUP).Get(Am_GRAPHICAL_PARTS);
  parts.Start();
  Am_Object text = parts.Get();
  text.Get_Object(Am_ITEM_PROTOTYPE).Set(Am_FONT, Am_Font(Am_FONT_SANS_SERIF, false, false, false, Am_FONT_LARGE));
}

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void InitializePattern(void)
{
  initPatternProto();
  initPatternMenu();
}
