%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
% The file contains some specifications for RLRPAR          	     
%
%
%           retrieve-E.pl
%
%       Retrieve an English dictionary.
%
%
%   $Id$
%
%   $Log$
%

:- dynamic sentence/1, translated/1.

% Read a sentence from an input sequence.
read_a_sentence(Stream,S) :-
	read_a_word(Stream,W),
	(W=[[]] -> S=[]
	;
	 W=end_of_file -> S=W
	;
	 read_a_sentence(Stream,S1),
	 S=[W|S1]),!.

% Read a word.
read_a_word(Stream,W) :-
	read_a_word1(Stream,W1),
	(W1=[[]] -> W=W1
	;
	 W1=end_of_file -> W=W1
	;
	 name(W,W1)),!.

%
read_a_word1(Stream,W) :-
	get0(Stream,C),
	(((C==10; C==46; C==63) -> W=[[]]
	 ;
	  (C==9; C==32) -> read_a_word1(Stream,W)
	 ;
	  (C<0 -> W=end_of_file))
	;
	 read_a_word2(Stream,Z),
	 W=[C|Z]),!.

read_a_word2(Stream,W) :-
	get0(Stream,C),
	((C=10; C=46; C=63; C=9; C=32) -> W=[]
	;
	 read_a_word2(Stream,Z),
	 W=[C|Z]),!.

%
retrieve_a_dictionary(Word,Pt) :- !,
	dict(Word,Pt).


%
record_a_word(Word,Pt,N) :- !,
	assertz(word(N,Word,Pt)).

%
translate_s_into_pt([],[],_) :- !.
translate_s_into_pt([W|W1],[P|P1],N) :-
	(retrieve_a_dictionary(W,P)
	;
	 P=uk),
	record_a_word(W,P,N),
	N1 is N+1,
	translate_s_into_pt(W1,P1,N1),!.
translate_s_into_pt(X,X,_) :- !.

%
record_sentence(S) :- !,
	abolish(sentence/1),
	assertz(sentence(S)).

%
record_translated(S) :- !,
	abolish(translated/1),
	assertz(translated(S)).
