%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
% The file contains some specifications for RLRPAR          	     
%
%
%           record_info.pl
%
%   Record shift and reduce info when the parser runs normally.
%
%       $Id: record_info.pl,v 1.3 1993/12/16 07:41:42 imai Exp imai $
%
%       $Log: record_info.pl,v $
% Revision 1.3  1993/12/16  07:41:42  imai
% Changed GSS storage from 'recordz/3' to 'assertz/1'.
%
% Revision 1.2  1993/11/19  09:13:48  imai
% Modified record_shift_info and record_reduce_info
% to record a node of the initial state.
%
% Revision 1.1  1993/11/08  11:04:41  imai
% Initial revision
%
%
%   Data structures :
%
%       Shift information :
%           [Category, Left_pos, Right_pos, To_state]
%
%       Reduce information :
%           [Sub_tree, Left_pos, Right_pos, To_state]
%           Sub_tree :
%               [Nonterminal, Reduce_path]

:- dynamic shift_info/7, reduce_info/7.

% Record shift information(s) :
record_shift_info([],NR1,NR2) :- !,NR2=NR1.
record_shift_info(0-_-E,NR1,NR2) :- !,
	((shift_info(start,0,0,0,0,E,0), NR2=NR1)
	;
	 asserta(shift_info(start,0,0,0,0,E,0)),
	 NR1 = [NodeInfo,shift(Shift)|NR11],
	 NR2 = [NodeInfo,shift([[start,0,0,0,0,E,0]|Shift])|NR11]).
record_shift_info(_-([],_,_)-_,NR1,NR2) :- !,NR2=NR1.
record_shift_info(To-([(Key,_)|Keys],Pos,Cat)-E,NR1,NR2) :- !,
	% To  : To_state
	% Pos : Current position (equal to Right_pos)
	% Cat : Shifted category
	% E   : Error count
	% T   : Tail of key list
	(atom(Cat),              % Cat must be a terminal symbol.
	 node(Key,From-T-_),
	 (T=(_,Left,_)
	 ;
	  T=(_,Left,_,_)
	 ;
	  T=[],
	  Left=0),
	 Right=Pos,
	 ((shift_info(Cat,Left,Right,From,To,E,0), NR3=NR1)
	 ;
	  asserta(shift_info(Cat,Left,Right,From,To,E,0)),
	  NR1 = [NodeInfo,shift(Shift)|NR11],
	  NR3 = [NodeInfo,shift([[start,0,0,0,0,E,0]|Shift])|NR11]
	 )
	;
	 NR3=NR1, true ),
	record_shift_info(To-(Keys,Pos,Cat)-E,NR3,NR2).

% Search the left position of a subtree
search_left_pos([_,Key|_],Left) :- !,
	node(Key,Node),               % associate Node with Key.
	((Node=S-(_,Pos,[Path|_],Sym)-E,    % This node is nonterminal.
	 reduce_info([Sym,Path],Left,Pos,_,S,E,_))
%	 search_left_pos(Path,Left)   % search a preterminal node recursively.
	;
	 (Node=_-(_,Pos,_)-_,          % This node is preterminal.
	  Left is Pos-1)).

record_shift_info([]) :- !.
record_shift_info(0-_-E) :- !,
	(shift_info(start,0,0,0,0,E,0)
	;
	 asserta(shift_info(start,0,0,0,0,E,0))).
record_shift_info(_-([],_,_)-_) :- !.
record_shift_info(To-([(Key,_)|Keys],Pos,Cat)-E) :- !,
	% To  : To_state
	% Pos : Current position (equal to Right_pos)
	% Cat : Shifted category
	% E   : Error count
	% T   : Tail of key list
	(atom(Cat),              % Cat must be a terminal symbol.
	 node(Key,From-T-_),
	 (T=(_,Left,_)
	 ;
	  T=(_,Left,_,_)
	 ;
	  T=[],
	  Left=0),
	 Right=Pos,
	 (shift_info(Cat,Left,Right,From,To,E,0)
	 ;
	  asserta(shift_info(Cat,Left,Right,From,To,E,0)))
	;
	 true),
	record_shift_info(To-(Keys,Pos,Cat)-E).

% Record reduce information(s) :
record_reduce_info([]) :- !.
record_reduce_info(S-((Key,_),Pos,Repaths,Cat)-E) :- !,
	% S       : To_state
	% Key     : Pointer to parent
	% Pos     : Current position
	% Repaths : Reduce paths
	% Cat     : Reduced category
	% E       : Error count
	% T       : Tail of reduce list
	node(Key,From-_-_),
        record_reduce_info1(Cat,Repaths,Pos,From,S,E).


%
record_reduce_info1(_,[],_,_,_,_) :- !.
record_reduce_info1(Cat,[Path1|Paths],Right,From,To,E) :-
	% Cat   : Reduced category
	% Path1 : Reduce path
	% Paths : Tail list of reduce paths
	% Right : Right position of the subtree
	% From  : From_state
	% To    : To_state
	% E     : Error count
	search_left_pos(Path1,Left),
	(reduce_info([Cat,Path1],Left,Right,From,To,E,0)
	;
	 asserta(reduce_info([Cat,Path1],Left,Right,From,To,E,0))),
	record_reduce_info1(Cat,Paths,Right,From,To,E).

