%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
% The file contains some specifications for RLRPAR          	     
%
%
%           extract.pl
%
%       Extract trees generated by the parser.
%
%       $Id: extract.pl,v 1.3 1993/12/16 08:17:23 imai Exp imai $
%
%       $Log: extract.pl,v $
% Revision 1.3  1993/12/16  08:17:23  imai
% Changed GSS storage from 'recordz/3' to 'assertz/1'.
%
% Revision 1.2  1993/11/30  11:40:21  imai
% Change how to extract trees.
%
%
%
%
:- dynamic tree/2, ntrees/1.

record_tree(Tree) :-
	ntrees(N),
	N1 is N+1,
	retract(ntrees(N)),
	assert(ntrees(N1)),
	assertz(tree(N1,Tree)),
	!.


write_trees(N,Stream) :-
	(tree(N,Tree),
	 write(Stream,N),write(Stream,': '),
	 write(Stream,Tree),write(Stream,'.'),nl(Stream),
	 flush_output(Stream),
	 N1 is N+1,
	 write_trees(N1,Stream)
	;
	 true).

write_ntrees(N,Stream) :-
	(N=0,
	 write(Stream,'No tree.')
	;
	 write(Stream,N),
	 (N=1,write(Stream,' tree exists.')
	 ;
	  write(Stream,' trees exist.'))),
	nl(Stream).

write_a_tree(Tree,Stream) :-
	ntrees(N),
	N1 is N+1,
	retract(ntrees(N)),
	assert(ntrees(N1)),
	write(Stream,N),write(Stream,': '),
	write(Stream,Tree),write(Stream,'.'),nl(Stream),
	flush_output(Stream).

extract_tree(Keys,Stream):-
	extract_tree0(Keys,Tree),
%	record_tree(Tree),
	write_a_tree(Tree,Stream),
	fail.
extract_tree(_):-!.

extract_tree0(Keys,[Category|Tree]):-!,
	list_match(Key,Keys),
%	recorded(node,_-(_,_,Reduce_paths,Category)-_,Key),
	node(Key,_-(_,_,Reduce_paths,Category,_)-_),
	list_match(Reduce_path,Reduce_paths),
	pop_nt_or_pt(Reduce_path,Tree).

% state 0
pop_nt_or_pt([Key|Tail],Tree):-
%	recorded(node,0-[]-_,Key),!,
	node(Key,0-[]-_),!,
	pop_nt_or_pt0(Key,Tail,Tree).

% parent.
pop_nt_or_pt0(_,[],[]).

% non terminal
pop_nt_or_pt0(Post,[Key|Tail],[[Catinfo|List1]|List2]):-
%	recorded(node,_-(_,_,Reduce_paths,Category)-_,Key),!,
	node(Key,_-(_,_,Reduce_paths,Category,EP)-_),!,
	(EP==n -> Catinfo=Category
	;
	 error_info(EP,_,_,Orig,_,Error,_),
	 Error=..[Kind,_],
	 Catinfo=..[Category,Kind,orig:Orig]),
	list_match([Post|Reduce_path],Reduce_paths),
	pop_nt_or_pt0(Post,Reduce_path,List1),
	pop_nt_or_pt0(Key,Tail,List2).
% preterminal
pop_nt_or_pt0(_,[Key|Tail],[Catinfo|List]):-
%	recorded(node,_-(_,_,Category)-_,Key),!,
	node(Key,_-(_,_,Category,EP)-_),!,
	(EP==n -> Catinfo=Category
	;
	 error_info(EP,_,_,Orig,_,Error,_),
	 Error=..[Kind,_],
	 Catinfo=..[Category,Kind,orig:Orig]),
	pop_nt_or_pt0(Key,Tail,List).

list_match(Path,[Path|_]).
list_match(Path,[_|Paths]):-!,
	list_match(Path,Paths).
