%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
% The file contains some specifications for RLRPAR          	     
%
%
%           error_handling.pl
%
%       Main routine of error-handling.
%
%       $Id: error_handling.pl,v 2.0 1994/01/22 19:09:42 imai Exp imai $
%
%       $Log: error_handling.pl,v $
% Revision 2.0  1994/01/22  19:09:42  imai
% Modified the reparsing algorithm.
% Modified the main algorithm of error handling.
%
% Revision 1.6  1993/12/28  05:54:52  imai
% Changed a basic design.
%     Execute an error handling after the parser fails
%     in all stacks for a state.
%     It's 'error_handling/3'.
%
% Revision 1.5  1993/12/16  07:42:57  imai
% 1. Changed GSS storage from 'recordz/3' to 'assertz/1'.
% 2. Modified 'reparse'.
%     Modified a routine of using subtrees.
%     But I don't use it since it still contains some bugs.
%
% Revision 1.4  1993/11/30  11:08:43  imai
% Made the order of searching the error position exact.
% 	Modified 'search_error_point'.
% 	Divided 'search_error_point' into subroutines to be easy to
% 	understand.
% Added a routine in order to satisfy completeness.
% (Search each point that exists inside a subtree.)
% 	'search_other_shift_info'
%
% Revision 1.3  1993/11/26  05:32:51  imai
% Switch 'reduce_info' in 'reparse' from any errors to no error.
% In order to find all trees.
%
% Revision 1.2  1993/11/25  05:37:40  imai
% 1. Modified has_failed_at.
%    Return stack results to the main parser.
% 2. Modified search_error_point, and so on.
%    Search each stage only one time because the same tree appears
%    frequently.
% 3. Bug fix.
%    1) Modifing that the parser cannot process the error which has
%       occurred at stage 0.
%    2) In reparse, modifing that the parser does not use data
%       repeatedly.
%
% Revision 1.1  1993/11/19  09:11:38  imai
% Initial revision
%
%
%

:- dynamic stack_top_at_error/1, errors/1, result_info/4.
:- dynamic maxerrors/1, checked_most_right_pos/1.
:- dynamic error_info/7.
:- dynamic disp_progress/0.

% Execute a process for each node when an error occurred.
        % F     : Flag whether the parser is reparsing.
	% LA    : Lookahead when the error has occurred.
        % S     : State of error occurring.
        % P     : Position of error occurring.
        % E     : Number of errors before error occurring.
	% Nodes : List of stack tops when the error has occurred.
	% N     : List of result nodes.
error_handling(e,_,_,N,NR1,NR2) :- !, N=[],NR2=NR1.
error_handling(n,_,[],N,NR1,NR2) :- !, N=[], NR2=NR1.
error_handling(n,LA,[S-(_,P,_,_)-E|Nodes],N,NR1,NR2) :- !,
	error_handling1(S,P,LA,E,Nodes,N,NR1,NR2).
error_handling(n,LA,[S-(_,P,_)-E|Nodes],N,NR1,NR2) :- !,
	error_handling1(S,P,LA,E,Nodes,N,NR1,NR2).
error_handling(n,LA,[S-[]-E|Nodes],N,NR1,NR2) :- !,
	error_handling1(S,0,LA,E,Nodes,N,NR1,NR2).

%
error_handling1(S,P,LA,E,_,N,NR1,NR2) :- !,
	E1 is E+1,
%	maxerrors(M),
	M=10,
	has_failed_at(E1,M,S,P,LA,N,NR1,NR2).

% Main routine of error-handling.
	% Noerror : Number of errors which has occurred.
	% Lerror : Limit of errors.
	% State : State when the error has occurred.
	% Pos   : Stage when the error has occurred.
	% LA    : Lookahead when the error has occurred.
	% Results : List of stacks after error-handling.
has_failed_at(E,E,_,_,_,Result,NR1,NR2) :- !, Result=[], NR2=NR1.
has_failed_at(Noerror,_,_State,Pos,LA,Results,NR1,NR2) :- !,
	Pos1 is Pos+1,!,
	Eprev is Noerror-1,!,
	search_error_point(Pos,Poslist,NR1),!,
	search_alternative_actions(Eprev,LA,Pos,Poslist,Actionlist,NR1,NR3),!,
	execute_alternative_actions(Pos1,LA,Actionlist,Results,NR3,NR4),
	set_checked_most_right_pos(Pos,NR4,NR2).

%
add_active_error_node(Pos,State,Errors) :-
	shift_info(Sym,_,Pos,_,State,0,_),
	(node(_,State-(Parent,Pos,Sym)-_),
	 add_active_nodes([State-(Parent,Pos,Sym)-Noerror])
	;
	 node(_,State-[]-_),
	 add_active_nodes([State-[]-Errors])).


% Print an error message.
display_error_message(Pos,State,LA) :-
	ttynl,
	display('I have failed at Stage '),
	display(Pos),
	display(', State '),
	display(State),
	display(', and Lookahead "'),
	display(LA),
	display('".'),
	ttynl,ttynl.


% Search possible error points.
	% Pos   : Position when the error occurred
	% LA    : Lookahead when the error occurred
	% Poslist : Possible error points
search_error_point(0,Poslist,NR1) :- !,
	NR1=[_,_,_,_,P|_],
	check_most_right_pos(P,[0],Poslist).
search_error_point(Pos,OutPoslist,NR1) :- !,
	search_error_point1(Pos,Poslist1,NR1),
	search_error_point2(Pos,Poslist2,NR1),
	(intree,
	 search_error_point3(Pos,Poslist1,Poslist2,Poslist3),
	 append_n([Poslist1,Poslist2,Poslist3],Poslist4)
	;
	 append(Poslist1,Poslist2,Poslist4)),
	NR1=[_,_,_,_,P|_],
%	checked_most_right_pos(P),
	check_most_right_pos(P,Poslist4,Poslist),
	OutPoslist=[Pos|Poslist].

% Search error points that has not reduced yet.
search_error_point1(0,OutPos,_NR1) :- !, OutPos=[].
search_error_point1(Pos,Poslist1,NR1) :-
	NR1 = [node(Node)|_],
	findpos1(Pos,Ptslist,Node),
%	bagof(Pts,X^S^R^Sym^node(X,S-(Pts,Pos,R,Sym,_)-_),Ptslist),
%	\+(is_reduced(Pos,Pos1)),
	search_most_left(Ptslist,Left,NR1),
	Left<Pos,
	search_error_point1(Left,Poslist1,NR1).
search_error_point1(Pos,OutPos,NR1) :-
	Pos1 is Pos-1,
	OutPos = [Pos1|Poslist1],
	search_error_point1(Pos1,Poslist1,NR1).
%
search_most_left([],Left,_NR1) :- !,Left=100000.
search_most_left([Pts|Ptslist],Left,NR1) :- 
	search_most_left1(Pts,Left1,NR1),
	search_most_left(Ptslist,Left2,NR1),
	(Left1 =< Left2,
	 Left=Left1
	;
	 Left=Left2),!.

%
search_most_left1([],Left,_NR1) :- !,Left=100000.
search_most_left1([(Pt,_)|Pts],Left,NR1) :- !,
	NR1 = [node(Node)|_],
	findpos2(Node,Pt,Pos),
%	(node(Pt,_-(_,Pos,_,_,_)-_)
%	;
%	 node(Pt,_-(_,Pos,_,_)-_)
%	;
%	 node(Pt,0-[]-_),
%	 Pos=0),
	search_most_left1(Pts,Left1,NR1),
	(Pos =< Left1,
	 Left=Pos
	;
	 Left=Left1).

% Search error points that is between neighboring trees.
search_error_point2(0,Neighbor,_NR1) :- !,Neighbor=[].
search_error_point2(Pos,Neighbor,NR1) :-
	NR1 = [node(Node)|_],
	findpos1(Pos,Ptslist,Node),
%	bagof(Pts,X^S^R^Sym^node(X,S-(Pts,Pos,R,Sym,_)-_),Ptslist),
	search_error_point2_1(Pos,Ptslist,Neighbor1,NR1),
	append(Neighbor1,Neighbor2,Neighbor),
	search_most_left(Ptslist,Left,NR1),
	Left<Pos,
	search_error_point2(Left,Neighbor2,NR1).
search_error_point2(Pos,Neighbor,NR1) :- !,
	Pos1 is Pos-1,
	search_error_point2(Pos1,Neighbor,NR1).

%
search_error_point2_1(_,[],Neighbor,_NR1) :- !,Neighbor=[].
search_error_point2_1(Pos,[Pts|Ptslist],Neighbor,NR1) :-
	search_error_point2_2(Pos,Pts,Neighbor1,NR1),
%	append(Poslist1,Poslist2,Poslist),
	search_error_point2_1(Pos,Ptslist,Neighbor2,NR1),
	append(Neighbor1,Neighbor2,Neighbor3),
	quicksort(Neighbor3,Neighbor,r).
%	sort(Neighbor3,Neighbor4),
%	reverse(Neighbor4,Neighbor).


%
search_error_point2_2(_,[],Neighbor,_NR1) :- !,Neighbor=[].
search_error_point2_2(Pos,[(Pt,_)|Pts],ONeighbor,NR1) :-
	NR1 = [node(Node)|_],
	findpos3(Node,Pt,Pos1),
%	node(Pt,_-(_,Pos1,_,_,_)-_),
	( Pos1<Pos ->
	     ONeighbor=[Pos1|Neighbor];
	     ONeighbor=Neighbor ),
	search_error_point2_2(Pos,Pts,Neighbor,NR1).
%search_error_point2_2(Pos,[_|Pts],Neighbor,NR1) :- !,
%	search_error_point2_2(Pos,Pts,Neighbor,NR1).

% Search error points that is inside a tree.
%search_error_point3(Pos,Poslist1,Poslist2,Poslist3)
search_error_point3(Pos,Poslist1,Poslist2,Poslist3) :- !,
	gen_all_point(Pos,Allpos),
	append(Poslist1,Poslist2,Searched),
	search_error_point3_1(Allpos,Searched,Poslist3).

%
gen_all_point(Pos,Allpos) :- !,
	Pos1 is Pos-1,
	gen_all_point1(Pos1,Allpos).

%
gen_all_point1(0,[0]) :- !.
gen_all_point1(Pos,[Pos|All]) :- !,
	Pos1 is Pos-1,
	gen_all_point1(Pos1,All).

%
search_error_point3_1(Yet,[],Yet) :- !.
search_error_point3_1([Pos|Poslist],[Pos|Already],Yet) :-
	search_error_point3_1(Poslist,Already,Yet).
search_error_point3_1([Pos|Poslist],Already,[Pos|Yet]) :- !,
	search_error_point3_1(Poslist,Already,Yet).


% Display an error point.
display_error_point(State,Pos,LA,Key) :-
	display('Error Point: [Stage,State,LA,StackTop]'),ttynl,
	tab(13),
	display('['),display(Pos),
	display(','),display(State),
	display(','),display(LA),
	display(','),display(Key),
	display(']'),ttynl.


% Check if the terminal symbol from Left to Right is reduced.
is_reduced(Left,Right) :- !,
	reduce_info(_,Left1,Right1,_,_,0,_),
	Left1=<Left,
	Right=<Right1.


% Find alternative actions.
        % E     : Number of errors before this error occurred.
	% ELA   : LA when the parser failed
	% Pos   : Position to which the parser should go back
	% Poslist : List of positions to which the parser should go back
	% State : State when the parser goes back
	% LA    : LA when the parser goes back
	% Acts  : Key list of alternative actions at stage Pos
	% Actlist : List of [Pos,LA,Acts]
search_alternative_actions(_,_,_,[],Actlist,NR1,NR2) :- 
	!, Actlist=[], NR2=NR1.
search_alternative_actions(E,ELA,Epos,[Epos|Poslist],OActlist,NR1,NR2) :- !,
%	(node(Key,State-(_,Epos,_,_)-_)
%	;
%	 Key=0,State=0),
	NR1 = [node(Node)|_],
	findpos4(Node,Epos,Key,State),
	terminal(T),
	search_alternative_actions1(State,ELA,Epos,Key,T,Acts1,NR1,NR3),
	nonterminal(NT),
	search_alternative_actions_for_nt(E,ELA,Epos,NT,Acts2,NR3,NR4),
	append(Acts1,Acts2,Acts),
	search_alternative_actions(E,ELA,Epos,Poslist,Actlist,NR4,NR2),
	OActlist=[[Epos,State,ELA,Acts]|Actlist].
search_alternative_actions(E,ELA,Epos,[Pos|Poslist],OActlist,NR1,NR2) :- !,
	Pos1 is Pos+1,
	NR1 = [node(Node)|_],
	findpos4(Node,Pos,Key,State),
	findlkhd(Node,Pos1,LA,E),
%	node(_,_-(_,Pos1,LA,_)-E),
%	(node(Key,State-(_,Pos,_,_)-_)
%	;
%	 Key=0,
%	 State=0),
	terminal(T),
	search_alternative_actions1(State,LA,Pos,Key,T,Acts,NR1,NR3),
	search_alternative_actions(E,ELA,Epos,Poslist,Actlist,NR3,NR2),
	OActlist=[[Pos,State,LA,Acts]|Actlist].



% Find alternative actions for preterminal.
        % E     : Number of errors before this error occurred.
	% ELA   : LA when the parser failed
	% Pos   : Position to which the parser should go back
	% Poslist : List of positions to which the parser should go back
	% State : State when the parser goes back
	% LA    : LA when the parser goes back
	% Acts  : Key list of alternative actions at stage Pos
	% Actlist : List of [Pos,LA,Acts]
search_alternative_actions_for_pt(_,_,[],[]) :- !.
search_alternative_actions_for_pt(E,ELA,[Pos|Poslist],
	[[Pos,State,LA,Acts]|Actlist]) :- !,
	Pos1 is Pos+1,
	(node(_,_-(_,Pos1,LA,_)-E)
	;
	 LA=ELA),
	(node(Key,State-(_,Pos,_,_)-_)
	;
	 Key=0,
	 State=0),
	terminal(T),
	search_alternative_actions1(State,LA,Pos,Key,T,Acts),
	search_alternative_actions_for_pt(E,ELA,Poslist,Actlist).


% Main routine of searching alternative actions.
% If LA is "null", there is no action for extra word.
search_alternative_actions1(_,null,_,_,[],[],NR1,NR2) :- !,
	NR1 = NR2.
% Otherwise, there is an action for extra word.
search_alternative_actions1(State,LA,Pos,Parent,[],[Key],NR1,NR2) :- !,
	push_error_info(State,LA,Pos,Parent,extra(LA),Key,NR1,NR2).

% There is no alternative action of which lookahead is LA.
search_alternative_actions1(State,LA,Pos,Parent,[LA|Terms],Acts,NR1,NR2) :- !,
	search_alternative_actions1(State,LA,Pos,Parent,Terms,Acts,NR1,NR2).
% There is no alternative action of which lookahead is "null".
search_alternative_actions1(State,LA,Pos,Parent,[null|Terms],Acts,NR1,NR2) :- !,
	search_alternative_actions1(State,LA,Pos,Parent,Terms,Acts,NR1,NR2).

% If LA is "null", there are only actions for the omitted error.
search_alternative_actions1(State,null,Pos,Parent,
	                    [Term|Terms],[Act|Acts],NR1,NR2) :-
	is_defined(State,Term,_),
	push_error_info(State,null,Pos,Parent,omit(Term),Act,NR1,NR3),

	search_alternative_actions1(State,null,Pos,Parent,Terms,Acts,NR3,NR2).
% If LA is an unknown word, there are only actions for it.
search_alternative_actions1(State,uk,Pos,Parent,
	                    [Term|Terms],[Act|Acts],NR1,NR2) :-
	is_defined(State,Term,_),
	push_error_info(State,uk,Pos,Parent,unknown(Term),Act,NR1,NR3),
	search_alternative_actions1(State,uk,Pos,Parent,Terms,Acts,NR3,NR2).
% Otherwise, there are actions for the substituted and the omitted error.
search_alternative_actions1(State,LA,Pos,Parent,
	                    [Term|Terms],[Act1,Act2|Acts],NR1,NR2) :-
	is_defined(State,Term,_),
	push_error_info(State,LA,Pos,Parent,subst(Term),Act1,NR1,NR3),
	push_error_info(State,LA,Pos,Parent,omit(Term),Act2,NR3,NR4),
	search_alternative_actions1(State,LA,Pos,Parent,Terms,Acts,NR4,NR2).
% No definition at the state State and the lookahead Term.
search_alternative_actions1(State,LA,Pos,Parent,[_|Terms],Acts,NR1,NR2) :-
	search_alternative_actions1(State,LA,Pos,Parent,Terms,Acts,NR1,NR2).

%
search_alternative_actions_for_nt(E,ELA,Epos,NTs,Acts,NR1,NR2) :-
%	findall([X,St,Parent,NT],E^node(X,St-(Parent,Epos,_,NT,_)-E),S),
%	sort(S,NTinfos),
	NR1 = [node(Node)|_],
	findNTinfo(Node,Epos,NTinfos),
%	quicksort(S,NTinfos,n),
	search_alternative_actions2(ELA,Epos,NTs,NTinfos,Acts1,NR1,NR3),
	search_alternative_actions3(ELA,Epos,NTinfos,Acts2,NR3,NR2),
	append(Acts1,Acts2,Acts).

%
search_alternative_actions2(_,_,_,[],[],NR1,NR2) :- !,
	NR1 = NR2.
search_alternative_actions2(LA,Pos,NTs,[[Parent,State,_,_]|NTinfos],Actlist,
	NR1,NR2) :-
	search_alternative_actions2_1(LA,Pos,State,Parent,NTs,Acts1,NR1,NR3),
	append(Acts1,Acts2,Actlist),
	search_alternative_actions2(LA,Pos,NTs,NTinfos,Acts2,NR3,NR2).
search_alternative_actions2(LA,Pos,[_|NTinfos],Acts,NR1,NR2) :-
	search_alternative_actions2(LA,Pos,NTinfos,Acts,NR1,NR2).

%
search_alternative_actions2_1(_,_,_,_,[],[],NR1,NR2) :- !,
	NR1 = NR2.
search_alternative_actions2_1(LA,Pos,State,Parent,[NT|NTs],[Act|Acts],
	NR1,NR2) :-
	C=..[NT,State,_],
	call(C),
	push_error_info(State,LA,Pos,Parent,omit_nt(NT),Act,NR1,NR3),
	search_alternative_actions2_1(LA,Pos,State,Parent,NTs,Acts,NR3,NR2).
search_alternative_actions2_1(LA,Pos,State,Parent,[_|NTs],Acts,NR1,NR2) :-
	search_alternative_actions2_1(LA,Pos,State,Parent,NTs,Acts,NR1,NR2).

%
search_alternative_actions3(_,_,[],[],NR1,NR2) :- !,
	NR1 = NR2.
search_alternative_actions3(LA,Pos,[[_,_,Parents,NT]|NTinfos],Actlist,
	NR1,NR2) :- !,
	search_alternative_actions3_1(LA,Pos,NT,Parents,Acts1,NR1,NR3),
	append(Acts1,Acts2,Actlist),
	search_alternative_actions3(LA,Pos,NTinfos,Acts2,NR3,NR2).

%
search_alternative_actions3_1(_,_,_,[],[],NR1,NR2) :- !,
	NR1 = NR2.
search_alternative_actions3_1(LA,Pos,NT,[(Parent,_)|Parents],[Act|Acts],
	NR1,NR2) :-
	push_error_info([],LA,Pos,Parent,extra_nt(NT),Act,NR1,NR3),
	search_alternative_actions3_1(LA,Pos,NT,Parents,Acts,NR3,NR2).

% Display alternative actions.
display_alternative_action(Keys) :-
	display('    Alternative Actions:'),
	ttynl,
	tab(8),display('[ErrorNode,ErrorKind:ModifiedSymbol]'),
	ttynl,
	display_alternative_action1(Keys).

display_alternative_action1([]).
display_alternative_action1([Key|Tail]) :-
	tab(8),
	display('['),
	display(Key),
	display(','),
	node(Key,_-(_,_,error_info(E,_,_,_))-_),
	E=..[Kind,Sym],
	display(Kind),display(':'),display(Sym),
	display(']'),
	ttynl,
	display_alternative_action1(Tail).

%
display_progress1(Key,Kind,Sym) :- !,
	tab(8),
	display('['),
	display(Key),
	display(','),
	display(Kind),display(':'),display(Sym),
	display(']'),
	ttynl.

%
display_progress2([]) :-
	display('            No successful results.'),ttynl.
display_progress2(Results) :-
	display_results(Results).


% Record error information and return a pointer to it.
push_error_info(State,LA,Pos,Key_to_parent,Kind,Key,NR1,NR2) :-
	% State : State to which the parser goes back
	% LA    : Lookahead 
	% Pos   : Position to which the parser goes back
	% Key_to_parent : Pointer to the parent node
	% Kind  : Error kind
	% Key   : Pointer to the generated error node
%	node(Key_to_parent,_-_-E),
	NR1 = [node(Node),Shift,Error,errorinfo(EI),Prev,NN,en(EN1)],
	finderr(Node,Key_to_parent,E),
	E1 is E+1,!,
%	counter(error,Key),
	Key = EN1,
	EN2 is EN1+1,
	NR2 = [node(Node),Shift,Error,
	       errorinfo([[Key,Pos,State,LA,Key_to_parent,Kind,E1]|EI]),
	       Prev,NN,en(EN2)],
	assertz(error_info(Key,Pos,State,LA,Key_to_parent,Kind,E1)),
	inc(error).

% Execute alternative actions.
execute_alternative_actions(_,_,[],[],NR1,NR2) :- !,
	NR1 = NR2.
execute_alternative_actions(End_pos,End_sym,[F|T],Results,NR1,NR2)
	:- !,
	execute_alternative_actions1(F,R1,NR1,NR3),
	append(R1,R2,Results),!,
	execute_alternative_actions2(End_pos,End_sym,T,R2,NR3,NR2).

%
execute_alternative_actions1([Pos,State,LA,Acts],Results,NR1,NR2) :- !,
	(disp_progress,
	 display_error_point(State,Pos,LA,x),
	 display('    Alternative actions:'),ttynl
	;
	 true),!,
	execute_for_error_LA(Acts,Results,NR1,NR2).

%
execute_for_error_LA([],[],NR1,NR2) :- !,
	NR1 = NR2.
execute_for_error_LA([Key|Keys],Results,NR1,NR2) :- !,
	% Pick error information up.
%	error_info(Key,Pos,S,LA,Parent,Kind,E),
%        node(Key,S-(Parent,Pos,error_info(Kind,_,LA,_))-E),
%        node(Key,S-(Parent,Pos,[error_info(Kind,_,LA,_)|_])-E),
	% What is the error kind?
	NR1 = [_,_,_,errorinfo(EI)|_],
	finderrorinfo(EI,Key,Pos,S,LA,Parent,Kind,E),
	Kind=..[Error,Sym],
	(disp_progress,
	 display_progress1(Key,Error,Sym)
	;
	 true),
	select_action(Error,Sym,S,LA,Pos,E,Parent,_,Key,Node,NR1,NR3),
	(disp_progress,
	 print_results(Node)
	;
	 true),
%	print_results([Node]),
	append(Node,Nodes,Results),
	execute_for_error_LA(Keys,Nodes,NR3,NR2).

%
execute_alternative_actions2(_,_,[],[],NR1,NR2) :- !,
	NR1 = NR2.
execute_alternative_actions2(End_pos,End_sym,[[Pos,State,LA,Acts]|T],Results,
	NR1,NR2)
	:- !,
	(disp_progress,
	 display_error_point(State,Pos,LA,x),
	 display('    Alternative actions:'),ttynl
	;
	 true),!,
	execute_alternative_actions3(End_pos,End_sym,Acts,R1,NR1,NR3),
	append(R1,R2,Results),!,
	execute_alternative_actions2(End_pos,End_sym,T,R2,NR3,NR2).

%
execute_alternative_actions3(_,_,[],[],NR1,NR2) :- !,
	NR1 = NR2.
execute_alternative_actions3(End_pos,End_sym,[Key|Keys],Results,NR1,NR2) :- !,
	% Pick error information up.
%	error_info(Key,Pos,S,LA,Parent,Kind,E),
%        node(Key,S-(Parent,Pos,error_info(Kind,_,LA,_))-E),
%        node(Key,S-(Parent,Pos,[error_info(Kind,_,LA,_)|_])-E),
	% What is the error kind?
	NR1 = [_,_,_,errorinfo(EI)|_],
	finderrorinfo(EI,Key,Pos,S,LA,Parent,Kind,E),
	Kind=..[Error,Sym],
	(disp_progress,
	 display_progress1(Key,Error,Sym)
	;
	 true),
	select_action(Error,Sym,S,LA,Pos,E,Parent,Pos1,Key,N,NR1,NR3),
	Pos2 is Pos1+1,
	merge_node(N,N1),!,
	reparse(End_pos,End_sym,Pos2,N1,R1,NR3,NR4),
	(disp_progress,
	 print_results(R1)
	;
	 true),
	append(R1,R2,Results),!,
	execute_alternative_actions3(End_pos,End_sym,Keys,R2,NR4,NR2).

% Select an alternative action.
	% Substituted word error.
select_action(subst,RLA,State,_,Pos,Errors,Parent,Pos1,EP,N,NR1,NR2) :- !,
	execute_for_subst(State,RLA,Pos,Errors,Parent,EP,N,NR1,NR2),
	Pos1 is Pos+1.
	% Unknown word error.
select_action(unknown,RLA,State,_,Pos,Errors,Parent,Pos1,EP,N,NR1,NR2) :- !,
	execute_for_subst(State,RLA,Pos,Errors,Parent,EP,N,NR1,NR2),
	Pos1 is Pos+1.
	% Extra word error.
select_action(extra,_,_,_,_,Errors,Parent,Pos1,EP,N,NR1,NR2) :- !,
	execute_for_extra(Errors,Parent,EP,N,Pos1,NR1,NR2).
	% Omitted word error.
select_action(omit,RLA,State,LA,Pos,Errors,Parent,Pos1,EP,N,NR1,NR2) :- !,
	execute_for_omit(State,LA,RLA,Pos,Errors,Parent,EP,N,NR1,NR2),
	Pos1 is Pos+1.
select_action(omit_nt,NT,State,LA,Pos,Errors,Parent,Pos1,EP,N,NR1,NR2) :- !,
	execute_for_omit_nt(State,LA,NT,Pos,Errors,Parent,EP,N,NR1,NR2),
	Pos1 is Pos+1.
select_action(extra_nt,_,_,LA,Pos,Errors,Parent,Pos1,EP,N,NR1,NR2) :- !,
	execute_for_extra_nt(LA,Pos,Errors,Parent,EP,N,NR1,NR2),
	Pos1 is Pos+1.

% Execute an action for the substituted (or unknown) word error.
execute_for_subst(State,LA,Pos,E,Key,EP,N,NR1,NR2) :- !,
%execute_for_subst(State,LA,Pos,E,Key,[N]) :- !,
%	node(Key,State-T-_),
	NR1 = [node(Node)|_],
	findnode(Node,Key,State,T),
	is_defined(State,LA,Pred),
	C=..[Pred,EP,State,T,E,N,Pos,NR1,NR2],
%	C=..[Pred,State,T,E,N1,Pos],
	call(C).
%	N1=[N2],
%	put_word_in_node(N2,N).

% Execute an action for the extra word error.
execute_for_extra(E,Key,EP,N,Pos1,NR1,NR2) :- !,
%	node(Key,S-T-_),
	NR1 = [node(Node)|_],
	findnode(Node,Key,State,T),
	((T=(Keys,Pos,Repath,Sym,_)
	 ;
	  T=(Keys,Pos,Sym,_),
	  Repath=[]
	 ),
	 Pos1 is Pos+1,
	 unpack(State,Keys,Pos1,Repath,Sym,E,EP,N)
	;
	 T=[],
	 N=[0-[]-E],
	 Pos1=1),
	 NR1 = NR2.

% Execute an action for the extra nonterminal.
execute_for_extra_nt(LA,Pos,E,Key,EP,N,NR1,NR2) :- !,
%	node(Key,S-T-_),
	NR1 = [node(Node)|_],
	findnode(Node,Key,State,T),
	(T=(Keys,Pos1,Repath,Sym,_),
	 N0=[State-(Keys,Pos,Repath,Sym,EP)-E]
	;
	 T=(Keys,Pos1,Sym,_),
	 N0=[State-(Keys,Pos,Sym,EP)-E]
	;
	 T=[],
	 N0=[0-[]-E]
	),!,
	reparse_a_word(LA,Pos,N0,N,NR1,NR2).

%
execute_for_extra_nt1([],_,_,_,[],NR1,NR2) :- !,
	NR1 = NR2.
execute_for_extra_nt1([(Key,_)|Pts],Pos,E,EP,[N|Nodes],NR1,NR2) :-
%	node(Key,S-T-_),
	NR1 = [node(Node)|_],
	findnode(Node,Key,State,T),
	(T=(Keys,Pos1,Sym,_),
	 N=S-(Keys,Pos,Sym,EP)-E
	;
         T=(Keys,Pos1,Repath,Sym,_),
	 N=S-(Keys,Pos,Repath,Sym,EP)-E
	;
	 T=[],
	 N=0-[]-E
	),!,
	execute_for_extra_nt1(Pts,Pos,E,EP,Nodes,NR1,NR2).

% Unpack a merged node.
unpack(_,[],_,_,_,_,_,[]).
unpack(State,[Key|Keys],Pos,[Repath|Repaths],Sym,Error,EP,[Node|Nodes]) :- !,
	Node=State-(Key,Pos,[Repath],Sym,EP)-Error,
	unpack(State,Keys,Pos,Repaths,Sym,Error,EP,Nodes).
unpack(State,[Key|Keys],Pos,[],Sym,Error,EP,[Node|Nodes]) :- !,
	Node=State-(Key,Pos,Sym,EP)-Error,
	unpack(State,Keys,Pos,[],Sym,Error,EP,Nodes).

% Execute an action for the omitted word error.
execute_for_omit(State,LA0,LA1,Pos,E,Key,EP,N,NR1,NR2) :- !,
%	node(Key,State-T-_),
	NR1 = [node(Node)|_],
	findnode(Node,Key,State,T),
	is_defined(State,LA1,Pred),
	Pos1 is Pos-1,
	C1=..[Pred,EP,State,T,E,N1,Pos1,NR1,NR3],
	call(C1),
	merge_node(N1,N2),!,
	reparse_a_word(LA0,Pos,N2,N,NR3,NR2).

% Execute an action for the omitted nonterminal.
execute_for_omit_nt(State,LA,NT,Pos,E,Key,EP,N,NR1,NR2) :- !,
%	node(Key,State-T-_),
	NR1 = [node(Node)|_],
	findnode(Node,Key,_State,T),
	(T=(Parents,_,_,_,_),
	 sum_NOT(Parents,NOT)
	;
         T=(Parents,_,_,_),
         sum_NOT(Parents,NOT)
        ;
         T=[],
         NOT=1),
	C=..[NT,State,Goto],
	call(C),
	N1=[Goto-((Key,NOT),Pos,[[Key]],NT,EP)-E],
	merge_node(N1,N2),!,
	reparse_a_word(LA,Pos,N2,N,NR1,NR2).

%
sum_NOT([],0) :- !.
sum_NOT([(_,NOT0)|Parents],NOT) :-
	sum_NOT(Parents,NOT1),
	NOT is NOT0+NOT1.
	

% 'Re'parse a part of the sentence which the parser has once parsed.
reparse(_,_,_,[],[],NR1,NR2) :- !,
	NR1 = NR2.
reparse(End_pos,End_sym,End_pos,N,Results,NR1,NR2) :- !,
	reparse_a_word(End_sym,End_pos,N,Results,NR1,NR2).
reparse(End_pos,End_sym,Pos,N,Results,NR1,NR2) :- !,
%	find_original_node(Pos,Key,S-(Pt,_,Sym,_)-E),!,
	NR1 = [node(Node)|_],
	find_original_node(Node,Pos,Key,ONode),!,
	ONode = S-(Pt,_,Sym,_)-E,
	reparse_a_word(Sym,Pos,N,N1,NR1,NR3),
	mergep(S-(Pt,Pos,Sym)-E,N1,P,IP),
	Pos1 is Pos+1,
	additional_merge(Key,P,OP,NP,NR3,NR4),              % It's possible
	after_merge(End_pos,End_sym,Pos1,OP,NP,R1,NR4,NR5), % to merge.
	append(R1,R2,Results),
	merge_node(IP,N2),                              % It's impossible
	reparse(End_pos,End_sym,Pos1,N2,R2,NR5,NR2).    % to merge.
	

%
after_merge(End_pos,_,End_pos,_,_,[],NR1,NR2) :- !,
	NR1 = NR2.
after_merge(_,_,_,[],[],[],NR1,NR2) :- !,
	NR1 = NR2.
after_merge(End_pos,End_sym,Pos,OP,NP,Results,NR1,NR2) :-
%after_merge(End_pos,End_sym,Pos,OP,NP,R1) :-
%	find_original_path(Pos,OP,Opaths),
	NR1 = [node(Node)|_],
	find_original_path(Node,Pos,OP,Opaths),
	make_new_paths(Opaths,OP,NP,Npaths),
	merge_node(Npaths,N1),
%	find_original_node(Pos,_,_-(_,_,Sym)-_),
%	reparse_a_word(Sym,Pos,N1,N2),
	Pos1 is Pos+1,
%	merge_node(N2,N3),
	reparse(End_pos,End_sym,Pos1,N1,R1,NR1,NR3),
	append(R1,R2,Results),
	after_merge(End_pos,End_sym,Pos1,OP,NP,R2,NR3,NR2).
after_merge(End_pos,End_sym,Pos,OP,NP,Results,NR1,NR2) :- !,
	Pos1 is Pos+1,
	after_merge(End_pos,End_sym,Pos1,OP,NP,Results,NR1,NR2).


%
find_original_path(Pos,OP,Keys) :- !,
	bagof([Key,P],S^Re^Sym^node(Key,S-(P,Pos,Re,Sym)-0),N),!,
	included(OP,N,Keys).
find_original_path([],_,_,[]) :- !.
find_original_path([Node|Nodes],Pos,OP,[Key|Keys]) :-
	Node=[Key,_-(Parent,Pos,_,_)-0],
	included(OP,[[Key,Parent]],Key),
	find_original_path(Nodes,Pos,OP,Keys).
find_original_path([_|Nodes],Pos,OP,Keys) :-
	find_original_path(Nodes,Pos,OP,Keys).

%
included(_,[],[]) :- !.
included(OP,[[Key,P]|T],[Key|Keys]) :-
	included1(OP,P),
	included(OP,T,Keys).
included(OP,[_|T],Keys) :- !,
	included(OP,T,Keys).

%
included1([],_) :- !,fail.
included1([F|_],L) :-
	member(F,L).
included1([_|T],L) :-
	included(T,L).

%
member(A,[A|_]) :- !.
member(A,[_|L]) :-
	member(A,L).

%
make_new_paths([],_,_,[]) :- !.
make_new_paths([F|T],OP,NP,Nodes) :- !,
	make_new_paths1(F,OP,NP,N1),
	append(N1,N2,Nodes),
	make_new_paths(T,OP,NP,N2).

%
make_new_paths1(Opath,OP,NP,Npaths) :- !,
	node(Opath,_-(_,Pos,Repath,Sym)-E),
	select_reduce_path(Repath,OP,Child),
	make_new_paths2(NP,Pos,Child,Sym,E,Npaths).

%
make_new_paths2([],_,_,_,_,[]) :- !.
make_new_paths2([F|T],Pos,Child,Sym,E,[Node|Nodes]) :- !,
	node(F,S-_-_),
	C=..[Sym,S,S1],
	call(C),
	E1 is E+1,
	Node=S1-(F,Pos,[[F|Child]],Sym)-E1,
	make_new_paths2(T,Pos,Child,Sym,E,Nodes).

%
select_reduce_path([],_,[]) :- !.
select_reduce_path([[F|Child]|_],[F|_],Child) :- !.
select_reduce_path([_|Path],OP,Child) :- !,
	select_reduce_path(Path,OP,Child).

%
find_original_node(Pos,Okey,S-(P,Pos,Sym,EP)-E) :- !,
%	shift_info(Sym,_,Pos,_,S,0,_),
	node(Okey,S-(P,Pos,Sym,EP)-E).
find_original_node([],_,[],[]) :- !.
find_original_node([Node|Nodes],Pos,Okey,ONode) :-
	Node=[Okey,S-(P,Pos,Sym,EP)-E],
	ONode=S-(P,Pos,Sym,EP)-E.
find_original_node([_|Nodes],Pos,Okey,ONode) :-
	find_original_node(Nodes,Pos,Okey,ONode).

%
mergep(_,[],[],[]) :- !.
mergep(Orig,[F|T],[F|P],IP) :-
	mergep1(Orig,F),
	mergep(Orig,T,P,IP).
mergep(Orig,[F|T],P,[F|IP]) :-
	mergep(Orig,T,P,IP).

%
mergep1(S-(P1,Pos,Sym)-_,S-(_,Pos,Sym)-_) :-
	mergep2(P1).


%
mergep2([]) :-
	!,fail.
mergep2([F|_]) :-
	node(F,_-(_,_,_,_)-_).
mergep2([_|T]) :- !,
	mergep2(T).

% Add a parent of the new node to the node with Key.
additional_merge(_,[],[],[],NR1,NR2) :- !,
	NR1 = NR2.
additional_merge(Okey,Newlist,OP,NP,NR1,NR2) :- !,
	collect_parent_nodes(Newlist,NP),
	append(OP,NP,P),
	additional_merge1(Okey,P,NR1,NR2).
%	retract(node(Okey,S-(OP,Pos,Sym)-E)),
%	append(OP,NP,P),
%	assertz(node(Okey,S-(P,Pos,Sym)-E)).

additional_merge1(Okey,P,NR1,NR2) :-
	NR1 = [node(Node)|Rest],
	additional_merge2(Okey,P,Node,NewNode),
	NR2 = [node(NewNode)|Rest].

additional_merge2(_,_,[],[]) :- !.
additional_merge2(Okey,P,[Node|Nodes],[NewNode|Nodes]) :- !,
	Node=[Okey,S-(_,Pos,Sym)-E],
	NewNode=[Okey,S-(P,Pos,Sym)-E].
additional_merge2(Okey,P,[Node|Nodes],[Node|NewNodes]) :-
	additional_merge2(Okey,P,Nodes,NewNodes).

%
collect_parent_nodes([],[]) :- !.
collect_parent_nodes([_-(P,_,_)-_|T],[P|P1]) :- !,
	collect_parent_nodes(T,P1).

%
reparse_a_word(Sym,Pos,N,Results,NR1,NR2) :-
	Pos1 is Pos-1,
	C=..[Sym,e,n,N,Results,Pos1,NR1,NR2],!,
	call(C).



% Record error informations
record_error_info(Key) :- !,
	%Key : Pointer to current node (at error occurring)
	abolish(stack_top_at_error/1),
        asserta(stack_top_at_error(Key)),
	errors(N),
	N1 is N+1,
	abolish(errors/1),
	asserta(errors(N1)).

record_error_info(Key,NR1,NR2) :- !,
	%Key : Pointer to current node (at error occurring)
	abolish(stack_top_at_error/1),
        asserta(stack_top_at_error(Key)),
	NR1 = [NodeInfo,Shift,error([_,N|ErrInfo])|NR11],
	errors(N),
	N1 is N+1,
	abolish(errors/1),
	asserta(errors(N1)),
	NR2 = [NodeInfo,Shift,error([Key,N1|ErrInfo])|NR11].

% (temporal) Print rezults.
print_results([]) :-
	display('            No successful results.'),
	ttynl.
print_results(Results) :-
	display('            Results:'),
	ttynl,
	print_results1(Results).

print_results1([]).
print_results1([Result|Results]) :-
	(Result=S-T-E,
	 tab(16),display('['),
	 display(S),
	 (T=[],
	  display('-[]-')
	 ;
	  display('-('),
%	  (T=(K,P,[Sym,Word]), 
	  (T=(K,P,Sym), 
	   display(K),display(','),
	   display(P),display(','),
%	   display(Sym),display(':'),display(Word)
	   display(Sym)
	  ;
	   T=(K,P,R,Sym),
	   display(K),display(','),
	   display(P),display(','),
	   display(R),display(','),
	   display(Sym)
	  ),
	  display(')-')
	 ),
	 display(E),
	 display(']'),ttynl
	;
	 (integer(Result)
	 ;
	  Result=(_,_)),
	 tab(16),
	 display('Successful Parse: '),
	 display('['),
	 display(Result),
	 display(']'),
	 ttynl),
	print_results1(Results).

% Record results of successful parses.
add_results(State,Pos,LA,Result) :- !,
	assertz(result_info(State,Pos,LA,Result)).

%
reset_informations :-
	reset_shift_info,
	reset_reduce_info.

%
reset_shift_info :-
	repeat,
	\+(reset_shift_info1).

%
reset_shift_info1 :-
	shift_info(Sym,Left,Right,From,To,0,Check),
	!,\+(Check=0),
	retract(shift_info(Sym,Left,Right,From,To,0,Check)),
	assertz(shift_info(Sym,Left,Right,From,To,0,0)).

%
reset_reduce_info :-
	repeat,
	\+(reset_reduce_info1).

%
reset_reduce_info1 :- !,
	reduce_info([Sym,Repath],Left,Right,From,To,0,Check),
	!,\+(Check=0),
	retract(reduce_info([Sym,Repath],Left,Right,From,To,0,Check)),
	assertz(reduce_info([Sym,Repath],Left,Right,From,To,0,0)).


%
set_checked_most_right_pos(Pos) :- !,
	checked_most_right_pos(Pos1),
	retract(checked_most_right_pos(Pos1)),
	asserta(checked_most_right_pos(Pos)).
set_checked_most_right_pos(Pos,NR1,NR2) :- !,
	NR1 = [Node,Shift,Error,ErrorInfo,_,NN,EN],
	NR2 = [Node,Shift,Error,ErrorInfo,Pos,NN,EN].

%
check_most_right_pos(_,[],[]) :- !.
check_most_right_pos(MRP,[P|T],[P|PL]) :-
	MRP < P,
	check_most_right_pos(MRP,T,PL).
check_most_right_pos(MRP,[_|T],PL) :-
	check_most_right_pos(MRP,T,PL).


% Find position .... 1996/2/27

findpos1(_Pos,Ptslist,[]) :- !, Ptslist=[].
findpos1(Pos,Ptslist,[[_,_-(Pts,Pos,_,_,_)-_]|NR1]) :-
	Ptslist=[Pts|Ptslist1],
	findpos1(Pos,Ptslist1,NR1).
findpos1(Pos,Ptslist,[_|NR1]) :-
	findpos1(Pos,Ptslist,NR1).

findpos2([[Pt,_-(_,Pos1,_,_,_)-_]|_Node],Pt,Pos) :- 
	!, Pos=Pos1.
findpos2([[Pt,_-(_,Pos1,_,_)-_]|_Node],Pt,Pos) :- 
	!, Pos=Pos1.
findpos2([[Pt,0-[]-_]|_Node],Pt,Pos) :- 
	!, Pos=0.
findpos2([_|Node],Pt,Pos) :- 
	!, findpos2(Node,Pt,Pos).

findpos3([[Pt,_-(_,Pos,_,_,_)-_]|_Node],Pt,OPos) :- 
	!, OPos=Pos.
findpos3([_|Node],Pt,OPos) :- 
	findpos3(Node,Pt,OPos).

findpos4([],_EPos,OKey,OState) :-  !, OKey=0, OState=0.
findpos4([[Key,State-(_,EPos,_,_)-_]|_Node],EPos,OKey,OState) :-
	!, OKey=Key, OState=State.
findpos4([_|Node],EPos,OKey,OState) :-
	findpos4(Node,EPos,OKey,OState).

findlkhd([[_,_-(_,Pos,LA,_)-E]|_Node],Pos,OLA,OE) :-
	!, OLA=LA, OE=E.
findlkhd([_|Node],Pos,OLA,OE) :-
	findlkhd(Node,Pos,OLA,OE).

finderr([[Key,_-_-E]|_Node],Key,OE) :-
	!, OE=E.
finderr([_|Node],Parent,OE) :-
	finderr(Node,Parent,OE).

findNTinfo([],_,[]) :- !.
findNTinfo([[Key,St-(Parent,Pos,_,NT,_)-_]|Node],Pos,
	[[Key,St,Parent,NT]|NTinfos]) :-
        findNTinfo(Node,Pos,NTinfos).
findNTinfo([_|Node],Pos,NTinfos) :-
	findNTinfo(Node,Pos,NTinfos).

finderrorinfo([[Key,Pos,S,LA,Parent,Kind,E]|_],Key,
	Pos,S,LA,Parent,Kind,E) :- !.
finderrorinfo([_|EI],Key,Pos,S,LA,Parent,Kind,E) :-
	finderrorinfo(EI,Key,Pos,S,LA,Parent,Kind,E).

findnode([[Key,State-T-_]|_],Key,OState,OT) :- !,
	OState = State, OT = T.
findnode([_|Node],Key,OState,OT) :-
	findnode(Node,Key,OState,OT).

quicksort(Xs,Ys,N) :- !,
	qsort(Xs,Ys,[],N).
qsort([],Ys0,Ys1,_N) :- !,
	Ys0=Ys1.
qsort([X|Xs],Ys0,Ys3,n) :- !,     % n = normal
	partition(Xs,X,S,L),qsort(S,Ys0,Ys1,n),
	Ys1 = [X|Ys2], qsort(L,Ys2,Ys3,n).
qsort([X|Xs],Ys0,Ys3,r) :- !,     % r = reverse
	partition1(Xs,X,S,L),qsort(S,Ys0,Ys1,r),
	Ys1 = [X|Ys2], qsort(L,Ys2,Ys3,r).

partition([],_P,S,L) :- !, S=[], L=[].
partition([X|Xs],P,S,L) :- 
	X<P, S=[X|S0], partition(Xs,P,S0,L).
partition([X|Xs],P,S,L) :- 
	X>=P, L=[X|L0], partition(Xs,P,S,L0).

partition1([],_P,S,L) :- !, S=[], L=[].
partition1([X|Xs],P,S,L) :- 
	X>=P, S=[X|S0], partition1(Xs,P,S0,L).
partition1([X|Xs],P,S,L) :- 
	X<P, L=[X|L0], partition1(Xs,P,S,L0).

