%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
% The file contains some specifications for RLRPAR          	     
%
%
%           action2entry.pl
%
%       Translate a table file into entry-clauses.
%
%       $Id: action2entry.pl,v 1.4 1993/12/28 07:02:46 imai Exp imai $
%
%       $Log: action2entry.pl,v $
% Revision 1.4  1993/12/28  07:02:46  imai
% Changed a basic design.
%     Modified entry clauses to execute an error handling after
%     the parser fails in all stacks for a state.
%
% Revision 1.3  1993/12/16  07:55:22  imai
% 1. Added a predicate 'terminal/1', which has a list of all
%    terminal symbols.
% 2. Added a predicate 'is_defined/3', which indicates if an action
%    is defined in a state and a LA. It is used for searching
%    actions after the parser failed.
% 3. Modidied entry clauses to avoid useless parsing.
%
% Revision 1.2  1993/11/08  11:20:41  imai
% Added 'record_shift_info/1' to
% 	'make_shift_entry/3','make_reduce_entry/3',and
% 	'shift_reduce_conflict/4'.
%
%
%
% action to entry

% it uses 'wildcard' for variable.

:- dynamic(length_of_rule_and_last/2).

action2entry(Terminals):-
	terminal2category(Terminals),
	record_terminal_symbols(Terminals),
	see('table'),
	action2entry1,
	seen.

action2entry1:-
% shift-reduce(s) conflict or shift
	((see_shift(Terminal,State,New_state),
	  see_reduces(Terminal,State,Rules),
 	  (Rules==[] -> make_shift_entry(Terminal,State,New_state);
	   shift_reduce_conflict(Terminal,State,New_state,Rules))),
	  % record a pair of State and Terminal.
	  record_is_defined(Terminal,State);
% reduce-reduce conflict or reduce
% (shift-reduce conflict is included in shift-reduce(s) conflict)
	 (see_reduce(Terminal,State,Rule_number),
	  see_reduces(Terminal,State,Rules),
	  (Rules==[] -> make_reduce_entry(Terminal,State,Rule_number);
	   reduce_reduce_conflict(Terminal,State,Rule_number,Rules))),
	  % record a pair of State and Terminal.
	  record_is_defined(Terminal,State);
% goto-goto conflict
% strictly speaking, it is NOT conflict.
% (because we can choice one of them by Precedent)
	 (see_goto(Non_terminal,State,Precedent,New_state),
	  see_gotos(Non_terminal,State,Rules),
	  (Rules==[] -> 
	    make_goto_entry(Non_terminal,State,(Precedent,New_state));
	   goto_goto_conflict(Non_terminal,State,
	                      (Precedent,New_state),Rules)))),
	action2entry1.
action2entry1:-!.

terminal2category([]).
terminal2category([Pt|Tail]):-
	write(Pt),write('(F,EP,Node,N,Posi,NR1,NR2):-'),nl,
	tab(4),write(Pt),write('0(EP,Node,N1,Posi,NR1,NR3),'),nl,
	tab(4),write('(N1=[],!,error_handling(F,'),
	write(Pt),write(',Node,N,NR3,NR2);N=N1,NR2=NR3).'),nl,
	write(Pt),write('0(_,[],[],_,NR1,NR2):-!, NR2=NR1.'),nl,
	write(Pt),write('0(EP,[S-L-E|T],N,Posi,NR1,NR2):-'),nl,
	tab(4),write(Pt),write('_(EP,S,L,E,N1,Posi,NR1,NR3),'),nl,
	tab(5),write('append(N1,N2,N),!,'),nl,
	tab(5),write(Pt),write('0(EP,T,N2,Posi,NR3,NR2).'),nl,
	terminal2category(Tail).

see_reduces(Terminal,State,[Rule_number|Rule_numbers]):-
	see_reduce(Terminal,State,Rule_number),!,
	see_reduces(Terminal,State,Rule_numbers).
see_reduces(_,_,[]):-!.

see_gotos(Non_terminal,State,[(Precedent,New_state)|Tail]):-
	see_goto(Non_terminal,State,Precedent,New_state),!,
	see_gotos(Non_terminal,State,Tail).
see_gotos(_,_,[]):-!.

see_shift(Terminal,State,New_state):-
	read_action([State,Terminal,1,New_state]).

see_reduce(Terminal,State,Rule):-
	read_action([State,Terminal,2,Rule]).

see_goto(Non_terminal,State,Precedent,New_state):-
	read_action([State,Non_terminal,3,Precedent,New_state]).

% if recorded, use it.
read_action(List):-
	((recorded(read_action,[Action],Key),!,Action=List,erase(Key));
	 (read(Action),((Action=List,!);
	                (recordz(read_action,[Action],_),fail)))).

%make_shift_entry(Pt,State,New_state):-
%	write(Pt),write('_('),write(State),write(',L,['),
%	write(New_state),write('-(K,'),write(Pt),write(')],_):-!,'),nl,
%	tab(4),write('push('),write(State),write('-L,K).'),nl.
%
% add the position of a shift word to the stack info.
make_shift_entry(Pt,State,New_state):-
	write(Pt),write('_(EP,'),write(State),write(',L,E,['),
	write(New_state),write('-((K,1),Right,'),
	write(Pt),write(',EP)-E],Posi,NR1,NR2):-!,'),nl,
	tab(4),write('Right is Posi+1,'),nl,
	tab(4),write('push('),write(State),write('-L-E,K,NR1,NR2).'),
	nl.

make_reduce_entry(Pt,State,Rule):-
	write(Pt),write('_(EP,'),write(State),
	write(',L,E,N,Posi,NR1,NR2):-!,'),nl,
	tab(4),write('push('),write(State),write('-L-E,K,NR1,NR3),'),
	nl,
%	tab(4),write('record_shift_info('),write(State),write('-L-E,NR3,NR4),'),nl,
	tab(4),write('re('),write(Rule),write(','),
	length_of_rule_and_last(Rule,Length),
	write(Length),write(',E,K,n,N1,Posi,NR3),'),nl,
	tab(4),write('merge_node(N1,N0),'),nl,
	tab(4),write(Pt),write('0(EP,N0,N,Posi,NR3,NR2).'),nl.

length_of_rule_and_last(Rule,Length):-!,
        (rule(_,[_,Lookahead,Rule,RHS]);
         rule(_,[Lookahead,Rule,RHS])),
	list_length(RHS,Length),
	asserta((length_of_rule_and_last(Rule,Length):-!)).

make_reduce([],Number):-!,
	tab(4),write('append_n(['),
	write_vars_for_append_n(1,Number),
	write('],N_n),'),nl,
	tab(4),write('merge_node(N_n,N0),'),nl.

write_vars_for_append_n(Number,2):-!,
        write('N'),write(Number).

write_vars_for_append_n(Number_up,Number_down):-!,
        write('N'),write(Number_up),write(','),
        Number_up1 is Number_up+1,
        Number_down1 is Number_down-1,
        write_vars_for_append_n(Number_up1,Number_down1).

make_reduce([Rule|Tail],Number):-!,
	length_of_rule_and_last(Rule,Length),
	tab(4),
	write('re('),
	write(Rule),
	write(','),
	write(Length),
	write(',E,K,n,N'),
	write(Number),
	write(',Posi,NR3),'),nl,
	Number1 is Number+1,
	make_reduce(Tail,Number1).

% start shift_reduce conflict
% sh/re
shift_reduce_conflict(Pt,State,New_state,[Rule]):-!,
	write(Pt),write('_(EP,'),write(State),write(',L,E,['),write(New_state),
	write('-((K,1),Right,'),write(Pt),write(',EP)-E|N],Posi,NR1,NR2):-!,'),nl,
	tab(4),write('Right is Posi+1,'),nl,
	tab(4),write('push('),write(State),write('-L-E,K,NR1,NR3),'),
	nl,
	tab(4),write('re('),write(Rule),write(','),
	length_of_rule_and_last(Rule,Length),
	write(Length),write(',E,K,n,N1,Posi,NR3),'),nl,
	tab(4),write('merge_node(N1,N0),'),nl,
	tab(4),write(Pt),write('0(EP,N0,N,Posi,NR3,NR2).'),nl.

% re/re
reduce_reduce_conflict(Pt,State,Rule,Rules):-
	write(Pt),write('_(EP,'),write(State),
	write(',L,E,N,Posi,NR1,NR2):-!,'),nl,
	tab(4),write('push('),write(State),write('-L-E,K,NR1,NR3),'),
	nl,
	make_reduce([Rule|Rules],1),
	tab(4),write(Pt),write('0(EP,N0,N,Posi,NR3,NR2).'),nl.

% sh/re/re..
shift_reduce_conflict(Pt,State,New_state,Rules):-
	write(Pt),write('_(EP,'),write(State),write(',L,E,['),write(New_state),
	write('-((K,1),Right,'),write(Pt),write(',EP)-E|N],Posi,NR1,NR2):-!,'),nl,
	tab(4),write('Right is Posi+1,'),nl,
	tab(4),write('push('),write(State),write('-L-E,K,NR1,NR3),'),nl,
	make_reduce(Rules,1),
	tab(4),write(Pt),write('0(EP,N0,N,Posi,NR3,NR2).'),nl.

% goto
make_goto_entry(Nt,State,(_,New_state)):-
	write(Nt),write('('),write(State),write(','),write(New_state),
	write('):-!.'),nl.

% record terminal_symbols to 'terminal/1'.
record_terminal_symbols([S|T]) :-
	write('terminal(['),
	write(S),
	record_terminal_symbols1(T).

record_terminal_symbols1([]) :-
	write(']).'),nl.
record_terminal_symbols1([S|T]) :-
	write(','),
	write(S),
	record_terminal_symbols1(T).

% record a pair of a state and terminal.
record_is_defined(Symbol,State) :-
	write('is_defined('),write(State),write(','),
	write(Symbol),write(','),
	write(Symbol),write('_).'),nl.
